/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.service.client;

import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.client.ReferenceClient;
import com.alipay.sofa.runtime.api.client.param.BindingParam;
import com.alipay.sofa.runtime.api.client.param.ReferenceParam;
import com.alipay.sofa.runtime.api.component.ComponentName;
import com.alipay.sofa.runtime.model.InterfaceMode;
import com.alipay.sofa.runtime.service.binding.JvmBinding;
import com.alipay.sofa.runtime.service.component.Reference;
import com.alipay.sofa.runtime.service.component.ReferenceComponent;
import com.alipay.sofa.runtime.service.component.impl.ReferenceImpl;
import com.alipay.sofa.runtime.service.helper.ReferenceRegisterHelper;
import com.alipay.sofa.runtime.spi.binding.BindingAdapterFactory;
import com.alipay.sofa.runtime.spi.component.ComponentInfo;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.service.BindingConverter;
import com.alipay.sofa.runtime.spi.service.BindingConverterContext;
import com.alipay.sofa.runtime.spi.service.BindingConverterFactory;
import com.alipay.sofa.runtime.spi.util.ComponentNameFactory;
import java.util.Collection;

public class ReferenceClientImpl
implements ReferenceClient {
    private SofaRuntimeContext sofaRuntimeContext;
    private BindingConverterFactory bindingConverterFactory;
    private BindingAdapterFactory bindingAdapterFactory;

    public ReferenceClientImpl(SofaRuntimeContext sofaRuntimeContext, BindingConverterFactory bindingConverterFactory, BindingAdapterFactory bindingAdapterFactory) {
        this.sofaRuntimeContext = sofaRuntimeContext;
        this.bindingConverterFactory = bindingConverterFactory;
        this.bindingAdapterFactory = bindingAdapterFactory;
    }

    private <T> Reference getReferenceFromReferenceParam(ReferenceParam<T> referenceParam) {
        BindingParam bindingParam = referenceParam.getBindingParam();
        ReferenceImpl reference = new ReferenceImpl(referenceParam.getUniqueId(), referenceParam.getInterfaceType(), InterfaceMode.api, referenceParam.isJvmFirst(), null);
        if (bindingParam == null) {
            reference.addBinding(new JvmBinding());
        } else {
            BindingConverter bindingConverter = this.bindingConverterFactory.getBindingConverter(bindingParam.getBindingType());
            if (bindingConverter == null) {
                throw new ServiceRuntimeException("Can not found binding converter for binding type " + bindingParam.getBindingType());
            }
            BindingConverterContext bindingConverterContext = new BindingConverterContext();
            bindingConverterContext.setInBinding(true);
            bindingConverterContext.setAppName(this.sofaRuntimeContext.getAppName());
            bindingConverterContext.setAppClassLoader(this.sofaRuntimeContext.getAppClassLoader());
            Object binding = bindingConverter.convert(bindingParam, bindingConverterContext);
            reference.addBinding(binding);
        }
        return reference;
    }

    @Override
    public <T> T reference(ReferenceParam<T> referenceParam) {
        return (T)ReferenceRegisterHelper.registerReference(this.getReferenceFromReferenceParam(referenceParam), this.bindingAdapterFactory, this.sofaRuntimeContext);
    }

    @Override
    public <T> void removeReference(ReferenceParam<T> referenceParam) {
        Reference reference = this.getReferenceFromReferenceParam(referenceParam);
        ComponentName referenceComponentName = ComponentNameFactory.createComponentName(ReferenceComponent.REFERENCE_COMPONENT_TYPE, reference.getInterfaceType(), reference.getUniqueId() + "#" + ReferenceRegisterHelper.generateBindingHashCode(reference));
        Collection<ComponentInfo> referenceComponents = this.sofaRuntimeContext.getComponentManager().getComponentInfosByType(ReferenceComponent.REFERENCE_COMPONENT_TYPE);
        for (ComponentInfo referenceComponent : referenceComponents) {
            if (!referenceComponent.getName().equals(referenceComponentName)) continue;
            this.sofaRuntimeContext.getComponentManager().unregister(referenceComponent);
        }
    }

    @Override
    public void removeReference(Class<?> interfaceClass) {
        this.removeReference(interfaceClass, "");
    }

    @Override
    public void removeReference(Class<?> interfaceClass, String uniqueId) {
        Collection<ComponentInfo> referenceComponents = this.sofaRuntimeContext.getComponentManager().getComponentInfosByType(ReferenceComponent.REFERENCE_COMPONENT_TYPE);
        for (ComponentInfo componentInfo : referenceComponents) {
            ReferenceComponent referenceComponent;
            if (!(componentInfo instanceof ReferenceComponent) || (referenceComponent = (ReferenceComponent)componentInfo).getReference().getInterfaceType() != interfaceClass || !referenceComponent.getReference().getUniqueId().equals(uniqueId)) continue;
            this.sofaRuntimeContext.getComponentManager().unregister(referenceComponent);
        }
    }
}

