/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.health;

import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.health.RuntimeHealthChecker;
import com.alipay.sofa.runtime.spring.health.MultiApplicationHealthIndicator;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultRuntimeHealthChecker
implements RuntimeHealthChecker,
ApplicationContextAware {
    private Map<String, HealthIndicator> indicatorMap;
    private ApplicationContext cxt;

    public DefaultRuntimeHealthChecker(SofaRuntimeContext sofaRuntimeContext) {
        sofaRuntimeContext.getSofaRuntimeManager().registerRuntimeHealthChecker(this);
    }

    @Override
    public boolean isHealth() {
        if (this.indicatorMap == null) {
            this.indicatorMap = this.cxt.getBeansOfType(HealthIndicator.class);
        }
        for (HealthIndicator healthIndicator : this.indicatorMap.values()) {
            if (healthIndicator instanceof MultiApplicationHealthIndicator || !healthIndicator.health().getStatus().equals((Object)Status.DOWN)) continue;
            return false;
        }
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.cxt = applicationContext;
    }
}

