/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.bolt;

import com.alipay.remoting.DefaultCustomSerializer;
import com.alipay.remoting.InvokeContext;
import com.alipay.remoting.exception.DeserializationException;
import com.alipay.remoting.exception.SerializationException;
import com.alipay.remoting.rpc.RequestCommand;
import com.alipay.remoting.rpc.ResponseCommand;
import com.alipay.remoting.rpc.protocol.RpcProtocol;
import com.alipay.remoting.rpc.protocol.RpcRequestCommand;
import com.alipay.remoting.rpc.protocol.RpcResponseCommand;
import com.alipay.sofa.rpc.codec.Serializer;
import com.alipay.sofa.rpc.codec.SerializerFactory;
import com.alipay.sofa.rpc.codec.bolt.SimpleMapSerializer;
import com.alipay.sofa.rpc.common.cache.ReflectCache;
import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.common.utils.CodecUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.request.RequestBase;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ByteArrayWrapperByteBuf;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SofaRpcSerialization
extends DefaultCustomSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SofaRpcSerialization.class);
    protected SimpleMapSerializer mapSerializer;

    public SofaRpcSerialization() {
        this.init();
    }

    protected void init() {
        this.mapSerializer = new SimpleMapSerializer();
    }

    public <Response extends ResponseCommand> boolean serializeHeader(Response response) throws SerializationException {
        if (response instanceof RpcResponseCommand) {
            RpcInternalContext.getContext().getStopWatch().tick();
            Object responseObject = ((RpcResponseCommand)response).getResponseObject();
            if (responseObject instanceof SofaResponse) {
                SofaResponse sofaResponse = (SofaResponse)responseObject;
                if (sofaResponse.isError() || sofaResponse.getAppResponse() instanceof Throwable) {
                    sofaResponse.addResponseProp("sofa_head_response_error", "true");
                }
                byte[] header = null;
                try {
                    header = this.mapSerializer.encode(sofaResponse.getResponseProps());
                }
                catch (Exception e) {
                    String traceId = (String)RpcInternalContext.getContext().getAttachment("_trace_id");
                    String rpcId = (String)RpcInternalContext.getContext().getAttachment("_span_id");
                    LOGGER.error("traceId={}, rpcId={}, Response serializeHeader exception, msg={}", traceId, rpcId, e.getMessage(), e);
                    throw new SerializationException(e.getMessage() + ", traceId=" + traceId + ", rpcId=" + rpcId, (Throwable)e);
                }
                response.setHeader(header);
            }
            return true;
        }
        return false;
    }

    public <Request extends RequestCommand> boolean serializeHeader(Request request, InvokeContext invokeContext) throws SerializationException {
        if (request instanceof RpcRequestCommand) {
            RpcInternalContext.getContext().getStopWatch().tick();
            RpcRequestCommand requestCommand = (RpcRequestCommand)request;
            Object requestObject = requestCommand.getRequestObject();
            String service = this.getTargetServiceName(requestObject);
            if (StringUtils.isNotEmpty(service)) {
                HashMap<String, String> header = new HashMap<String, String>(16);
                header.put("service", service);
                this.putRequestMetadataToHeader(requestObject, header);
                requestCommand.setHeader(this.mapSerializer.encode(header));
            }
            return true;
        }
        return false;
    }

    protected void putRequestMetadataToHeader(Object requestObject, Map<String, String> header) {
        if (requestObject instanceof RequestBase) {
            RequestBase requestBase = (RequestBase)requestObject;
            header.put("sofa_head_method_name", requestBase.getMethodName());
            header.put("sofa_head_target_service", requestBase.getTargetServiceUniqueName());
            if (requestBase instanceof SofaRequest) {
                SofaRequest sofaRequest = (SofaRequest)requestBase;
                header.put("sofa_head_target_app", sofaRequest.getTargetAppName());
                Map<String, Object> requestProps = sofaRequest.getRequestProps();
                if (requestProps != null) {
                    CodecUtils.flatCopyTo("", requestProps, header);
                }
            }
        }
    }

    protected String getTargetServiceName(Object request) {
        if (request instanceof RequestBase) {
            RequestBase requestBase = (RequestBase)request;
            return requestBase.getTargetServiceUniqueName();
        }
        return null;
    }

    public <Request extends RequestCommand> boolean deserializeHeader(Request request) throws DeserializationException {
        if (request instanceof RpcRequestCommand) {
            RpcInternalContext.getContext().getStopWatch().tick();
            RpcRequestCommand requestCommand = (RpcRequestCommand)request;
            if (requestCommand.getRequestHeader() != null) {
                return true;
            }
            byte[] header = requestCommand.getHeader();
            Map<String, String> headerMap = this.mapSerializer.decode(header);
            requestCommand.setRequestHeader(headerMap);
            RpcInvokeContext.getContext().put("request_header_key", Collections.unmodifiableMap(headerMap));
            return true;
        }
        return false;
    }

    public <Response extends ResponseCommand> boolean deserializeHeader(Response response, InvokeContext invokeContext) throws DeserializationException {
        if (response instanceof RpcResponseCommand) {
            RpcInternalContext.getContext().getStopWatch().tick();
            RpcResponseCommand responseCommand = (RpcResponseCommand)response;
            byte[] header = responseCommand.getHeader();
            responseCommand.setResponseHeader(this.mapSerializer.decode(header));
            return true;
        }
        return false;
    }

    public <Request extends RequestCommand> boolean serializeContent(Request request, InvokeContext invokeContext) throws SerializationException {
        if (request instanceof RpcRequestCommand) {
            RpcRequestCommand requestCommand = (RpcRequestCommand)request;
            RpcInvokeContext.getContext().put("_rpc_request_command", requestCommand);
            Object requestObject = requestCommand.getRequestObject();
            byte serializerCode = requestCommand.getSerializer();
            long serializeStartTime = System.nanoTime();
            try {
                HashMap<String, String> header = (HashMap<String, String>)requestCommand.getRequestHeader();
                if (header == null) {
                    header = new HashMap<String, String>();
                }
                this.putKV(header, "sofa_head_generic_type", (String)invokeContext.get("sofa_head_generic_type"));
                Serializer rpcSerializer = SerializerFactory.getSerializer(serializerCode);
                AbstractByteBuf byteBuf = rpcSerializer.encode(requestObject, header);
                request.setContent(byteBuf.array());
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                throw new SerializationException(ex.getMessage(), (Throwable)ex);
            }
            finally {
                this.recordSerializeRequest((RequestCommand)requestCommand, invokeContext, serializeStartTime);
                RpcInvokeContext.getContext().remove("_rpc_request_command");
            }
        }
        return false;
    }

    protected void recordSerializeRequest(RequestCommand requestCommand, InvokeContext invokeContext, long serializeStartTime) {
        RpcInvokeContext.getContext().put("_req_ser_time_nano", System.nanoTime() - serializeStartTime);
        if (!RpcInternalContext.isAttachmentEnable()) {
            return;
        }
        RpcInternalContext context = null;
        if (invokeContext != null) {
            context = (RpcInternalContext)invokeContext.get("rpc.ctx");
        }
        if (context == null) {
            context = RpcInternalContext.getContext();
        }
        int cost = context.getStopWatch().tick().read();
        int requestSize = RpcProtocol.getRequestHeaderLength() + requestCommand.getClazzLength() + requestCommand.getContentLength() + requestCommand.getHeaderLength();
        context.setAttachment("_req_size", requestSize);
        context.setAttachment("_req_ser_time", cost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Request extends RequestCommand> boolean deserializeContent(Request request) throws DeserializationException {
        if (request instanceof RpcRequestCommand) {
            RpcRequestCommand requestCommand = (RpcRequestCommand)request;
            Object header = requestCommand.getRequestHeader();
            if (!(header instanceof Map)) {
                throw new DeserializationException("Head of request is null or is not map");
            }
            Map headerMap = (Map)header;
            String traceId = (String)headerMap.get("rpc_trace_context.sofaTraceId");
            String rpcId = (String)headerMap.get("rpc_trace_context.sofaRpcId");
            long deserializeStartTime = System.nanoTime();
            try {
                byte[] content = requestCommand.getContent();
                if (content == null || content.length == 0) {
                    throw new DeserializationException("Content of request is null");
                }
                String service = (String)headerMap.get("service");
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                ClassLoader serviceClassLoader = ReflectCache.getServiceClassLoader(service);
                try {
                    Thread.currentThread().setContextClassLoader(serviceClassLoader);
                    Serializer rpcSerializer = SerializerFactory.getSerializer(requestCommand.getSerializer());
                    Object sofaRequest = ClassUtils.forName(requestCommand.getRequestClass()).newInstance();
                    rpcSerializer.decode((AbstractByteBuf)new ByteArrayWrapperByteBuf(requestCommand.getContent()), sofaRequest, (Map<String, String>)headerMap);
                    this.setRequestPropertiesWithHeaderInfo(headerMap, sofaRequest);
                    this.parseRequestHeader(headerMap, sofaRequest);
                    requestCommand.setRequestObject(sofaRequest);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                LOGGER.error("traceId={}, rpcId={}, Request deserializeContent exception, msg={}", traceId, rpcId, ex.getMessage(), ex);
                throw new DeserializationException(ex.getMessage() + ", traceId=" + traceId + ", rpcId=" + rpcId, (Throwable)ex);
            }
            finally {
                this.recordDeserializeRequest((RequestCommand)requestCommand, deserializeStartTime);
            }
        }
        return false;
    }

    protected void parseRequestHeader(Map<String, String> headerMap, Object sofaRequest) {
        if (sofaRequest instanceof SofaRequest) {
            this.parseRequestHeader("rpc_trace_context", headerMap, (SofaRequest)sofaRequest);
            Map<String, Object> requestProps = ((SofaRequest)sofaRequest).getRequestProps();
            if (requestProps == null) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    ((SofaRequest)sofaRequest).addRequestProp(entry.getKey(), entry.getValue());
                }
            } else {
                this.replaceWithHeaderMap(headerMap, requestProps);
            }
        }
    }

    private void parseRequestHeader(String key, Map<String, String> headerMap, SofaRequest sofaRequest) {
        HashMap<String, String> traceMap = new HashMap<String, String>();
        CodecUtils.treeCopyTo(key + ".", headerMap, traceMap, true);
        Object traceCtx = sofaRequest.getRequestProp(key);
        if (traceCtx == null) {
            sofaRequest.addRequestProp(key, traceMap);
        } else if (traceCtx instanceof Map) {
            ((Map)traceCtx).putAll(traceMap);
        }
    }

    private void replaceWithHeaderMap(Map<String, String> headerMap, Map props) {
        if (headerMap == null || props == null) {
            return;
        }
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            Object o = props.get(entry.getKey());
            if (o == null) {
                props.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!(o instanceof String) || !StringUtils.isBlank((CharSequence)o) && !StringUtils.isNotBlank(entry.getValue())) continue;
            props.put(entry.getKey(), entry.getValue());
        }
    }

    private void recordDeserializeRequest(RequestCommand requestCommand, long deserializeStartTime) {
        RpcInvokeContext.getContext().put("_req_des_time_nano", System.nanoTime() - deserializeStartTime);
        if (!RpcInternalContext.isAttachmentEnable()) {
            return;
        }
        RpcInternalContext context = RpcInternalContext.getContext();
        int cost = context.getStopWatch().tick().read();
        int requestSize = RpcProtocol.getRequestHeaderLength() + requestCommand.getClazzLength() + requestCommand.getContentLength() + requestCommand.getHeaderLength();
        context.setAttachment("_req_size", requestSize);
        context.setAttachment("_req_des_time", cost);
    }

    public <Response extends ResponseCommand> boolean serializeContent(Response response) throws SerializationException {
        if (response instanceof RpcResponseCommand) {
            RpcResponseCommand responseCommand = (RpcResponseCommand)response;
            byte serializerCode = response.getSerializer();
            long serializeStartTime = System.nanoTime();
            try {
                Serializer rpcSerializer = SerializerFactory.getSerializer(serializerCode);
                AbstractByteBuf byteBuf = rpcSerializer.encode(responseCommand.getResponseObject(), null);
                responseCommand.setContent(byteBuf.array());
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                String traceId = (String)RpcInternalContext.getContext().getAttachment("_trace_id");
                String rpcId = (String)RpcInternalContext.getContext().getAttachment("_span_id");
                LOGGER.error("traceId={}, rpcId={}, Response serializeContent exception, msg = {}", traceId, rpcId, ex.getMessage(), ex);
                throw new SerializationException(ex.getMessage() + ", traceId=" + traceId + ", rpcId=" + rpcId, (Throwable)ex);
            }
            finally {
                this.recordSerializeResponse(responseCommand, serializeStartTime);
            }
        }
        return false;
    }

    private void recordSerializeResponse(RpcResponseCommand responseCommand, long serializeStartTime) {
        RpcInvokeContext.getContext().put("_resp_ser_time_nano", System.nanoTime() - serializeStartTime);
        if (!RpcInternalContext.isAttachmentEnable()) {
            return;
        }
        RpcInternalContext context = RpcInternalContext.getContext();
        int cost = context.getStopWatch().tick().read();
        int respSize = RpcProtocol.getResponseHeaderLength() + responseCommand.getClazzLength() + responseCommand.getContentLength() + responseCommand.getHeaderLength();
        context.setAttachment("_resp_size", respSize);
        context.setAttachment("_resp_ser_time", cost);
    }

    public <Response extends ResponseCommand> boolean deserializeContent(Response response, InvokeContext invokeContext) throws DeserializationException {
        if (response instanceof RpcResponseCommand) {
            RpcResponseCommand responseCommand = (RpcResponseCommand)response;
            byte serializer = response.getSerializer();
            byte[] content = responseCommand.getContent();
            if (content == null || content.length == 0) {
                return false;
            }
            long deserializeStartTime = System.nanoTime();
            try {
                Object sofaResponse = ClassUtils.forName(responseCommand.getResponseClass()).newInstance();
                HashMap<String, String> header = (HashMap<String, String>)responseCommand.getResponseHeader();
                if (header == null) {
                    header = new HashMap<String, String>();
                }
                this.putKV(header, "sofa_head_target_service", (String)invokeContext.get("sofa_head_target_service"));
                this.putKV(header, "sofa_head_method_name", (String)invokeContext.get("sofa_head_method_name"));
                this.putKV(header, "sofa_head_generic_type", (String)invokeContext.get("sofa_head_generic_type"));
                Serializer rpcSerializer = SerializerFactory.getSerializer(serializer);
                rpcSerializer.decode((AbstractByteBuf)new ByteArrayWrapperByteBuf(responseCommand.getContent()), sofaResponse, header);
                if (sofaResponse instanceof SofaResponse) {
                    this.parseResponseHeader(header, (SofaResponse)sofaResponse);
                }
                responseCommand.setResponseObject(sofaResponse);
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                throw new DeserializationException(ex.getMessage(), (Throwable)ex);
            }
            finally {
                this.recordDeserializeResponse(responseCommand, invokeContext, deserializeStartTime);
            }
        }
        return false;
    }

    protected void parseResponseHeader(Map<String, String> headerMap, SofaResponse sofaResponse) {
        Map<String, String> responseProps = sofaResponse.getResponseProps();
        if (responseProps == null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                sofaResponse.addResponseProp(entry.getKey(), entry.getValue());
            }
        } else {
            this.replaceWithHeaderMap(headerMap, responseProps);
        }
    }

    protected void putKV(Map<String, String> map, String key, String value) {
        if (map != null && key != null && value != null) {
            map.put(key, value);
        }
    }

    private void recordDeserializeResponse(RpcResponseCommand responseCommand, InvokeContext invokeContext, long deserializeStartTime) {
        RpcInvokeContext.getContext().put("_resp_des_time_nano", System.nanoTime() - deserializeStartTime);
        if (!RpcInternalContext.isAttachmentEnable()) {
            return;
        }
        RpcInternalContext context = null;
        if (invokeContext != null) {
            context = (RpcInternalContext)invokeContext.get("rpc.ctx");
        }
        if (context == null) {
            context = RpcInternalContext.getContext();
        }
        int cost = context.getStopWatch().tick().read();
        int respSize = RpcProtocol.getResponseHeaderLength() + responseCommand.getClazzLength() + responseCommand.getContentLength() + responseCommand.getHeaderLength();
        context.setAttachment("_resp_size", respSize);
        context.setAttachment("_resp_des_time", cost);
    }

    protected void setRequestPropertiesWithHeaderInfo(Map<String, String> headerMap, Object request) {
        if (request instanceof SofaRequest) {
            String headerService = headerMap.get("service");
            if (headerService == null) {
                headerService = headerMap.get("sofa_head_target_service");
            }
            if (StringUtils.isNotBlank(headerService)) {
                ((SofaRequest)request).setTargetServiceUniqueName(headerService);
            }
        }
    }
}

