/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.tracer.sofatracer.log.stat;

import com.alipay.common.tracer.core.appender.builder.JsonStringBuilder;
import com.alipay.common.tracer.core.appender.file.LoadTestAwareAppender;
import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.appender.self.Timestamp;
import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.reporter.stat.model.StatKey;
import com.alipay.common.tracer.core.reporter.stat.model.StatMapKey;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.TracerUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import java.util.Map;

public abstract class AbstractRpcStatJsonReporter
extends AbstractSofaTracerStatisticReporter {
    private static JsonStringBuilder buffer = new JsonStringBuilder();

    public AbstractRpcStatJsonReporter(String statTracerName, String rollingPolicy, String logReserveConfig) {
        super(statTracerName, rollingPolicy, logReserveConfig);
    }

    public void doReportStat(SofaTracerSpan sofaTracerSpan) {
        Map tagsWithStr = sofaTracerSpan.getTagsWithStr();
        StatMapKey statKey = new StatMapKey();
        String fromApp = this.getFromApp(tagsWithStr);
        String toApp = this.getToApp(tagsWithStr);
        String zone = this.getZone(tagsWithStr);
        String serviceName = (String)tagsWithStr.get("service");
        String methodName = (String)tagsWithStr.get("method");
        statKey.setKey(this.buildString(new String[]{fromApp, toApp, serviceName, methodName}));
        String resultCode = (String)tagsWithStr.get("result.code");
        statKey.setResult(this.isSuccess(resultCode) ? "Y" : "N");
        statKey.setEnd(this.buildString(new String[]{this.getLoadTestMark(sofaTracerSpan), zone}));
        statKey.setLoadTest(TracerUtils.isLoadTest((SofaTracerSpan)sofaTracerSpan));
        statKey.addKey("local.app", (String)tagsWithStr.get("local.app"));
        statKey.addKey("remote.app", (String)tagsWithStr.get("remote.app"));
        statKey.addKey("service", serviceName);
        statKey.addKey("method", methodName);
        long duration = sofaTracerSpan.getEndTime() - sofaTracerSpan.getStartTime();
        long[] values = new long[]{1L, duration};
        this.addStat((StatKey)statKey, values);
    }

    public abstract String getFromApp(Map<String, String> var1);

    public abstract String getToApp(Map<String, String> var1);

    public abstract String getZone(Map<String, String> var1);

    protected boolean isSuccess(String resultCode) {
        return "00".equals(resultCode) || "0".equals(resultCode) || StringUtils.isBlank(resultCode);
    }

    protected String getLoadTestMark(SofaTracerSpan span) {
        if (TracerUtils.isLoadTest((SofaTracerSpan)span)) {
            return "T";
        }
        return "F";
    }

    public void print(StatKey statKey, long[] values) {
        if (this.isClosePrint.get()) {
            return;
        }
        StatMapKey statMapKey = (StatMapKey)statKey;
        buffer.reset();
        buffer.appendBegin("time", (Object)Timestamp.currentTime());
        buffer.append("stat.key", (Object)this.statKeySplit(statMapKey));
        buffer.append("count", (Object)values[0]);
        buffer.append("total.cost.milliseconds", (Object)values[1]);
        buffer.append("success", (Object)statMapKey.getResult());
        buffer.appendEnd();
        try {
            if (this.appender instanceof LoadTestAwareAppender) {
                ((LoadTestAwareAppender)this.appender).append(buffer.toString(), statKey.isLoadTest());
            } else {
                this.appender.append(buffer.toString());
            }
            this.appender.flush();
        }
        catch (Throwable t) {
            SelfLog.error((String)("\u7edf\u8ba1\u65e5\u5fd7<" + this.statTracerName + ">\u8f93\u51fa\u5f02\u5e38"), (Throwable)t);
        }
    }

    private String statKeySplit(StatMapKey statKey) {
        JsonStringBuilder jsonBufferKey = new JsonStringBuilder();
        Map keyMap = statKey.getKeyMap();
        jsonBufferKey.appendBegin();
        for (Map.Entry entry : keyMap.entrySet()) {
            jsonBufferKey.append((String)entry.getKey(), entry.getValue());
        }
        jsonBufferKey.appendEnd(false);
        return jsonBufferKey.toString();
    }
}

