/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.transport.AbstractChannel;
import com.alipay.sofa.rpc.transport.ClientTransport;
import com.alipay.sofa.rpc.transport.ClientTransportConfig;
import com.alipay.sofa.rpc.transport.ClientTransportHolder;
import com.alipay.sofa.rpc.transport.NotReusableClientTransportHolder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClientTransportFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientTransportFactory.class);
    private static final ClientTransportHolder CLIENT_TRANSPORT_HOLDER = new NotReusableClientTransportHolder();
    private static volatile ConcurrentMap<String, ClientTransport> REVERSE_CLIENT_TRANSPORT_MAP = null;

    public static void releaseTransport(ClientTransport clientTransport, int disconnectTimeout) {
        if (clientTransport == null) {
            return;
        }
        boolean needDestroy = CLIENT_TRANSPORT_HOLDER.removeClientTransport(clientTransport);
        if (needDestroy) {
            int count;
            if (disconnectTimeout > 0 && (count = clientTransport.currentRequests()) > 0) {
                long start = RpcRuntimeContext.now();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("There are {} outstanding call in transport, wait {}ms to end", count, disconnectTimeout);
                }
                while (clientTransport.currentRequests() > 0 && RpcRuntimeContext.now() - start < (long)disconnectTimeout) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if ((count = clientTransport.currentRequests()) > 0 && LOGGER.isWarnEnabled()) {
                LOGGER.warn("There are {} outstanding call in client transport, but shutdown now.", count);
            }
            if (REVERSE_CLIENT_TRANSPORT_MAP != null) {
                String key = NetUtils.channelToString(clientTransport.remoteAddress(), clientTransport.localAddress());
                REVERSE_CLIENT_TRANSPORT_MAP.remove(key);
            }
            clientTransport.destroy();
        }
    }

    public static ClientTransport getClientTransport(ClientTransportConfig config) {
        return CLIENT_TRANSPORT_HOLDER.getClientTransport(config);
    }

    public static void closeAll() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Shutdown all client transport now!");
        }
        try {
            CLIENT_TRANSPORT_HOLDER.destroy();
        }
        catch (Exception e) {
            LOGGER.error(LogCodes.getLog("020010008"), e);
        }
    }

    static ClientTransportHolder getClientTransportHolder() {
        return CLIENT_TRANSPORT_HOLDER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ClientTransport getReverseClientTransport(String container, AbstractChannel channel) {
        String key;
        ClientTransport transport;
        if (REVERSE_CLIENT_TRANSPORT_MAP == null) {
            Class<ClientTransportFactory> clazz = ClientTransportFactory.class;
            // MONITORENTER : com.alipay.sofa.rpc.transport.ClientTransportFactory.class
            if (REVERSE_CLIENT_TRANSPORT_MAP == null) {
                REVERSE_CLIENT_TRANSPORT_MAP = new ConcurrentHashMap<String, ClientTransport>();
            }
            // MONITOREXIT : clazz
        }
        if ((transport = (ClientTransport)REVERSE_CLIENT_TRANSPORT_MAP.get(key = NetUtils.channelToString(channel.remoteAddress(), channel.localAddress()))) != null) return transport;
        Class<ClientTransportFactory> clazz = ClientTransportFactory.class;
        // MONITORENTER : com.alipay.sofa.rpc.transport.ClientTransportFactory.class
        transport = (ClientTransport)REVERSE_CLIENT_TRANSPORT_MAP.get(key);
        if (transport == null) {
            ClientTransportConfig config = new ClientTransportConfig().setProviderInfo(new ProviderInfo().setHost(channel.remoteAddress().getHostName()).setPort(channel.remoteAddress().getPort())).setContainer(container);
            transport = ExtensionLoaderFactory.getExtensionLoader(ClientTransport.class).getExtension(config.getContainer(), new Class[]{ClientTransportConfig.class}, new Object[]{config});
            transport.setChannel(channel);
            REVERSE_CLIENT_TRANSPORT_MAP.put(key, transport);
        }
        // MONITOREXIT : clazz
        return transport;
    }

    public static ClientTransport getReverseClientTransport(String channelKey) {
        return REVERSE_CLIENT_TRANSPORT_MAP != null ? (ClientTransport)REVERSE_CLIENT_TRANSPORT_MAP.get(channelKey) : null;
    }

    public static void removeReverseClientTransport(String channelKey) {
        if (REVERSE_CLIENT_TRANSPORT_MAP != null) {
            REVERSE_CLIENT_TRANSPORT_MAP.remove(channelKey);
        }
    }
}

