/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.zipkin.sender;

import com.alipay.common.tracer.core.appender.self.SelfLog;
import java.net.URI;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import zipkin2.Call;
import zipkin2.codec.Encoding;
import zipkin2.reporter.BytesMessageEncoder;
import zipkin2.reporter.Sender;

public class ZipkinRestTemplateSender
extends Sender {
    private RestTemplate restTemplate;
    private String url;

    public ZipkinRestTemplateSender(RestTemplate restTemplate, String baseUrl) {
        this.restTemplate = restTemplate;
        this.url = baseUrl + (baseUrl.endsWith("/") ? "" : "/") + "api/v2/spans";
    }

    public Encoding encoding() {
        return Encoding.JSON;
    }

    public int messageMaxBytes() {
        return 0x200000;
    }

    public int messageSizeInBytes(List<byte[]> spans) {
        return this.encoding().listSizeInBytes(spans);
    }

    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        try {
            byte[] message = BytesMessageEncoder.JSON.encode(encodedSpans);
            this.post(message);
        }
        catch (Throwable e) {
            SelfLog.error((String)("Failed to report span to remote server. Current rest url is " + this.url), (Throwable)e);
        }
        return Call.create(null);
    }

    private void post(byte[] json) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        RequestEntity requestEntity = new RequestEntity((Object)json, (MultiValueMap)httpHeaders, HttpMethod.POST, URI.create(this.url));
        this.restTemplate.exchange(requestEntity, String.class);
    }
}

