/*
 * Decompiled with CFR 0.152.
 */
package org.android.agoo.control;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.taobao.accs.ACCSManager;
import com.taobao.accs.IACCSManager;
import com.taobao.accs.base.TaoBaseService;
import com.taobao.accs.common.ThreadPoolExecutorFactory;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.AdapterUtilityImpl;
import com.taobao.accs.utl.AppMonitorAdapter;
import com.taobao.accs.utl.UTMini;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.android.agoo.common.Config;
import org.android.agoo.common.MsgDO;
import org.android.agoo.control.m;
import org.android.agoo.control.n;
import org.json.JSONObject;

public class NotifManager {
    private static final String TAG = "NotifManager";
    private static final String ACK_MESSAGE = "accs.ackMessage";
    private static Context mContext = null;
    private static final int EVENT_ID = 66001;

    public void init(Context context) {
        mContext = context;
    }

    public void handlerACKMessage(MsgDO msgDO, TaoBaseService.ExtraInfo extraInfo) {
        if (msgDO == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)msgDO.msgIds) && TextUtils.isEmpty((CharSequence)msgDO.removePacks) && TextUtils.isEmpty((CharSequence)msgDO.errorCode)) {
            UTMini.getInstance().commitEvent(66002, ACK_MESSAGE, (Object)AdapterUtilityImpl.getDeviceId((Context)mContext), (Object)"handlerACKMessageRetuen", (Object)("msgids=" + msgDO.msgIds + ",removePacks=" + msgDO.removePacks + ",errorCode=" + msgDO.errorCode));
            return;
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("api", "agooAck");
            hashMap.put("id", msgDO.msgIds + "@" + msgDO.messageSource);
            if (!TextUtils.isEmpty((CharSequence)msgDO.removePacks)) {
                hashMap.put("del_pack", msgDO.removePacks);
            }
            if (!TextUtils.isEmpty((CharSequence)msgDO.errorCode)) {
                hashMap.put("ec", msgDO.errorCode);
            }
            if (!TextUtils.isEmpty((CharSequence)msgDO.type)) {
                hashMap.put("type", msgDO.type);
            }
            if (!TextUtils.isEmpty((CharSequence)msgDO.extData)) {
                hashMap.put("ext", msgDO.extData);
            }
            hashMap.put("appkey", Config.a(mContext));
            hashMap.put("utdid", AdapterUtilityImpl.getDeviceId((Context)mContext));
            JSONObject jSONObject = new JSONObject(hashMap);
            byte[] byArray = jSONObject.toString().getBytes("UTF-8");
            UTMini.getInstance().commitEvent(66002, ACK_MESSAGE, (Object)AdapterUtilityImpl.getDeviceId((Context)mContext), (Object)"handlerACKMessageSendData", (Object)msgDO.msgIds);
            AppMonitorAdapter.commitCount((String)"accs", (String)"agoo_ack", (String)"handlerACKMessage", (double)0.0);
            ACCSManager.AccsRequest accsRequest = new ACCSManager.AccsRequest(null, "agooAck", byArray, null, null, null, null);
            if (msgDO != null) {
                accsRequest.setTag(msgDO.msgIds);
            }
            String string = ACCSManager.getAccsInstance((Context)mContext, (String)Config.a(mContext), (String)Config.b(mContext)).sendPushResponse(mContext, accsRequest, extraInfo);
            ALog.i((String)TAG, (String)("handlerACKMessage,endRequest,dataId=" + string), (Object[])new Object[0]);
        }
        catch (Throwable throwable) {
            if (ALog.isPrintLog((ALog.Level)ALog.Level.E)) {
                ALog.e((String)TAG, (String)("handlerACKMessage Throwable,msgIds=" + msgDO.msgIds + ",type=" + msgDO.type + ",e=" + throwable.toString()), (Object[])new Object[0]);
            }
            UTMini.getInstance().commitEvent(66002, ACK_MESSAGE, (Object)AdapterUtilityImpl.getDeviceId((Context)mContext), (Object)"handlerACKMessageExceptionFailed", (Object)throwable.toString());
        }
    }

    public void report(MsgDO msgDO, TaoBaseService.ExtraInfo extraInfo) {
        if (!TextUtils.isEmpty((CharSequence)msgDO.reportStr)) {
            try {
                int n2 = Integer.parseInt(msgDO.reportStr);
                if (n2 >= -1) {
                    this.reportMethod(msgDO, extraInfo);
                    if (!msgDO.isFromCache) {
                        AppMonitorAdapter.commitCount((String)"accs", (String)"agoo_ack", (String)msgDO.msgStatus, (double)0.0);
                    }
                }
            }
            catch (Throwable throwable) {
                ALog.e((String)TAG, (String)"[report] is error", (Throwable)throwable, (Object[])new Object[0]);
            }
        }
    }

    public void reportNotifyMessage(MsgDO msgDO) {
        try {
            if (msgDO != null) {
                AppMonitorAdapter.commitCount((String)"accs", (String)"agoo_report_id", (String)msgDO.msgIds, (double)0.0);
                byte[] byArray = this.convertMsgToBytes(msgDO);
                ACCSManager.AccsRequest accsRequest = new ACCSManager.AccsRequest(null, "agooAck", byArray, null, null, null, null);
                IACCSManager iACCSManager = ACCSManager.getAccsInstance((Context)mContext, (String)Config.a(mContext), (String)Config.b(mContext));
                String string = iACCSManager.sendRequest(mContext, accsRequest);
                if (ALog.isPrintLog((ALog.Level)ALog.Level.I)) {
                    ALog.i((String)TAG, (String)"reportNotifyMessage", (Object[])new Object[]{"dataId", string, "status", msgDO.msgStatus});
                }
                AppMonitorAdapter.commitCount((String)"accs", (String)"agoo_click", (String)msgDO.msgStatus, (double)0.0);
                AppMonitorAdapter.commitCount((String)"accs", (String)"agoo_ack", (String)msgDO.msgStatus, (double)0.0);
            }
        }
        catch (Throwable throwable) {
            ALog.e((String)TAG, (String)"[reportNotifyMessage] is error", (Throwable)throwable, (Object[])new Object[0]);
            AppMonitorAdapter.commitCount((String)"accs", (String)"error", (String)throwable.toString(), (double)0.0);
        }
    }

    private byte[] convertMsgToBytes(MsgDO msgDO) throws UnsupportedEncodingException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("api", "agooReport");
        hashMap.put("id", msgDO.msgIds + "@" + msgDO.messageSource);
        hashMap.put("ext", msgDO.extData);
        hashMap.put("status", msgDO.msgStatus);
        if (!TextUtils.isEmpty((CharSequence)msgDO.errorCode)) {
            hashMap.put("ec", msgDO.errorCode);
        }
        if (!TextUtils.isEmpty((CharSequence)msgDO.type)) {
            hashMap.put("type", msgDO.type);
        }
        if (!TextUtils.isEmpty((CharSequence)msgDO.fromPkg)) {
            hashMap.put("fromPkg", msgDO.fromPkg);
        }
        if (!TextUtils.isEmpty((CharSequence)msgDO.fromAppkey)) {
            hashMap.put("fromAppkey", msgDO.fromAppkey);
        }
        if (!TextUtils.isEmpty((CharSequence)msgDO.notifyEnable)) {
            hashMap.put("notifyEnable", msgDO.notifyEnable);
        }
        if (!TextUtils.isEmpty((CharSequence)msgDO.extData)) {
            hashMap.put("ext", msgDO.extData);
        }
        hashMap.put("isStartProc", Boolean.toString(msgDO.isStartProc));
        hashMap.put("appkey", Config.a(mContext));
        hashMap.put("utdid", AdapterUtilityImpl.getDeviceId((Context)mContext));
        JSONObject jSONObject = new JSONObject(hashMap);
        return jSONObject.toString().getBytes("UTF-8");
    }

    private void reportMethod(MsgDO msgDO, TaoBaseService.ExtraInfo extraInfo) {
        try {
            if (msgDO == null) {
                ALog.e((String)TAG, (String)"reportMethod msg null", (Object[])new Object[0]);
                return;
            }
            byte[] byArray = this.convertMsgToBytes(msgDO);
            ACCSManager.AccsRequest accsRequest = new ACCSManager.AccsRequest(null, "agooAck", byArray, null, null, null, null);
            accsRequest.setTag(msgDO.msgIds);
            String string = ACCSManager.getAccsInstance((Context)mContext, (String)Config.a(mContext), (String)Config.b(mContext)).sendPushResponse(mContext, accsRequest, extraInfo);
            if (ALog.isPrintLog((ALog.Level)ALog.Level.D)) {
                ALog.d((String)TAG, (String)"report", (Object[])new Object[]{"dataId", string, "status", msgDO.msgStatus, "errorcode", msgDO.errorCode});
            }
        }
        catch (Throwable throwable) {
            AppMonitorAdapter.commitCount((String)"accs", (String)"error", (String)throwable.toString(), (double)0.0);
        }
    }

    public void reportThirdPushToken(String string, String string2, boolean bl) {
        ThreadPoolExecutorFactory.schedule((Runnable)new m(this, string2, string, bl), (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    public void reportThirdPushToken(String string, String string2, String string3, boolean bl) {
        ThreadPoolExecutorFactory.schedule((Runnable)new n(this, string2, string, string3, bl), (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    public void reportThirdPushToken(String string, String string2) {
        this.reportThirdPushToken(string, string2, true);
    }

    public void doUninstall(String string, boolean bl) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("pack", string);
            hashMap.put("appkey", Config.a(mContext));
            hashMap.put("utdid", AdapterUtilityImpl.getDeviceId((Context)mContext));
            JSONObject jSONObject = new JSONObject(hashMap);
            byte[] byArray = jSONObject.toString().getBytes("UTF-8");
            ACCSManager.AccsRequest accsRequest = new ACCSManager.AccsRequest(null, "agooKick", byArray, null, null, null, null);
            ACCSManager.getAccsInstance((Context)mContext, (String)Config.a(mContext), (String)Config.b(mContext)).sendPushResponse(mContext, accsRequest, new TaoBaseService.ExtraInfo());
        }
        catch (Throwable throwable) {
            ALog.e((String)TAG, (String)"[doUninstall] is error", (Throwable)throwable, (Object[])new Object[0]);
        }
    }

    public void pingApp(String string, String string2, String string3, int n2) {
    }

    private boolean isAppInstalled(String string) {
        PackageInfo packageInfo;
        try {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return false;
            }
            packageInfo = mContext.getPackageManager().getPackageInfo(string, 0);
        }
        catch (Throwable throwable) {
            packageInfo = null;
        }
        if (packageInfo == null) {
            return false;
        }
        ALog.i((String)TAG, (String)"isAppInstalled true..", (Object[])new Object[0]);
        return true;
    }

    private String getVersion(String string) {
        try {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return "null";
            }
            PackageManager packageManager = mContext.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(string, 0);
            String string2 = packageInfo.versionName;
            ALog.d((String)TAG, (String)("getVersion###\u7248\u672c\u53f7\u4e3a : " + string2), (Object[])new Object[0]);
            return string2;
        }
        catch (Throwable throwable) {
            return "null";
        }
    }

    static /* synthetic */ Context access$000() {
        return mContext;
    }
}

