/*
 * Decompiled with CFR 0.152.
 */
package com.ali.ha.datahub;

import com.ali.ha.datahub.BizSubscriber;
import java.util.HashMap;

public class DataHub {
    private BizSubscriber mSubscriber;
    private SubProcedure mSubProcedure;

    private DataHub() {
    }

    public static final DataHub getInstance() {
        return SingleInstanceHolder.sInstance;
    }

    public void publish(String bizID, HashMap<String, String> mDatas) {
        if (null == this.mSubscriber) {
            return;
        }
        this.mSubscriber.pub(bizID, mDatas);
    }

    public void publishABTest(String bizID, HashMap<String, String> mDatas) {
        if (null == this.mSubscriber) {
            return;
        }
        this.mSubscriber.pubAB(bizID, mDatas);
    }

    public void onStage(String bizID, String stageName) {
        this.onStage(bizID, stageName, System.currentTimeMillis());
    }

    public void onStage(String bizID, String stageName, long timeStamp) {
        if (null == this.mSubscriber) {
            return;
        }
        this.mSubscriber.onStage(bizID, stageName, timeStamp);
    }

    public void setCurrentBiz(String bizID, String bizCode) {
        if (null == this.mSubscriber) {
            return;
        }
        this.mSubscriber.setMainBiz(bizID, bizCode);
    }

    public void setCurrentBiz(String bizID) {
        if (null == this.mSubscriber) {
            return;
        }
        this.mSubscriber.setMainBiz(bizID, null);
    }

    public void onBizDataReadyStage() {
        if (null == this.mSubscriber) {
            return;
        }
        this.mSubscriber.onBizDataReadyStage();
    }

    public void init(BizSubscriber bizSubscriber) {
        if (null == this.mSubscriber) {
            this.mSubscriber = bizSubscriber;
            this.mSubProcedure = new SubProcedure(this.mSubscriber);
        }
    }

    private SubProcedure subProcedure() {
        if (null == this.mSubProcedure) {
            this.mSubProcedure = new SubProcedure();
        }
        return this.mSubProcedure;
    }

    private static class SubProcedure {
        private BizSubscriber mSubscriber;

        private SubProcedure() {
        }

        private SubProcedure(BizSubscriber subscriber) {
            this.mSubscriber = subscriber;
        }

        public void onBegin(String procedureName) {
            if (this.mSubscriber == null) {
                // empty if block
            }
        }

        public void onStage(String procedureName, String stageName) {
            if (this.mSubscriber == null) {
                // empty if block
            }
        }

        public void onEnd(String procedureName) {
            if (this.mSubscriber == null) {
                // empty if block
            }
        }
    }

    private static final class SingleInstanceHolder {
        public static final DataHub sInstance = new DataHub();

        private SingleInstanceHolder() {
        }
    }
}

