/*
 * Decompiled with CFR 0.152.
 */
package com.ali.alihadeviceevaluator;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Process;
import com.ali.alihadeviceevaluator.cpu.AliHACPUInfo;
import com.ali.alihadeviceevaluator.cpu.AliHACPUTracker;
import com.ali.alihadeviceevaluator.display.AliHADisplayInfo;
import com.ali.alihadeviceevaluator.mem.AliHAMemoryTracker;
import com.ali.alihadeviceevaluator.opengl.AliHAOpenGL;
import com.ali.alihadeviceevaluator.util.AliHALifecycle;
import java.util.HashMap;

public class AliHAHardware {
    private Context mContext;
    private Handler mHandler;
    private AliHALifecycle lifecycle;
    public static final String CONFIG_CPUTRACKTICK = "cpuTrackTick";
    private volatile DisplayInfo mDisplayInfo;
    private volatile CPUInfo mCPUInfo;
    private volatile AliHACPUTracker mAliHACPUTracker;
    private volatile MemoryInfo mMemoryInfo;
    private volatile AliHAMemoryTracker mAliHAMemoryTracker;
    private volatile OutlineInfo mOutlineInfo;
    public static final int HIGH_END_DEVICE = 0;
    public static final int MEDIUM_DEVICE = 1;
    public static final int LOW_END_DEVICE = 2;
    public static final int DEVICE_IS_GOOD = 0;
    public static final int DEVICE_IS_NORMAL = 1;
    public static final int DEVICE_IS_RISKY = 2;
    public static final int DEVICE_IS_FATAL = 3;

    public static AliHAHardware getInstance() {
        return SingleHolder.mInstance;
    }

    private AliHAHardware() {
    }

    public void setUp(Application application, Handler handler) {
        this.mContext = application;
        this.mHandler = handler;
        if (this.mAliHACPUTracker == null) {
            this.mAliHACPUTracker = new AliHACPUTracker(Process.myPid(), this.mHandler);
        }
        this.lifecycle = new AliHALifecycle();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.lifecycle);
    }

    public void setUp(Application application) {
        this.setUp(application, null);
    }

    public Context getContext() {
        return this.mContext;
    }

    public void onAppBackGround() {
        if (this.mAliHACPUTracker != null) {
            this.mAliHACPUTracker.reset(0L);
        }
    }

    public void onAppForeGround() {
        if (this.mAliHACPUTracker != null) {
            this.mAliHACPUTracker.reset(this.mAliHACPUTracker.mDeltaDuration);
        }
    }

    public void effectConfig(HashMap<String, String> params) {
        if (params == null) {
            return;
        }
        if (this.mAliHACPUTracker == null) {
            return;
        }
        String strCpuTrackTick = params.get(CONFIG_CPUTRACKTICK);
        Long newValue = -1L;
        try {
            newValue = Long.valueOf(strCpuTrackTick);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (newValue != -1L) {
            this.mAliHACPUTracker.reset(newValue);
        }
    }

    public DisplayInfo getDisplayInfo() {
        if (this.mContext == null) {
            return new DisplayInfo();
        }
        if (this.mDisplayInfo == null) {
            AliHADisplayInfo mAliHADisplayInfo = AliHADisplayInfo.getDisplayInfo(this.mContext);
            this.mDisplayInfo = new DisplayInfo();
            this.mDisplayInfo.mDensity = mAliHADisplayInfo.mDensity;
            this.mDisplayInfo.mHeightPixels = mAliHADisplayInfo.mHeightPixels;
            this.mDisplayInfo.mWidthPixels = mAliHADisplayInfo.mWidthPixels;
            AliHAOpenGL aliHAOpenGL = new AliHAOpenGL();
            aliHAOpenGL.generateOpenGLVersion(this.mContext);
            this.mDisplayInfo.mOpenGLVersion = String.valueOf(aliHAOpenGL.mOpenGLVersion);
            this.mDisplayInfo.mOpenGLDeviceLevel = this.evaluateLevel(aliHAOpenGL.mScore, 8, 6);
        }
        return this.mDisplayInfo;
    }

    public CPUInfo getCpuInfo() {
        if (this.mContext == null) {
            return new CPUInfo();
        }
        if (this.mCPUInfo == null) {
            AliHACPUInfo aliHACPUInfo = new AliHACPUInfo();
            aliHACPUInfo.evaluateCPUScore();
            if (this.mAliHACPUTracker == null) {
                this.mAliHACPUTracker = new AliHACPUTracker(Process.myPid(), this.mHandler);
            }
            this.mCPUInfo = new CPUInfo();
            this.mCPUInfo.cpuCoreNum = aliHACPUInfo.mCPUCore;
            this.mCPUInfo.avgFreq = aliHACPUInfo.mCPUAvgFreq;
            this.mCPUInfo.cpuDeivceScore = aliHACPUInfo.mCPUScore;
            this.mCPUInfo.deviceLevel = this.evaluateLevel(aliHACPUInfo.mCPUScore, 8, 5);
        }
        this.mCPUInfo.cpuUsageOfApp = this.mAliHACPUTracker.peakCurProcessCpuPercent();
        this.mCPUInfo.cpuUsageOfDevcie = this.mAliHACPUTracker.peakCpuPercent();
        this.mCPUInfo.runtimeLevel = this.evaluateLevel((int)(100.0f - this.mCPUInfo.cpuUsageOfDevcie), 90, 60, 20);
        return this.mCPUInfo;
    }

    private int evaluateLevel(int score, int ... splits) {
        if (-1 == score) {
            return -1;
        }
        int resLevel = -1;
        for (int i = 0; i < splits.length; ++i) {
            if (score < splits[i]) continue;
            resLevel = i;
            break;
        }
        if (resLevel == -1 && score >= 0) {
            resLevel = splits.length;
        }
        return resLevel;
    }

    public MemoryInfo getMemoryInfo() {
        if (this.mContext == null) {
            return new MemoryInfo();
        }
        if (this.mMemoryInfo == null) {
            this.mMemoryInfo = new MemoryInfo();
            this.mAliHAMemoryTracker = new AliHAMemoryTracker();
        }
        try {
            long[] tmp = this.mAliHAMemoryTracker.getDeviceMem();
            this.mMemoryInfo.deviceTotalMemory = tmp[0];
            this.mMemoryInfo.deviceUsedMemory = tmp[1];
            tmp = this.mAliHAMemoryTracker.getHeapJVM();
            this.mMemoryInfo.jvmTotalMemory = tmp[0];
            this.mMemoryInfo.jvmUsedMemory = tmp[1];
            int jvmUsePercent = tmp[0] != 0L ? (int)(100.0 * (double)tmp[1] / (double)tmp[0]) : -1;
            tmp = this.mAliHAMemoryTracker.getHeapNative();
            this.mMemoryInfo.nativeTotalMemory = tmp[0];
            this.mMemoryInfo.nativeUsedMemory = tmp[1];
            int nativeUsePercent = tmp[0] != 0L ? (int)(100.0 * (double)tmp[1] / (double)tmp[0]) : -1;
            tmp = this.mAliHAMemoryTracker.getPSS(this.mContext, Process.myPid());
            this.mMemoryInfo.dalvikPSSMemory = tmp[0];
            this.mMemoryInfo.nativePSSMemory = tmp[1];
            this.mMemoryInfo.totalPSSMemory = tmp[2];
            this.mMemoryInfo.deviceLevel = this.evaluateLevel((int)this.mMemoryInfo.deviceTotalMemory, 0x500000, 0x280000);
            int runtimeJVMLevel = this.evaluateLevel(100 - jvmUsePercent, 70, 50, 30);
            int runtimeNativeLevel = this.evaluateLevel(100 - nativeUsePercent, 60, 40, 20);
            this.mMemoryInfo.runtimeLevel = Math.round((float)(runtimeJVMLevel + runtimeNativeLevel) / 2.0f);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return this.mMemoryInfo;
    }

    public OutlineInfo getOutlineInfo() {
        if (this.mContext == null) {
            return new OutlineInfo();
        }
        if (this.mOutlineInfo == null) {
            this.mOutlineInfo = new OutlineInfo();
            if (this.mMemoryInfo == null) {
                this.getMemoryInfo();
            }
            if (this.mCPUInfo == null) {
                this.getCpuInfo();
            }
            if (this.mDisplayInfo == null) {
                this.getDisplayInfo();
            }
            this.mOutlineInfo.deviceLevelEasy = Math.round((0.9f * (float)this.mMemoryInfo.deviceLevel + 1.5f * (float)this.mCPUInfo.deviceLevel + 0.6f * (float)this.mDisplayInfo.mOpenGLDeviceLevel) / 3.0f);
            this.mOutlineInfo.runtimeLevel = Math.round((float)(this.mMemoryInfo.runtimeLevel + this.mCPUInfo.runtimeLevel) / 2.0f);
        } else {
            if (this.mMemoryInfo == null) {
                this.getMemoryInfo();
            }
            if (this.mCPUInfo == null) {
                this.getCpuInfo();
            }
            if (this.mDisplayInfo == null) {
                this.getDisplayInfo();
            }
            this.mOutlineInfo.runtimeLevel = Math.round((0.8f * (float)this.mMemoryInfo.runtimeLevel + 1.2f * (float)this.mCPUInfo.runtimeLevel) / 2.0f);
        }
        return this.mOutlineInfo;
    }

    public void setDeviceScore(int i) {
        if (this.mOutlineInfo == null) {
            this.getOutlineInfo();
        }
        if (this.mOutlineInfo != null) {
            this.mOutlineInfo.deviceScore = i;
            this.mOutlineInfo.deviceLevel = i >= 90 ? 0 : (i >= 70 ? 1 : 2);
        }
    }

    public class OutlineInfo {
        public int deviceLevel = -1;
        public int deviceLevelEasy;
        public int deviceScore;
        public int runtimeLevel = -1;

        public OutlineInfo update() {
            AliHAHardware.this.getCpuInfo();
            AliHAHardware.this.getDisplayInfo();
            ((AliHAHardware)AliHAHardware.this).mOutlineInfo.runtimeLevel = Math.round((0.8f * (float)((AliHAHardware)AliHAHardware.this).mMemoryInfo.runtimeLevel + 1.2f * (float)((AliHAHardware)AliHAHardware.this).mCPUInfo.runtimeLevel) / 2.0f);
            return this;
        }
    }

    public class MemoryInfo {
        public long deviceTotalMemory;
        public long deviceUsedMemory;
        public long jvmTotalMemory;
        public long jvmUsedMemory;
        public long nativeTotalMemory;
        public long nativeUsedMemory;
        public long dalvikPSSMemory;
        public long nativePSSMemory;
        public long totalPSSMemory;
        public int deviceLevel = -1;
        public int runtimeLevel = -1;
    }

    public class CPUInfo {
        public int cpuCoreNum = 0;
        public float avgFreq = 0.0f;
        public float cpuUsageOfApp = -1.0f;
        public float cpuUsageOfDevcie = -1.0f;
        public int cpuDeivceScore = -1;
        public int deviceLevel = -1;
        public int runtimeLevel = -1;
    }

    public class DisplayInfo {
        public float mDensity = 0.0f;
        public int mWidthPixels = 0;
        public int mHeightPixels = 0;
        public String mOpenGLVersion = "0";
        public int mOpenGLDeviceLevel = -1;
    }

    private static class SingleHolder {
        private static AliHAHardware mInstance = new AliHAHardware();

        private SingleHolder() {
        }
    }
}

