/*
 * Decompiled with CFR 0.152.
 */
package com.ali.alihadeviceevaluator.cpu;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class AliHACPUInfo {
    public int mCPUCore;
    public float mCPUMaxFreq = 0.0f;
    public float mCPUAvgFreq = Float.MAX_VALUE;
    public float mCPUMinFreq;
    public int mCPUScore = -1;
    private float[] m8CoreFreqStage = new float[]{1.9f, 1.8f, 1.7f, 1.5f, 1.4f, 1.2f, 1.0f, 0.9f, 0.8f};
    private float[] mCoreFreqStage = new float[]{2.4f, 2.2f, 2.0f, 1.8f, 1.5f, 1.3f, 1.2f, 1.0f, 0.9f};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchCPUInfo() {
        this.mCPUCore = Runtime.getRuntime().availableProcessors();
        if (this.mCPUCore <= 0) {
            return;
        }
        BufferedReader bufferedReader = null;
        InputStreamReader fr = null;
        try {
            float[] cpuFreqs = new float[this.mCPUCore];
            float avgFreqTmp = 0.0f;
            for (int i = 0; i < this.mCPUCore; ++i) {
                File file = new File("/sys/devices/system/cpu/cpu" + i + "/cpufreq/cpuinfo_max_freq");
                if (!file.exists()) continue;
                fr = new FileReader(file);
                bufferedReader = new BufferedReader(fr);
                String maxFreqStr = bufferedReader.readLine();
                if (maxFreqStr != null) {
                    float maxFreq;
                    long freq = Long.parseLong(maxFreqStr);
                    cpuFreqs[i] = maxFreq = (float)freq / 1000000.0f;
                    if (this.mCPUMaxFreq < maxFreq) {
                        this.mCPUMaxFreq = maxFreq;
                    }
                    if (this.mCPUMinFreq > maxFreq) {
                        this.mCPUMinFreq = maxFreq;
                    }
                    avgFreqTmp += maxFreq;
                }
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                fr = null;
            }
            this.mCPUAvgFreq = Math.round(100.0f * avgFreqTmp / (float)this.mCPUCore) / 100;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void evaluateCPUScore() {
        this.fetchCPUInfo();
        int freqScore = 0;
        float[] curStages = this.mCPUCore >= 8 ? this.m8CoreFreqStage : this.mCoreFreqStage;
        freqScore = 9;
        for (int i = 0; i < curStages.length; ++i) {
            if (!(this.mCPUMaxFreq >= curStages[i])) continue;
            freqScore = i;
            break;
        }
        freqScore = 10 - freqScore;
        int coreScore = 0;
        if (this.mCPUCore >= 16) {
            coreScore = 10;
        } else if (this.mCPUCore >= 8) {
            coreScore = 9;
        } else if (this.mCPUCore >= 6) {
            coreScore = 8;
        } else if (this.mCPUCore >= 4) {
            coreScore = 6;
        } else if (this.mCPUCore >= 2) {
            coreScore = 4;
        }
        this.mCPUScore = (int)((float)freqScore * 0.6f + (float)coreScore * 0.4f);
    }
}

