/*
 * Decompiled with CFR 0.152.
 */
package com.ali.alihadeviceevaluator.cpu;

import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Process;
import android.util.Log;
import com.ali.alihadeviceevaluator.util.BigNumUtils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class AliHACPUTracker
implements Runnable {
    private static final String TAG = "CpuTracker";
    private static final boolean Debug = false;
    public static final int PROC_TERM_MASK = 255;
    public static final int PROC_ZERO_TERM = 0;
    public static final int PROC_SPACE_TERM = 32;
    public static final int PROC_TAB_TERM = 9;
    public static final int PROC_COMBINE = 256;
    public static final int PROC_PARENS = 512;
    public static final int PROC_QUOTES = 1024;
    public static final int PROC_OUT_STRING = 4096;
    public static final int PROC_OUT_LONG = 8192;
    public static final int PROC_OUT_FLOAT = 16384;
    private static final int[] PROCESS_STATS_FORMAT = new int[]{32, 544, 32, 32, 32, 32, 32, 32, 32, 8224, 32, 8224, 32, 8224, 8224};
    private static final int[] SYSTEM_CPU_FORMAT = new int[]{288, 8224, 8224, 8224, 8224, 8224, 8224, 8224};
    static final int PROCESS_STAT_MINOR_FAULTS = 0;
    static final int PROCESS_STAT_MAJOR_FAULTS = 1;
    static final int PROCESS_STAT_UTIME = 2;
    static final int PROCESS_STAT_STIME = 3;
    private long mBaseUserTime;
    private long mBaseSystemTime;
    private long mBaseIoWaitTime;
    private long mBaseIrqTime;
    private long mBaseSoftIrqTime;
    private long mBaseIdleTime;
    private long mProcessBaseUserTime;
    private long mProcessBaseSystemTime;
    private int lastRelIdleTime;
    private final long[] statsData = new long[4];
    private long[] sysCpu = new long[7];
    private Method readProcFile;
    private String statFile;
    private float mCpuPercent = -1.0f;
    private float mCurProcessCpuPercent = -1.0f;
    private Handler mCPUHandler;
    private ReadWriteLock peakCpuLock = new ReentrantReadWriteLock();
    private ReadWriteLock peakCurProCpuLock = new ReentrantReadWriteLock();
    public long mDeltaDuration = 7000L;
    private long mFirstDeltaDuration = 2000L;
    private volatile boolean open = true;
    private volatile boolean initCpu = true;
    private volatile double o_cpu = 0.0;
    private volatile double o_idle = 0.0;

    public AliHACPUTracker(int pid, Handler subHandler) {
        if (subHandler != null) {
            this.mCPUHandler = subHandler;
        } else {
            HandlerThread tmpThread = new HandlerThread(TAG);
            tmpThread.start();
            this.mCPUHandler = new Handler(tmpThread.getLooper());
        }
        this.init(pid);
    }

    public AliHACPUTracker(int pid) {
        HandlerThread tmpThread = new HandlerThread(TAG);
        tmpThread.start();
        this.mCPUHandler = new Handler(tmpThread.getLooper());
        this.init(pid);
    }

    private void init(int pid) {
        try {
            this.statFile = "/proc/" + pid + "/stat";
            this.readProcFile = Process.class.getMethod("readProcFile", String.class, int[].class, String[].class, long[].class, float[].class);
            this.readProcFile.setAccessible(true);
            if (Build.VERSION.SDK_INT < 26) {
                this.mCPUHandler.post((Runnable)this);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            if (this.initCpu) {
                this.mCPUHandler.postDelayed((Runnable)this, this.mFirstDeltaDuration);
            } else if (this.open) {
                this.mCPUHandler.postDelayed((Runnable)this, this.mDeltaDuration);
            }
            this.updateCpuPercent();
            this.updateCurProcessCpuPercent();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void reset(long deltaDuration) {
        if (Build.VERSION.SDK_INT < 26) {
            this.mCPUHandler.removeCallbacks((Runnable)this);
            if (deltaDuration > 0L) {
                this.mDeltaDuration = deltaDuration;
                this.mCPUHandler.postDelayed((Runnable)this, this.mDeltaDuration);
                this.open = true;
            } else {
                this.open = false;
            }
        }
    }

    public float peakCpuPercent() {
        this.peakCpuLock.readLock().lock();
        float res = this.mCpuPercent;
        this.peakCpuLock.readLock().unlock();
        return res;
    }

    public float peakCurProcessCpuPercent() {
        this.peakCurProCpuLock.readLock().lock();
        float res = this.mCurProcessCpuPercent;
        this.peakCurProCpuLock.readLock().unlock();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float updateCpuPercent() {
        double usage = 0.0;
        float res = 0.0f;
        this.peakCpuLock.writeLock().lock();
        if (this.initCpu) {
            this.initCpu = false;
            RandomAccessFile reader = null;
            try {
                reader = new RandomAccessFile("/proc/stat", "r");
                String load = reader.readLine();
                String[] toks = load.split(" ");
                this.o_idle = Double.parseDouble(toks[5]);
                this.o_cpu = Double.parseDouble(toks[2]) + Double.parseDouble(toks[3]) + Double.parseDouble(toks[4]) + Double.parseDouble(toks[6]) + Double.parseDouble(toks[8]) + Double.parseDouble(toks[7]);
                this.closeRandomAccessFile(reader);
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                    this.closeRandomAccessFile(reader);
                }
                catch (Throwable throwable) {
                    this.closeRandomAccessFile(reader);
                    throw throwable;
                }
            }
        } else {
            RandomAccessFile reader = null;
            try {
                reader = new RandomAccessFile("/proc/stat", "r");
                String load = reader.readLine();
                String[] toks = load.split(" ");
                double c_idle = Double.parseDouble(toks[5]);
                double c_cpu = Double.parseDouble(toks[2]) + Double.parseDouble(toks[3]) + Double.parseDouble(toks[4]) + Double.parseDouble(toks[6]) + Double.parseDouble(toks[8]) + Double.parseDouble(toks[7]);
                if (0.0 != c_cpu + c_idle - (this.o_cpu + this.o_idle)) {
                    usage = BigNumUtils.div(100.0 * (c_cpu - this.o_cpu), c_cpu + c_idle - (this.o_cpu + this.o_idle), 2);
                    if (usage < 0.0) {
                        usage = 0.0;
                    } else if (usage > 100.0) {
                        usage = 100.0;
                    }
                }
                this.o_cpu = c_cpu;
                this.o_idle = c_idle;
                this.mCpuPercent = res = (float)usage;
                this.closeRandomAccessFile(reader);
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                    this.closeRandomAccessFile(reader);
                }
                catch (Throwable throwable) {
                    this.closeRandomAccessFile(reader);
                    throw throwable;
                }
            }
        }
        this.peakCpuLock.writeLock().unlock();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float updateCurProcessCpuPercent() {
        float percent = 0.0f;
        if (this.readProcFile == null || this.statFile == null) {
            Log.e((String)TAG, (String)("readProcFile : " + this.readProcFile + ", statFile : " + this.statFile));
            return percent;
        }
        this.peakCurProCpuLock.writeLock().lock();
        try {
            boolean invokeRet = (Boolean)this.readProcFile.invoke(null, this.statFile, PROCESS_STATS_FORMAT, null, this.statsData, null);
            boolean bl = invokeRet = invokeRet && (Boolean)this.readProcFile.invoke(null, "/proc/stat", SYSTEM_CPU_FORMAT, null, this.sysCpu, null) != false;
            if (invokeRet) {
                int mProcessRelUserTime = (int)(this.statsData[2] - this.mProcessBaseUserTime);
                int mProcessRelSystemTime = (int)(this.statsData[3] - this.mProcessBaseSystemTime);
                long usertime = this.sysCpu[0] + this.sysCpu[1];
                int mRelUserTime = (int)(usertime - this.mBaseUserTime);
                long systemtime = this.sysCpu[2];
                int mRelSystemTime = (int)(systemtime - this.mBaseSystemTime);
                long iowaittime = this.sysCpu[4];
                int mRelIoWaitTime = (int)(iowaittime - this.mBaseIoWaitTime);
                long irqtime = this.sysCpu[5];
                int mRelIrqTime = (int)(irqtime - this.mBaseIrqTime);
                long softirqtime = this.sysCpu[6];
                int mRelSoftIrqTime = (int)(softirqtime - this.mBaseSoftIrqTime);
                long idletime = this.sysCpu[3];
                int mRelIdleTime = (int)(idletime - this.mBaseIdleTime);
                mRelIdleTime = mRelIdleTime > 1 ? mRelIdleTime : this.lastRelIdleTime;
                int totalTime = mRelUserTime + mRelSystemTime + mRelIoWaitTime + mRelIrqTime + mRelSoftIrqTime + mRelIdleTime;
                if (totalTime > 1) {
                    this.mCurProcessCpuPercent = percent = BigNumUtils.div((mProcessRelUserTime + mProcessRelSystemTime) * 100, totalTime, 2);
                }
                this.mProcessBaseUserTime = this.statsData[2];
                this.mProcessBaseSystemTime = this.statsData[3];
                this.mBaseUserTime = usertime;
                this.mBaseSystemTime = systemtime;
                this.mBaseIdleTime = idletime;
                this.mBaseIoWaitTime = iowaittime;
                this.mBaseIrqTime = irqtime;
                this.mBaseSoftIrqTime = softirqtime;
                this.lastRelIdleTime = mRelIdleTime;
                float f = percent;
                return f;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.peakCurProCpuLock.writeLock().unlock();
        }
        return percent;
    }

    private void closeRandomAccessFile(RandomAccessFile f) {
        if (f != null) {
            try {
                f.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

