/*
 * Decompiled with CFR 0.152.
 */
package com.ali.alihadeviceevaluator.mem;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Debug;
import java.lang.reflect.Method;

public class AliHAMemoryTracker {
    public long[] getHeapJVM() {
        long[] arrayOfLong1 = new long[]{Runtime.getRuntime().maxMemory() >> 10, Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() >> 10};
        return arrayOfLong1;
    }

    public long[] getHeapNative() {
        long[] arrayOfLong = new long[]{Debug.getNativeHeapSize() >> 10, Debug.getNativeHeapAllocatedSize() - Debug.getNativeHeapFreeSize() >> 10};
        return arrayOfLong;
    }

    public long[] getDeviceMem() {
        long[] arrayOfLong = this.getMemInfo();
        long[] arrayOfLong1 = new long[]{arrayOfLong[0], arrayOfLong[0] - (arrayOfLong[1] + arrayOfLong[2] + arrayOfLong[3])};
        return arrayOfLong1;
    }

    private long[] getMemInfo() {
        long[] arrayOfLong1 = new long[4];
        try {
            Method localMethod = Class.forName("android.os.Process").getMethod("readProcLines", String.class, String[].class, long[].class);
            Object[] arrayOfObject = new Object[3];
            String[] arrayOfString = new String[]{"MemTotal:", "MemFree:", "Buffers:", "Cached:"};
            long[] arrayOfLong2 = new long[arrayOfString.length];
            arrayOfLong2[0] = 30L;
            arrayOfLong2[1] = -30L;
            arrayOfObject[0] = "/proc/meminfo";
            arrayOfObject[1] = arrayOfString;
            arrayOfObject[2] = arrayOfLong2;
            if (localMethod != null) {
                localMethod.invoke(null, arrayOfObject);
                for (int i = 0; i < arrayOfLong2.length; ++i) {
                    arrayOfLong1[i] = arrayOfLong2[i];
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return arrayOfLong1;
        }
        return arrayOfLong1;
    }

    public long[] getPrivateDirty(Context context, int pid) {
        ActivityManager mAm = (ActivityManager)context.getSystemService("activity");
        int[] pids = new int[]{pid};
        Debug.MemoryInfo[] memoryInfoArray = mAm.getProcessMemoryInfo(pids);
        Debug.MemoryInfo pidMemoryInfo = memoryInfoArray[0];
        long[] value = new long[]{pidMemoryInfo.dalvikPrivateDirty, pidMemoryInfo.nativePrivateDirty, pidMemoryInfo.getTotalPrivateDirty()};
        return value;
    }

    public long[] getPSS(Context context, int pid) {
        long[] value = new long[3];
        try {
            if (pid >= 0) {
                int[] pids = new int[]{pid};
                ActivityManager mAm = (ActivityManager)context.getSystemService("activity");
                Debug.MemoryInfo[] memoryInfoArray = mAm.getProcessMemoryInfo(pids);
                Debug.MemoryInfo pidMemoryInfo = memoryInfoArray[0];
                value[0] = pidMemoryInfo.dalvikPss;
                value[1] = pidMemoryInfo.nativePss;
                value[2] = pidMemoryInfo.getTotalPss();
            } else {
                value[0] = 0L;
                value[1] = 0L;
                value[2] = 0L;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return value;
    }
}

