/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.procedure;

import com.taobao.monitor.procedure.IProcedure;

public class ProcedureConfig {
    private final IProcedure parent;
    private final boolean upload;
    private final boolean independent;
    private final boolean parentNeedStats;
    private final PreUploadListener preUploadListener;

    private ProcedureConfig(Builder builder) {
        this.upload = builder.upload;
        this.independent = builder.independent;
        this.parent = builder.parent;
        this.parentNeedStats = builder.parentNeedStats;
        this.preUploadListener = builder.preUploadListener;
    }

    public IProcedure getParent() {
        return this.parent;
    }

    public boolean isUpload() {
        return this.upload;
    }

    public boolean isIndependent() {
        return this.independent;
    }

    public boolean isParentNeedStats() {
        return this.parentNeedStats;
    }

    public PreUploadListener getPreUploadListener() {
        return this.preUploadListener;
    }

    public static interface PreUploadListener {
        public boolean onPreUpload();
    }

    public static class Builder {
        private boolean upload;
        private PreUploadListener preUploadListener;
        private boolean independent;
        private boolean parentNeedStats;
        private IProcedure parent;

        public Builder setParent(IProcedure parent) {
            this.parent = parent;
            return this;
        }

        public Builder setUpload(boolean upload) {
            this.upload = upload;
            return this;
        }

        public Builder setIndependent(boolean independent) {
            this.independent = independent;
            return this;
        }

        public Builder setParentNeedStats(boolean parentNeedStats) {
            this.parentNeedStats = parentNeedStats;
            return this;
        }

        public Builder setPreUploadListener(PreUploadListener listener) {
            this.preUploadListener = listener;
            return this;
        }

        public ProcedureConfig build() {
            return new ProcedureConfig(this);
        }
    }
}

