/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.network.lifecycle;

import com.taobao.network.lifecycle.IMtopLifecycle;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MtopLifecycleManager
implements IMtopLifecycle {
    private IMtopLifecycle lifecycle;
    private Lock readLock;
    private Lock writeLock;

    private MtopLifecycleManager() {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    public static MtopLifecycleManager instance() {
        return Holder.INSTANCE;
    }

    public void setLifecycle(IMtopLifecycle iMtopLifecycle) {
        this.writeLock.lock();
        try {
            if (this.lifecycle == null) {
                this.lifecycle = iMtopLifecycle;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeLifecycle(IMtopLifecycle iMtopLifecycle) {
        this.writeLock.lock();
        try {
            this.lifecycle = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMtopRequest(String requestId, String requestUrl, Map<String, Object> params) {
        this.readLock.lock();
        try {
            if (this.lifecycle != null) {
                this.lifecycle.onMtopRequest(requestId, requestUrl, params);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void onMtopError(String requestId, Map<String, Object> params) {
        this.readLock.lock();
        try {
            if (this.lifecycle != null) {
                this.lifecycle.onMtopError(requestId, params);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void onMtopCancel(String requestId, Map<String, Object> params) {
        this.readLock.lock();
        try {
            if (this.lifecycle != null) {
                this.lifecycle.onMtopCancel(requestId, params);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void onMtopFinished(String requestId, Map<String, Object> params) {
        this.readLock.lock();
        try {
            if (this.lifecycle != null) {
                this.lifecycle.onMtopFinished(requestId, params);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMtopEvent(String requestId, String name, Map<String, Object> params) {
        this.readLock.lock();
        try {
            if (this.lifecycle != null) {
                this.lifecycle.onMtopEvent(requestId, name, params);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static final class Holder {
        private static final MtopLifecycleManager INSTANCE = new MtopLifecycleManager();

        private Holder() {
        }
    }
}

