/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.network.lifecycle;

import com.taobao.network.lifecycle.INetworkLifecycle;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class NetworkLifecycleManager
implements INetworkLifecycle {
    private INetworkLifecycle lifecycle;
    private Lock readLock;
    private Lock writeLock;

    private NetworkLifecycleManager() {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    public static NetworkLifecycleManager instance() {
        return Holder.INSTANCE;
    }

    public void setLifecycle(INetworkLifecycle iNetworkLifecycle) {
        this.writeLock.lock();
        try {
            if (this.lifecycle == null) {
                this.lifecycle = iNetworkLifecycle;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeLifecycle(INetworkLifecycle iNetworkLifecycle) {
        this.writeLock.lock();
        try {
            this.lifecycle = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequest(String requestId, String requestUrl, Map<String, Object> params) {
        this.readLock.lock();
        try {
            if (this.lifecycle != null) {
                this.lifecycle.onRequest(requestId, requestUrl, params);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onValidRequest(String requestId, String requestUrl, Map<String, Object> params) {
        this.readLock.lock();
        try {
            if (this.lifecycle != null) {
                this.lifecycle.onValidRequest(requestId, requestUrl, params);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void onError(String requestId, Map<String, Object> params) {
        this.readLock.lock();
        try {
            if (this.lifecycle != null) {
                this.lifecycle.onError(requestId, params);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void onCancel(String requestId, Map<String, Object> params) {
        this.readLock.lock();
        try {
            if (this.lifecycle != null) {
                this.lifecycle.onCancel(requestId, params);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void onFinished(String requestId, Map<String, Object> params) {
        this.readLock.lock();
        try {
            if (this.lifecycle != null) {
                this.lifecycle.onFinished(requestId, params);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(String requestId, String name, Map<String, Object> params) {
        this.readLock.lock();
        try {
            if (this.lifecycle != null) {
                this.lifecycle.onEvent(requestId, name, params);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static final class Holder {
        private static final NetworkLifecycleManager INSTANCE = new NetworkLifecycleManager();

        private Holder() {
        }
    }
}

