/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.phenix.lifecycle;

import com.taobao.phenix.lifecycle.IPhenixLifeCycle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PhenixLifeCycleManager
implements IPhenixLifeCycle {
    private List<IPhenixLifeCycle> lifeCycles = new ArrayList<IPhenixLifeCycle>(2);
    private Lock readLock;
    private Lock writeLock;

    private PhenixLifeCycleManager() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public static PhenixLifeCycleManager instance() {
        return Holder.INSTANCE;
    }

    public void addLifeCycle(IPhenixLifeCycle lifeCycle) {
        this.writeLock.lock();
        try {
            if (lifeCycle != null && !this.lifeCycles.contains(lifeCycle)) {
                this.lifeCycles.add(lifeCycle);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeLifeCycle(IPhenixLifeCycle lifecycle) {
        this.writeLock.lock();
        try {
            this.lifeCycles.remove(lifecycle);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequest(String requestId, String requestUrl, Map<String, Object> params) {
        this.readLock.lock();
        try {
            for (IPhenixLifeCycle lifecycle : this.lifeCycles) {
                lifecycle.onRequest(requestId, requestUrl, params);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(String requestId, String requestUrl, Map<String, Object> params) {
        this.readLock.lock();
        try {
            for (IPhenixLifeCycle lifecycle : this.lifeCycles) {
                lifecycle.onError(requestId, requestUrl, params);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCancel(String requestId, String requestUrl, Map<String, Object> params) {
        this.readLock.lock();
        try {
            for (IPhenixLifeCycle lifecycle : this.lifeCycles) {
                lifecycle.onCancel(requestId, requestUrl, params);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFinished(String requestId, String requestUrl, Map<String, Object> params) {
        this.readLock.lock();
        try {
            for (IPhenixLifeCycle lifecycle : this.lifeCycles) {
                lifecycle.onFinished(requestId, requestUrl, params);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(String requestId, String name, Map<String, Object> params) {
        this.readLock.lock();
        try {
            for (IPhenixLifeCycle lifecycle : this.lifeCycles) {
                lifecycle.onEvent(requestId, name, params);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static class Holder {
        private static final PhenixLifeCycleManager INSTANCE = new PhenixLifeCycleManager();

        private Holder() {
        }
    }
}

