/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.text.TextUtils;
import com.taobao.monitor.ProcedureGlobal;
import com.taobao.monitor.procedure.Header;
import com.taobao.monitor.procedure.IProcedureFactory;
import com.taobao.monitor.procedure.IProcedureManager;
import com.taobao.monitor.procedure.ProcedureFactoryProxy;
import com.taobao.monitor.procedure.ProcedureManagerProxy;
import com.taobao.monitor.util.ProcessUtils;
import java.lang.reflect.Method;
import java.util.Map;

public class ProcedureLauncher {
    private static boolean init = false;

    private ProcedureLauncher() {
    }

    public static void init(Context context, Map<String, Object> params) {
        if (!init) {
            init = true;
            ProcedureGlobal.instance().setContext(context);
            ProcedureLauncher.initHeader(context, params);
            ProcedureManagerProxy.PROXY.setReal((IProcedureManager)ProcedureGlobal.PROCEDURE_MANAGER);
            ProcedureFactoryProxy.PROXY.setReal((IProcedureFactory)ProcedureGlobal.PROCEDURE_FACTORY);
        }
    }

    private static void initHeader(Context context, Map<String, Object> params) {
        Header.appId = context.getPackageName();
        Header.appKey = ProcedureLauncher.safeString(params.get("onlineAppKey"), "12278902");
        Header.appBuild = ProcedureLauncher.safeString(params.get("appBuild"), "");
        Header.appVersion = ProcedureLauncher.safeString(params.get("appVersion"), new Delay<String>(){

            @Override
            public String call() {
                Context context1 = ProcedureGlobal.instance().context();
                try {
                    PackageInfo packageInfo = context1.getPackageManager().getPackageInfo(context1.getPackageName(), 0);
                    return packageInfo.versionName;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return "unknown";
                }
            }
        });
        Header.appPatch = ProcedureLauncher.safeString(params.get("appPatch"), "");
        Header.channel = ProcedureLauncher.safeString(params.get("channel"), "");
        Header.utdid = ProcedureLauncher.safeString(params.get("deviceId"), "");
        Header.brand = Build.BRAND;
        Header.deviceModel = Build.MODEL;
        String[] os = ProcedureLauncher.OS();
        if (!TextUtils.isEmpty((CharSequence)os[0])) {
            Header.osVersion = os[0];
            Header.os = os[1];
        } else {
            Header.osVersion = Build.VERSION.RELEASE;
            Header.os = "android";
        }
        Header.processName = ProcedureLauncher.safeString(params.get("process"), new Delay<String>(){

            @Override
            public String call() {
                return ProcessUtils.getCurrProcessName();
            }
        });
        Header.session = String.valueOf(System.currentTimeMillis());
        Header.ttid = ProcedureLauncher.safeString(params.get("ttid"), "");
    }

    private static String safeString(Object string, String defaultValue) {
        if (string instanceof String && !TextUtils.isEmpty((CharSequence)((String)string))) {
            return (String)string;
        }
        return defaultValue;
    }

    private static String safeString(Object string, Delay<String> delay) {
        if (string instanceof String && !TextUtils.isEmpty((CharSequence)((String)string))) {
            return (String)string;
        }
        return delay.call();
    }

    @SuppressLint(value={"DefaultLocale"})
    private static String[] OS() {
        String version = null;
        String vmName = null;
        try {
            Method m = Class.forName("android.os.SystemProperties").getMethod("get", String.class);
            version = (String)m.invoke(null, "ro.yunos.version");
            vmName = (String)m.invoke(null, "java.vm.name");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new String[]{version, vmName};
    }

    private static interface Delay<T> {
        public T call();
    }
}

