/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.network;

import com.taobao.monitor.common.ThreadUtils;
import com.taobao.monitor.logger.Logger;
import com.taobao.monitor.network.NetworkSenderProxy;
import com.taobao.monitor.procedure.Header;
import com.taobao.monitor.procedure.ProcedureConfig;
import com.taobao.monitor.procedure.ProcedureImpl;
import com.taobao.monitor.procedure.Value;
import com.taobao.monitor.procedure.model.Biz;
import com.taobao.monitor.procedure.model.Event;
import com.taobao.monitor.procedure.model.Stage;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class ProcedureLifecycleImpl
implements ProcedureImpl.IProcedureLifeCycle {
    private static final String TAG = "NetworkDataUpdate";
    private ProcedureConfig.PreUploadListener preUploadListener;

    public ProcedureLifecycleImpl setPreUploadListener(ProcedureConfig.PreUploadListener listener) {
        this.preUploadListener = listener;
        return this;
    }

    @Override
    public void begin(Value value) {
    }

    @Override
    public void event(Value value, Event event) {
    }

    @Override
    public void stage(Value value, Stage stage) {
    }

    @Override
    public void end(final Value value) {
        boolean upload = true;
        if (this.preUploadListener != null) {
            upload = this.preUploadListener.onPreUpload();
        }
        if (upload) {
            ThreadUtils.start(new Runnable(){

                @Override
                public void run() {
                    ProcedureLifecycleImpl.this.doSendData(value);
                }
            });
        }
    }

    private void doSendData(Value value) {
        JSONObject monitorJson = new JSONObject();
        try {
            monitorJson.put("version", (Object)Header.apmVersion);
            monitorJson.put("topic", (Object)value.topic());
            JSONObject headerJson = new JSONObject();
            headerJson.put("X-timestamp", value.timestamp()).put("X-appId", (Object)Header.appId).put("X-appKey", (Object)Header.appKey).put("X-appBuild", (Object)Header.appBuild).put("X-appPatch", (Object)Header.appPatch).put("X-channel", (Object)Header.channel).put("X-utdid", (Object)Header.utdid).put("X-brand", (Object)Header.brand).put("X-deviceModel", (Object)Header.deviceModel).put("X-os", (Object)Header.os).put("X-osVersion", (Object)Header.osVersion).put("X-userId", (Object)Header.userId).put("X-userNick", (Object)Header.userNick).put("X-session", (Object)Header.session).put("X-processName", (Object)Header.processName).put("X-appVersion", (Object)Header.appVersion).put("X-launcherMode", (Object)Header.launcherMode);
            monitorJson.put("headers", (Object)headerJson);
            monitorJson.put("value", (Object)this.valueJson(value));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String content = monitorJson.toString();
        Logger.i(TAG, content);
        NetworkSenderProxy.instance().send(value.topic(), content);
    }

    private JSONObject valueJson(Value value) throws Exception {
        List<Value> subValues;
        List<Stage> stages;
        List<Event> events;
        Map<String, Integer> counters;
        List<Biz> bizs;
        JSONObject valueJson = new JSONObject();
        JSONObject propertiesJson = new JSONObject();
        boolean hasProperties = false;
        Map<String, Object> map = value.properties();
        if (map != null && map.size() != 0) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object object = entry.getValue();
                this.safePutJson(propertiesJson, key, object);
            }
            hasProperties = true;
        }
        if ((bizs = value.bizs()) != null && bizs.size() != 0) {
            JSONObject bizsJson = new JSONObject();
            for (Biz biz : bizs) {
                Map<String, Object> stages2;
                Map<String, Object> abTest;
                Map<String, Object> properties = biz.properties();
                JSONObject paramsJson = new JSONObject();
                if (properties != null && properties.size() != 0) {
                    this.mapInsert2Json(paramsJson, properties);
                }
                if ((abTest = biz.abTest()) != null && abTest.size() != 0) {
                    JSONObject abTestJson = new JSONObject();
                    this.mapInsert2Json(abTestJson, abTest);
                    paramsJson.put("abtest", (Object)abTestJson);
                }
                if ((stages2 = biz.stages()) != null && stages2.size() != 0) {
                    JSONObject stagesJson = new JSONObject();
                    this.mapInsert2Json(stagesJson, stages2);
                    paramsJson.put("stages", (Object)stagesJson);
                }
                bizsJson.put(biz.bizID(), (Object)paramsJson);
            }
            propertiesJson.put("bizTags", (Object)bizsJson);
            hasProperties = true;
        }
        if (hasProperties) {
            valueJson.put("properties", (Object)propertiesJson);
        }
        Map<String, Object> statistics = value.statistics();
        JSONObject statisticsJson = new JSONObject();
        if (statistics != null && statistics.size() != 0) {
            this.mapInsert2Json(statisticsJson, statistics);
        }
        if ((counters = value.counters()) != null && counters.size() != 0) {
            this.mapInsert2Json(statisticsJson, counters);
        }
        if (counters.size() != 0 || statistics.size() != 0) {
            valueJson.put("stats", (Object)statisticsJson);
        }
        if ((events = value.events()) != null && events.size() != 0) {
            JSONArray eventsArray = new JSONArray();
            for (Event event : events) {
                JSONObject eventJson = new JSONObject();
                eventJson.put("timestamp", event.timestamp());
                eventJson.put("name", (Object)event.name());
                Map<String, Object> map2 = event.properties();
                this.mapInsert2Json(eventJson, map2);
                eventsArray.put((Object)eventJson);
            }
            valueJson.put("events", (Object)eventsArray);
        }
        if ((stages = value.stages()) != null && stages.size() != 0) {
            JSONObject stagesJson = new JSONObject();
            for (Stage stage : stages) {
                stagesJson.put(stage.name(), stage.timestamp());
            }
            valueJson.put("stages", (Object)stagesJson);
        }
        if ((subValues = value.subValues()) != null && subValues.size() != 0) {
            JSONArray subValueArray = new JSONArray();
            for (Value subValue : subValues) {
                JSONObject subValueParamsJson = this.valueJson(subValue);
                JSONObject subValueJson = new JSONObject();
                subValueJson.put(subValue.topic(), (Object)subValueParamsJson);
                subValueArray.put((Object)subValueJson);
            }
            valueJson.put("subProcedures", (Object)subValueArray);
        }
        return valueJson;
    }

    private void mapInsert2Json(JSONObject jsonObject, Map<String, ?> map) throws Exception {
        this.mapInsert2Json(jsonObject, map, 2);
    }

    private void mapInsert2Json(JSONObject jsonObject, Map<String, ?> map, int depth) throws Exception {
        if (map == null || depth <= 0) {
            return;
        }
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String key = entry.getKey();
            Object object = entry.getValue();
            this.safePutJson(jsonObject, key, object, depth);
        }
    }

    private void safePutJson(JSONObject jsonObject, String key, Object value) throws Exception {
        this.safePutJson(jsonObject, key, value, 2);
    }

    private void safePutJson(JSONObject jsonObject, String key, Object value, int depth) throws Exception {
        if (value instanceof Integer) {
            jsonObject.put(key, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            jsonObject.put(key, ((Long)value).longValue());
        } else if (value instanceof Float) {
            jsonObject.put(key, (double)((Float)value).floatValue());
        } else if (value instanceof Double) {
            jsonObject.put(key, ((Double)value).doubleValue());
        } else if (value instanceof Boolean) {
            jsonObject.put(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Character) {
            jsonObject.put(key, (int)((Character)value).charValue());
        } else if (value instanceof Short) {
            jsonObject.put(key, (int)((Short)value).shortValue());
        } else if (value instanceof Map) {
            if (((Map)value).size() != 0) {
                JSONObject mapJson = new JSONObject();
                this.mapInsert2Json(mapJson, (Map)value, --depth);
                jsonObject.put(key, (Object)mapJson);
            }
        } else {
            jsonObject.put(key, value);
        }
    }
}

