/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.procedure;

import com.taobao.monitor.ProcedureGlobal;
import com.taobao.monitor.network.ProcedureLifecycleImpl;
import com.taobao.monitor.procedure.IProcedure;
import com.taobao.monitor.procedure.IProcedureFactory;
import com.taobao.monitor.procedure.ProcedureConfig;
import com.taobao.monitor.procedure.ProcedureImpl;
import com.taobao.monitor.procedure.ProcedureProxy;

public class ProcedureFactory
implements IProcedureFactory {
    public IProcedure createProcedure(String topic) {
        ProcedureConfig.Builder builder = new ProcedureConfig.Builder().setUpload(false).setIndependent(true).setParentNeedStats(true).setParent(ProcedureGlobal.PROCEDURE_MANAGER.getCurrentProcedure());
        return this.createProcedure(topic, builder.build());
    }

    public IProcedure createProcedure(String topic, ProcedureConfig config) {
        if (config == null) {
            config = new ProcedureConfig.Builder().setUpload(false).setIndependent(true).setParentNeedStats(true).setParent(ProcedureGlobal.PROCEDURE_MANAGER.getCurrentProcedure()).build();
        }
        ProcedureImpl impl = this.createProcedureImpl(topic, config);
        return new ProcedureProxy(impl);
    }

    private ProcedureImpl createProcedureImpl(String topic, ProcedureConfig config) {
        IProcedure parent = config.getParent();
        if (parent == IProcedure.DEFAULT) {
            parent = ProcedureGlobal.PROCEDURE_MANAGER.getCurrentProcedure();
        }
        ProcedureImpl impl = new ProcedureImpl(topic, parent, config.isIndependent(), config.isParentNeedStats());
        if (config.isUpload()) {
            impl.setLifeCycle(new ProcedureLifecycleImpl().setPreUploadListener(config.getPreUploadListener()));
        }
        return impl;
    }
}

