/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.procedure;

import com.taobao.monitor.ProcedureGlobal;
import com.taobao.monitor.exception.ProcedureException;
import com.taobao.monitor.logger.Logger;
import com.taobao.monitor.procedure.IProcedure;
import com.taobao.monitor.procedure.IProcedureGroup;
import com.taobao.monitor.procedure.IValueCallback;
import com.taobao.monitor.procedure.ProcedureProxy;
import com.taobao.monitor.procedure.Value;
import com.taobao.monitor.procedure.model.Event;
import com.taobao.monitor.procedure.model.Stage;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ProcedureImpl
implements IProcedureGroup,
IValueCallback {
    private static final String TAG = "ProcedureImpl";
    private String topic;
    private static volatile long count = System.currentTimeMillis();
    private final String session = String.valueOf(count++);
    private final IProcedure parent;
    private final Value value;
    private Status status = Status.INIT;
    private List<IProcedure> subProcedures;
    private IProcedureLifeCycle lifeCycle;
    private final boolean independent;

    ProcedureImpl(String topic, IProcedure parent, boolean independent, boolean parentNeedStats) {
        this.topic = topic;
        this.parent = parent;
        this.independent = independent;
        this.value = new Value(topic, independent, parentNeedStats);
        if (parent != null) {
            this.value.addProperty("parentSession", parent.topicSession());
        }
        this.value.addProperty("session", this.session);
    }

    public String topic() {
        return this.topic;
    }

    public String topicSession() {
        return this.session;
    }

    public IProcedure begin() {
        if (this.status == Status.INIT) {
            this.status = Status.RUNNING;
            if (this.parent instanceof IProcedureGroup) {
                ((IProcedureGroup)this.parent).addSubProcedure(this);
            }
            this.subProcedures = new LinkedList<IProcedure>();
            Logger.i(TAG, this.parent, this.topic, "begin()");
            if (this.lifeCycle != null) {
                this.lifeCycle.begin(this.value);
            }
        }
        return this;
    }

    public IProcedure event(String name, Map<String, Object> properties) {
        if (name != null && this.isAlive()) {
            Event event = new Event(name, properties);
            this.value.event(event);
            if (this.lifeCycle != null) {
                this.lifeCycle.event(this.value, event);
            }
            Logger.i(TAG, this.parent, this.topic, name);
        }
        return this;
    }

    public IProcedure stage(String name, long timestamp) {
        if (name != null && this.isAlive()) {
            Stage stage = new Stage(name, timestamp);
            this.value.stage(stage);
            if (this.lifeCycle != null) {
                this.lifeCycle.stage(this.value, stage);
            }
            Logger.i(TAG, this.parent, this.topic, stage);
        }
        return this;
    }

    public IProcedure addBiz(String bizID, Map<String, Object> properties) {
        if (bizID != null && this.isAlive()) {
            this.value.addBiz(bizID, properties);
            Logger.i(TAG, this.parent, this.topic, bizID);
        }
        return this;
    }

    public IProcedure addBizAbTest(String bizID, Map<String, Object> abTest) {
        if (bizID != null && this.isAlive()) {
            this.value.addBizAbTest(bizID, abTest);
            Logger.i(TAG, this.parent, this.topic, bizID);
        }
        return this;
    }

    public IProcedure addBizStage(String bizID, Map<String, Object> stage) {
        if (bizID != null && this.isAlive()) {
            this.value.addBizStage(bizID, stage);
            Logger.i(TAG, this.parent, this.topic, bizID);
        }
        return this;
    }

    public IProcedure addProperty(String key, Object object) {
        if (this.isAlive()) {
            this.value.addProperty(key, object);
        }
        return this;
    }

    public IProcedure addStatistic(String key, Object object) {
        if (this.isAlive()) {
            this.value.addStatistic(key, object);
        }
        return this;
    }

    public boolean isAlive() {
        return Status.STOPPED != this.status;
    }

    public IProcedure end() {
        return this.end(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProcedure end(boolean force) {
        if (this.status == Status.RUNNING) {
            List<IProcedure> list = this.subProcedures;
            synchronized (list) {
                for (IProcedure subProcedure : this.subProcedures) {
                    if (subProcedure instanceof ProcedureProxy) {
                        IProcedure procedure = ((ProcedureProxy)subProcedure).base();
                        if (procedure instanceof ProcedureImpl) {
                            ProcedureImpl subImpl = (ProcedureImpl)procedure;
                            if (subImpl.isAlive()) {
                                this.value.addSubValue(subImpl.value4Parent());
                            }
                            if (subImpl.independent && !force) continue;
                            procedure.end(force);
                            continue;
                        }
                        procedure.end(force);
                        continue;
                    }
                    subProcedure.end(force);
                }
            }
            if (this.parent instanceof IProcedureGroup) {
                ProcedureGlobal.instance().handler().post(new Runnable(){

                    @Override
                    public void run() {
                        ((IProcedureGroup)ProcedureImpl.this.parent).removeSubProcedure(ProcedureImpl.this);
                    }
                });
            }
            if (this.parent instanceof IValueCallback) {
                ((IValueCallback)this.parent).callback(this.value4Parent());
            }
            if (this.lifeCycle != null) {
                this.lifeCycle.end(this.value);
            }
            this.status = Status.STOPPED;
            Logger.i(TAG, this.parent, this.topic, "end()");
        }
        return this;
    }

    protected Value value4Parent() {
        return this.value.summary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSubProcedure(IProcedure subProcedure) {
        if (subProcedure != null && this.isAlive()) {
            List<IProcedure> list = this.subProcedures;
            synchronized (list) {
                this.subProcedures.add(subProcedure);
            }
        }
    }

    public IProcedure parent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubProcedure(IProcedure subProcedure) {
        if (subProcedure != null) {
            List<IProcedure> list = this.subProcedures;
            synchronized (list) {
                this.subProcedures.remove(subProcedure);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.status == Status.RUNNING) {
            Logger.throwException(new ProcedureException("Please call end function first!"));
        }
    }

    public Value value() {
        return this.value;
    }

    public ProcedureImpl setLifeCycle(IProcedureLifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    public String toString() {
        return this.topic;
    }

    @Override
    public void callback(Value subValue) {
        if (this.isAlive()) {
            this.value.addSubValue(subValue);
        }
    }

    public static interface IProcedureLifeCycle {
        public void begin(Value var1);

        public void event(Value var1, Event var2);

        public void stage(Value var1, Stage var2);

        public void end(Value var1);
    }

    private static enum Status {
        INIT,
        RUNNING,
        STOPPED;

    }
}

