/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.procedure;

import android.os.SystemClock;
import android.text.TextUtils;
import com.taobao.monitor.procedure.model.Biz;
import com.taobao.monitor.procedure.model.Event;
import com.taobao.monitor.procedure.model.Stage;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Value {
    private static final String TAG = "Value";
    private final String topic;
    private final String simpleTopic;
    private long timestamp = SystemClock.uptimeMillis();
    private List<Value> subValues;
    private List<Event> events;
    private List<Stage> stages;
    private Map<String, Object> statistics;
    private Map<String, Object> properties;
    private List<Biz> bizs;
    private Map<String, Biz> bizIndex;
    private Map<String, Integer> counters;
    private final boolean independent;
    private final boolean parentNeedStats;

    Value(String topic, boolean independent, boolean parentNeedStats) {
        this.topic = topic;
        int index = topic.lastIndexOf("/");
        this.simpleTopic = index != -1 && topic.length() > index + 1 ? topic.substring(index + 1) : topic;
        this.independent = independent;
        this.parentNeedStats = parentNeedStats;
        this.initialize();
    }

    private void initialize() {
        this.subValues = new LinkedList<Value>();
        this.events = new LinkedList<Event>();
        this.stages = new LinkedList<Stage>();
        this.statistics = new ConcurrentHashMap<String, Object>();
        this.counters = new ConcurrentHashMap<String, Integer>();
        this.properties = new ConcurrentHashMap<String, Object>();
        this.bizs = new LinkedList<Biz>();
        this.bizIndex = new ConcurrentHashMap<String, Biz>();
    }

    public String topic() {
        return this.topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value event(Event event) {
        if (event != null) {
            List<Event> list = this.events;
            synchronized (list) {
                this.events.add(event);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value stage(Stage stage) {
        if (stage != null) {
            List<Stage> list = this.stages;
            synchronized (list) {
                this.stages.add(stage);
            }
        }
        return this;
    }

    Value addProperty(String key, Object value) {
        if (value == null || key == null) {
            return this;
        }
        this.properties.put(key, value);
        return this;
    }

    Value addStatistic(String key, Object value) {
        if (value == null || key == null) {
            return this;
        }
        this.statistics.put(key, value);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value addBiz(String bizId, Map<String, Object> properties) {
        if (bizId != null) {
            Biz history = this.bizIndex.get(bizId);
            if (history == null) {
                Biz biz = new Biz(bizId, properties);
                this.bizIndex.put(bizId, biz);
                List<Biz> list = this.bizs;
                synchronized (list) {
                    this.bizs.add(biz);
                }
                history = biz;
            }
            history.addProperties(properties);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value addBizAbTest(String bizId, Map<String, Object> abTest) {
        if (bizId != null) {
            Biz history = this.bizIndex.get(bizId);
            if (history == null) {
                Biz biz = new Biz(bizId, null);
                this.bizIndex.put(bizId, biz);
                List<Biz> list = this.bizs;
                synchronized (list) {
                    this.bizs.add(biz);
                }
                history = biz;
            }
            history.addAbTest(abTest);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value addBizStage(String bizId, Map<String, Object> stage) {
        if (bizId != null) {
            Biz history = this.bizIndex.get(bizId);
            if (history == null) {
                Biz biz = new Biz(bizId, null);
                this.bizIndex.put(bizId, biz);
                List<Biz> list = this.bizs;
                synchronized (list) {
                    this.bizs.add(biz);
                }
                history = biz;
            }
            history.addStage(stage);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value addSubValue(Value subValue) {
        if (subValue != null) {
            String subSimpleTopic = subValue.simpleTopic;
            if (TextUtils.isEmpty((CharSequence)subSimpleTopic)) {
                return this;
            }
            Integer count = this.counters.get(subSimpleTopic);
            if (count == null) {
                this.counters.put(subSimpleTopic, 1);
            } else {
                this.counters.put(subSimpleTopic, count + 1);
            }
            if (subValue.parentNeedStats) {
                List<Stage> stages = subValue.stages;
                for (Stage stage : stages) {
                    String subStageName = stage.name();
                    char[] strChar = subStageName.toCharArray();
                    if (strChar[0] >= 'a') {
                        strChar[0] = (char)(strChar[0] - 32);
                    }
                    subStageName = String.valueOf(strChar);
                    String stageName = subSimpleTopic + subStageName;
                    Integer stageCount = this.counters.get(stageName);
                    if (stageCount == null) {
                        this.counters.put(stageName, 1);
                        continue;
                    }
                    this.counters.put(stageName, stageCount + 1);
                }
            }
            List<Value> list = this.subValues;
            synchronized (list) {
                if (!subValue.independent) {
                    this.subValues.add(subValue);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value removeSubValue(Value subValue) {
        if (subValue != null) {
            List<Value> list = this.subValues;
            synchronized (list) {
                this.subValues.remove(subValue);
            }
        }
        return this;
    }

    Value summary() {
        Value value = new Value(this.simpleTopic, this.independent, this.parentNeedStats);
        value.stages = this.stages;
        value.properties = this.properties;
        return value;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public List<Value> subValues() {
        return this.subValues;
    }

    public List<Event> events() {
        return this.events;
    }

    public List<Stage> stages() {
        return this.stages;
    }

    public List<Biz> bizs() {
        return this.bizs;
    }

    public Map<String, Object> statistics() {
        return this.statistics;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public Map<String, Integer> counters() {
        return this.counters;
    }

    public String toString() {
        return this.topic;
    }
}

