/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.util;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import com.taobao.monitor.ProcedureGlobal;
import java.io.FileInputStream;
import java.util.List;

public final class ProcessUtils {
    private static String sProcessName;

    public static String getCurrProcessName() {
        Context context = ProcedureGlobal.instance().context();
        if (TextUtils.isEmpty((CharSequence)sProcessName)) {
            String name = ProcessUtils.getCurrentProcessNameViaLinuxFile();
            if (TextUtils.isEmpty((CharSequence)name) && context != null) {
                name = ProcessUtils.getCurrentProcessNameViaActivityManager(context);
            }
            sProcessName = name;
        }
        return sProcessName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCurrentProcessNameViaLinuxFile() {
        int pid = Process.myPid();
        String line = "/proc/" + pid + "/cmdline";
        FileInputStream fis = null;
        String processName = null;
        byte[] bytes = new byte[1024];
        int read = 0;
        try {
            fis = new FileInputStream(line);
            read = fis.read(bytes);
        }
        catch (Exception exception) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        if (read > 0) {
            processName = new String(bytes, 0, read);
            processName = processName.trim();
        }
        return processName;
    }

    private static String getCurrentProcessNameViaActivityManager(Context context) {
        if (context == null) {
            return null;
        }
        if (sProcessName != null) {
            return sProcessName;
        }
        int pid = Process.myPid();
        ActivityManager mActivityManager = (ActivityManager)context.getSystemService("activity");
        if (mActivityManager == null) {
            return null;
        }
        List processes = mActivityManager.getRunningAppProcesses();
        if (processes == null) {
            return null;
        }
        for (ActivityManager.RunningAppProcessInfo appProcess : processes) {
            if (appProcess == null || appProcess.pid != pid) continue;
            sProcessName = appProcess.processName;
            break;
        }
        return sProcessName;
    }
}

