/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.adapter;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.View;
import android.webkit.WebView;
import com.ali.alihadeviceevaluator.AliHAHardware;
import com.ali.ha.datahub.BizSubscriber;
import com.ali.ha.datahub.DataHub;
import com.taobao.application.common.Apm;
import com.taobao.application.common.ApmManager;
import com.taobao.application.common.data.DeviceHelper;
import com.taobao.application.common.impl.AppPreferencesImpl;
import com.taobao.monitor.APMLauncher;
import com.taobao.monitor.ProcedureGlobal;
import com.taobao.monitor.ProcedureLauncher;
import com.taobao.monitor.adapter.DataHubProcedureGroupHelper;
import com.taobao.monitor.adapter.TBAPMAdapterSubTaskManager;
import com.taobao.monitor.adapter.common.TBAPMConstants;
import com.taobao.monitor.adapter.data.network.TBNetworkMonitor;
import com.taobao.monitor.adapter.device.ApmDeviceInfoCallback;
import com.taobao.monitor.adapter.device.ApmEvaluateScore;
import com.taobao.monitor.adapter.logger.LoggerAdapter;
import com.taobao.monitor.adapter.network.TBRestSender;
import com.taobao.monitor.common.ThreadUtils;
import com.taobao.monitor.impl.common.Global;
import com.taobao.monitor.impl.data.AbsWebView;
import com.taobao.monitor.impl.data.GlobalStats;
import com.taobao.monitor.impl.data.IWebView;
import com.taobao.monitor.impl.data.WebViewProxy;
import com.taobao.monitor.impl.logger.DataLoggerUtils;
import com.taobao.monitor.impl.logger.IDataLogger;
import com.taobao.monitor.impl.logger.Logger;
import com.taobao.monitor.impl.processor.pageload.IProcedureManager;
import com.taobao.monitor.impl.processor.pageload.ProcedureManagerSetter;
import com.taobao.monitor.impl.util.TimeUtils;
import com.taobao.monitor.impl.util.TopicUtils;
import com.taobao.monitor.network.INetworkSender;
import com.taobao.monitor.network.NetworkSenderProxy;
import com.taobao.monitor.procedure.Header;
import com.taobao.monitor.procedure.IProcedure;
import com.taobao.monitor.procedure.ProcedureConfig;
import com.taobao.monitor.procedure.ProcedureFactoryProxy;
import com.ut.device.UTDevice;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

abstract class AbsAPMInitiator
implements Serializable {
    private static final String TAG = "AbsAPMInitiator";
    private static final float DEFAULT_SAMPLE = 1.0f;
    private long apmStartTime = TimeUtils.currentTimeMillis();
    private long cpuStartTime = SystemClock.currentThreadTimeMillis();

    AbsAPMInitiator() {
    }

    public void init(Application application, HashMap<String, Object> params) {
        if (!TBAPMConstants.init) {
            Logger.i((String)TAG, (Object[])new Object[]{"init start"});
            this.initAPMFunction(application, params);
            this.initDeviceEvaluation(application);
            TBAPMConstants.init = true;
            TBAPMConstants.open = true;
            Logger.i((String)TAG, (Object[])new Object[]{"init end"});
        }
        Logger.i((String)TAG, (Object[])new Object[]{"apmStartTime:", TimeUtils.currentTimeMillis() - this.apmStartTime});
    }

    private void initDeviceEvaluation(Application application) {
        AliHAHardware.getInstance().setUp(application);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final DeviceHelper deviceHelper = new DeviceHelper();
                AliHAHardware.getInstance().getOutlineInfo();
                deviceHelper.setDeviceLevel(AliHAHardware.getInstance().getOutlineInfo().deviceLevel);
                deviceHelper.setCpuScore(AliHAHardware.getInstance().getCpuInfo().deviceLevel);
                deviceHelper.setMemScore(AliHAHardware.getInstance().getMemoryInfo().deviceLevel);
                final ApmEvaluateScore evaluateScore = new ApmEvaluateScore(new ApmDeviceInfoCallback(){

                    @Override
                    public void deviceScore(int deviceScore) {
                        deviceHelper.setOldDeviceScore(deviceScore);
                        AliHAHardware.getInstance().setDeviceScore(deviceScore);
                    }

                    @Override
                    public void cpuInfo(String cpuName, String cpuBrand) {
                        deviceHelper.setCpuBrand(cpuBrand);
                        deviceHelper.setCpuModel(cpuName);
                    }

                    @Override
                    public void gpuInfo(String gpuName, String gpuBrand) {
                        deviceHelper.setGpuBrand(gpuBrand);
                        deviceHelper.setGpuModel(gpuName);
                    }
                });
                boolean result = evaluateScore.evaluateDeviceScore();
                if (!result) {
                    Apm.OnActivityLifecycleCallbacks callbacks = new Apm.OnActivityLifecycleCallbacks(){
                        private int count = 0;
                        private volatile boolean removed = false;

                        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                        }

                        public void onActivityStarted(Activity activity) {
                        }

                        public void onActivityResumed(Activity activity) {
                            evaluateScore.getGpuInfo(activity);
                            ++this.count;
                        }

                        public void onActivityPaused(Activity activity) {
                        }

                        public void onActivityStopped(Activity activity) {
                        }

                        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                        }

                        public void onActivityDestroyed(Activity activity) {
                            if (this.count > 3 && !this.removed) {
                                this.removed = true;
                                final 2 callbacks = this;
                                Handler handler = new Handler(Looper.getMainLooper());
                                handler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        ApmManager.removeActivityLifecycle((Apm.OnActivityLifecycleCallbacks)callbacks);
                                    }
                                });
                            }
                        }
                    };
                    ApmManager.addActivityLifecycle((Apm.OnActivityLifecycleCallbacks)callbacks, (boolean)true);
                }
            }
        };
        ThreadUtils.start((Runnable)runnable);
    }

    private void initParam(Application application, HashMap<String, Object> params) {
        if (params != null) {
            Object object = params.get("speedFlag");
            Header.launcherMode = object instanceof String ? (String)object : "normal";
        }
        SharedPreferences sharedPreferences = application.getSharedPreferences("apm", 0);
        boolean isApm = sharedPreferences.getBoolean("isApm", true);
        AppPreferencesImpl.instance().putBoolean("isApm", isApm);
    }

    private void initAPMFunction(Application application, HashMap<String, Object> params) {
        Global.instance().setHandler(ProcedureGlobal.instance().handler());
        this.initParam(application, params);
        this.initAPMLauncher(application, params);
        this.initNetwork();
        this.initTbRest(application);
        this.initFulltrace(application);
        this.initDataHub();
        this.initLauncherProcedure();
        this.initWebView();
        this.initDataLogger();
        this.initExpendLauncher(application);
    }

    private void initDataLogger() {
        DataLoggerUtils.setDataLogger((IDataLogger)new LoggerAdapter());
    }

    private void initNetwork() {
        try {
            TBNetworkMonitor.init();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void initTbRest(Application application) {
        NetworkSenderProxy.instance().setSender((INetworkSender)new TBRestSender());
    }

    private void initWebView() {
        WebViewProxy.INSTANCE.setReal((IWebView)new AbsWebView(){
            private String lastUrl;

            public boolean isWebView(View view) {
                return view instanceof WebView;
            }

            public int getProgress(View view) {
                WebView webView = (WebView)view;
                String currentUrl = webView.getUrl();
                if (!TextUtils.equals((CharSequence)this.lastUrl, (CharSequence)currentUrl)) {
                    this.lastUrl = currentUrl;
                    return 0;
                }
                return ((WebView)view).getProgress();
            }
        });
    }

    private void initLauncherProcedure() {
        ProcedureConfig config = new ProcedureConfig.Builder().setIndependent(false).setUpload(true).setParentNeedStats(false).setParent(null).build();
        IProcedure launcherProcedure = ProcedureFactoryProxy.PROXY.createProcedure(TopicUtils.getFullTopic((String)"/startup"), config);
        launcherProcedure.begin();
        ProcedureGlobal.PROCEDURE_MANAGER.setLauncherProcedure(launcherProcedure);
        ProcedureConfig subConfig = new ProcedureConfig.Builder().setIndependent(false).setUpload(false).setParentNeedStats(false).setParent(launcherProcedure).build();
        IProcedure subProcedure = ProcedureFactoryProxy.PROXY.createProcedure("/APMSelf", subConfig);
        subProcedure.begin();
        boolean isMainThread = Looper.getMainLooper().getThread() == Thread.currentThread();
        subProcedure.addProperty("isMainThread", (Object)isMainThread);
        subProcedure.addProperty("threadName", (Object)Thread.currentThread().getName());
        subProcedure.stage("taskStart", this.apmStartTime);
        subProcedure.stage("cpuStartTime", this.cpuStartTime);
        TBAPMAdapterSubTaskManager.transferPendingTasks();
        subProcedure.stage("taskEnd", TimeUtils.currentTimeMillis());
        subProcedure.stage("cpuEndTime", SystemClock.currentThreadTimeMillis());
        subProcedure.end();
    }

    private void initAPMLauncher(Application application, HashMap<String, Object> params) {
        this.initPage();
        ProcedureLauncher.init((Context)application, params);
        APMLauncher.init((Application)application, params);
        ProcedureManagerSetter.instance().setProxy(new IProcedureManager(){

            public void setCurrentActivityProcedure(IProcedure currentActivityProcedure) {
                ProcedureGlobal.PROCEDURE_MANAGER.setCurrentActivityProcedure(currentActivityProcedure);
            }

            public void setCurrentFragmentProcedure(IProcedure currentFragmentProcedure) {
                ProcedureGlobal.PROCEDURE_MANAGER.setCurrentFragmentProcedure(currentFragmentProcedure);
            }

            public void setCurrentLauncherProcedure(IProcedure launcherProcedure) {
                ProcedureGlobal.PROCEDURE_MANAGER.setLauncherProcedure(launcherProcedure);
            }
        });
    }

    protected abstract void initPage();

    protected void initExpendLauncher(Application application) {
    }

    private void initDataHub() {
        DataHub.getInstance().init(new BizSubscriber(){

            public void pub(final String bizID, final HashMap<String, String> hashMap) {
                if ("splash".equals(bizID)) {
                    GlobalStats.hasSplash = true;
                }
                this.async(new Runnable(){

                    @Override
                    public void run() {
                        IProcedure procedure = DataHubProcedureGroupHelper.getCurrentProcedures();
                        if (procedure != null) {
                            procedure.addBiz(bizID, (Map)hashMap);
                        }
                    }
                });
            }

            public void pubAB(final String bizID, final HashMap<String, String> hashMap) {
                this.async(new Runnable(){

                    @Override
                    public void run() {
                        IProcedure procedure = DataHubProcedureGroupHelper.getCurrentProcedures();
                        if (procedure != null) {
                            procedure.addBizAbTest(bizID, (Map)hashMap);
                        }
                    }
                });
            }

            public void onStage(final String bizID, final String stageName, long timeStamp) {
                final long currentTimeMillis = TimeUtils.currentTimeMillis();
                this.async(new Runnable(){

                    @Override
                    public void run() {
                        IProcedure procedure = DataHubProcedureGroupHelper.getCurrentProcedures();
                        if (procedure != null) {
                            HashMap<String, Long> hashMap = new HashMap<String, Long>();
                            hashMap.put(stageName, currentTimeMillis);
                            procedure.addBizStage(bizID, hashMap);
                        }
                    }
                });
            }

            public void setMainBiz(final String bizID, final String bizCode) {
                this.async(new Runnable(){

                    @Override
                    public void run() {
                        IProcedure procedure = DataHubProcedureGroupHelper.getCurrentProcedures();
                        if (procedure != null) {
                            procedure.addProperty("bizID", (Object)bizID);
                            if (!TextUtils.isEmpty((CharSequence)bizCode)) {
                                procedure.addProperty("bizCode", (Object)bizCode);
                            }
                        }
                    }
                });
            }

            public void onBizDataReadyStage() {
                IProcedure procedure = DataHubProcedureGroupHelper.getCurrentProcedures();
                if (procedure != null) {
                    procedure.stage("onBizDataReadyTime", TimeUtils.currentTimeMillis());
                }
            }

            private void async(Runnable runnable) {
                Global.instance().handler().post(runnable);
            }
        });
    }

    private void initFulltrace(final Application application) {
        ThreadUtils.start((Runnable)new Runnable(){

            @Override
            public void run() {
                Header.utdid = UTDevice.getUtdid((Context)application);
            }
        });
    }
}

