/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.adapter;

import com.taobao.monitor.procedure.IProcedure;
import com.taobao.monitor.procedure.ProcedureManagerProxy;
import java.util.ArrayList;
import java.util.Map;

class DataHubProcedureGroupHelper {
    private static final ProcedureGroup groups = new ProcedureGroup();

    DataHubProcedureGroupHelper() {
    }

    public static IProcedure getCurrentProcedures() {
        DataHubProcedureGroupHelper.groups.clear();
        DataHubProcedureGroupHelper.groups.addSubProcedure(ProcedureManagerProxy.PROXY.getLauncherProcedure());
        DataHubProcedureGroupHelper.groups.addSubProcedure(ProcedureManagerProxy.PROXY.getCurrentActivityProcedure());
        DataHubProcedureGroupHelper.groups.addSubProcedure(ProcedureManagerProxy.PROXY.getCurrentFragmentProcedure());
        return groups;
    }

    public static class ProcedureGroup
    implements IProcedure {
        final ArrayList<IProcedure> procedures = new ArrayList();

        public String topic() {
            throw new UnsupportedOperationException();
        }

        public String topicSession() {
            throw new UnsupportedOperationException();
        }

        public IProcedure begin() {
            throw new UnsupportedOperationException();
        }

        public IProcedure event(String name, Map<String, Object> properties) {
            for (IProcedure sub : this.procedures) {
                sub.event(name, properties);
            }
            return this;
        }

        public IProcedure stage(String name, long timestamp) {
            for (IProcedure sub : this.procedures) {
                sub.stage(name, timestamp);
            }
            return this;
        }

        public IProcedure addBiz(String bizID, Map<String, Object> properties) {
            for (IProcedure sub : this.procedures) {
                sub.addBiz(bizID, properties);
            }
            return this;
        }

        public IProcedure addBizAbTest(String bizID, Map<String, Object> abTest) {
            for (IProcedure sub : this.procedures) {
                sub.addBizAbTest(bizID, abTest);
            }
            return this;
        }

        public IProcedure addBizStage(String bizID, Map<String, Object> stage) {
            for (IProcedure sub : this.procedures) {
                sub.addBizStage(bizID, stage);
            }
            return this;
        }

        public IProcedure addProperty(String key, Object value) {
            for (IProcedure sub : this.procedures) {
                sub.addProperty(key, value);
            }
            return this;
        }

        public IProcedure addStatistic(String key, Object value) {
            for (IProcedure sub : this.procedures) {
                sub.addStatistic(key, value);
            }
            return this;
        }

        public boolean isAlive() {
            throw new UnsupportedOperationException();
        }

        public IProcedure end() {
            throw new UnsupportedOperationException();
        }

        public IProcedure end(boolean force) {
            throw new UnsupportedOperationException();
        }

        public IProcedure parent() {
            throw new UnsupportedOperationException();
        }

        private void addSubProcedure(IProcedure subProcedure) {
            if (subProcedure != null) {
                this.procedures.add(subProcedure);
            }
        }

        private void clear() {
            this.procedures.clear();
        }
    }
}

