/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.adapter;

import android.app.Application;
import android.content.Context;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.View;
import android.webkit.WebView;
import com.ali.alihadeviceevaluator.AliHAHardware;
import com.ali.ha.datahub.BizSubscriber;
import com.ali.ha.datahub.DataHub;
import com.taobao.monitor.APMLauncher;
import com.taobao.monitor.ProcedureGlobal;
import com.taobao.monitor.ProcedureLauncher;
import com.taobao.monitor.adapter.DataHubProcedureGroupHelper;
import com.taobao.monitor.adapter.TBAPMAdapterSubTaskManager;
import com.taobao.monitor.adapter.common.TBAPMConstants;
import com.taobao.monitor.adapter.network.TBRestSender;
import com.taobao.monitor.common.ThreadUtils;
import com.taobao.monitor.impl.common.Global;
import com.taobao.monitor.impl.data.AbsWebView;
import com.taobao.monitor.impl.data.GlobalStats;
import com.taobao.monitor.impl.data.IWebView;
import com.taobao.monitor.impl.data.WebViewProxy;
import com.taobao.monitor.impl.logger.Logger;
import com.taobao.monitor.impl.processor.pageload.IProcedureManager;
import com.taobao.monitor.impl.processor.pageload.ProcedureManagerSetter;
import com.taobao.monitor.impl.util.TimeUtils;
import com.taobao.monitor.impl.util.TopicUtils;
import com.taobao.monitor.network.INetworkSender;
import com.taobao.monitor.network.NetworkSenderProxy;
import com.taobao.monitor.procedure.Header;
import com.taobao.monitor.procedure.IProcedure;
import com.taobao.monitor.procedure.ProcedureConfig;
import com.taobao.monitor.procedure.ProcedureFactoryProxy;
import com.ut.device.UTDevice;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SimpleApmInitiator
implements Serializable {
    private static final String TAG = "TBAPMAdapterLaunchers";
    private long apmStartTime = TimeUtils.currentTimeMillis();
    private long cpuStartTime = SystemClock.currentThreadTimeMillis();

    public void init(Application application, HashMap<String, Object> params) {
        if (!TBAPMConstants.init) {
            Logger.i((String)TAG, (Object[])new Object[]{"init start"});
            TBAPMConstants.open = true;
            this.initAPMFunction(application, params);
            this.initDeviceEvaluation(application);
            Logger.i((String)TAG, (Object[])new Object[]{"init end"});
            TBAPMConstants.init = true;
        }
        Logger.i((String)TAG, (Object[])new Object[]{"apmStartTime:", TimeUtils.currentTimeMillis() - this.apmStartTime});
    }

    public static void setDebug(boolean isDebug) {
        Logger.setDebug((boolean)isDebug);
    }

    private void initDeviceEvaluation(Application application) {
        AliHAHardware.getInstance().setUp(application);
        ThreadUtils.start((Runnable)new Runnable(){

            @Override
            public void run() {
                AliHAHardware.getInstance().getOutlineInfo();
            }
        });
    }

    private void initAPMFunction(Application application, HashMap<String, Object> params) {
        Global.instance().setHandler(ProcedureGlobal.instance().handler());
        this.initAPMLauncher(application, params);
        this.initTbRest(application);
        this.initFulltrace(application);
        this.initDataHub();
        this.initLauncherProcedure();
        this.initWebView();
    }

    private void initTbRest(Application application) {
        NetworkSenderProxy.instance().setSender((INetworkSender)new TBRestSender());
    }

    private void initDataHub() {
        DataHub.getInstance().init(new BizSubscriber(){

            public void pub(final String bizID, final HashMap<String, String> hashMap) {
                if ("splash".equals(bizID)) {
                    GlobalStats.hasSplash = true;
                }
                this.async(new Runnable(){

                    @Override
                    public void run() {
                        IProcedure procedure = DataHubProcedureGroupHelper.getCurrentProcedures();
                        if (procedure != null) {
                            procedure.addBiz(bizID, (Map)hashMap);
                        }
                    }
                });
            }

            public void pubAB(final String bizID, final HashMap<String, String> hashMap) {
                this.async(new Runnable(){

                    @Override
                    public void run() {
                        IProcedure procedure = DataHubProcedureGroupHelper.getCurrentProcedures();
                        if (procedure != null) {
                            procedure.addBizAbTest(bizID, (Map)hashMap);
                        }
                    }
                });
            }

            public void onStage(final String bizID, final String stageName, long timeStamp) {
                final long currentTimeMillis = TimeUtils.currentTimeMillis();
                this.async(new Runnable(){

                    @Override
                    public void run() {
                        IProcedure procedure = DataHubProcedureGroupHelper.getCurrentProcedures();
                        if (procedure != null) {
                            HashMap<String, Long> hashMap = new HashMap<String, Long>();
                            hashMap.put(stageName, currentTimeMillis);
                            procedure.addBizStage(bizID, hashMap);
                        }
                    }
                });
            }

            public void setMainBiz(final String bizID, final String bizCode) {
                this.async(new Runnable(){

                    @Override
                    public void run() {
                        IProcedure procedure = DataHubProcedureGroupHelper.getCurrentProcedures();
                        if (procedure != null) {
                            procedure.addProperty("bizID", (Object)bizID);
                            if (!TextUtils.isEmpty((CharSequence)bizCode)) {
                                procedure.addProperty("bizCode", (Object)bizCode);
                            }
                        }
                    }
                });
            }

            public void onBizDataReadyStage() {
                IProcedure procedure = DataHubProcedureGroupHelper.getCurrentProcedures();
                if (procedure != null) {
                    procedure.stage("onBizDataReadyTime", TimeUtils.currentTimeMillis());
                }
            }

            private void async(Runnable runnable) {
                Global.instance().handler().post(runnable);
            }
        });
    }

    private void initWebView() {
        WebViewProxy.INSTANCE.setReal((IWebView)new AbsWebView(){
            private String lastUrl;

            public boolean isWebView(View view) {
                return view instanceof WebView;
            }

            public int getProgress(View view) {
                WebView webView = (WebView)view;
                String currentUrl = webView.getUrl();
                if (!TextUtils.equals((CharSequence)this.lastUrl, (CharSequence)currentUrl)) {
                    this.lastUrl = currentUrl;
                    return 0;
                }
                return ((WebView)view).getProgress();
            }
        });
    }

    private void initLauncherProcedure() {
        ProcedureConfig config = new ProcedureConfig.Builder().setIndependent(false).setUpload(true).setParentNeedStats(false).setParent(null).build();
        IProcedure launcherProcedure = ProcedureFactoryProxy.PROXY.createProcedure(TopicUtils.getFullTopic((String)"/startup"), config);
        launcherProcedure.begin();
        ProcedureGlobal.PROCEDURE_MANAGER.setLauncherProcedure(launcherProcedure);
        ProcedureConfig subConfig = new ProcedureConfig.Builder().setIndependent(false).setUpload(false).setParentNeedStats(false).setParent(launcherProcedure).build();
        IProcedure subProcedure = ProcedureFactoryProxy.PROXY.createProcedure("/APMSelf", subConfig);
        subProcedure.begin();
        boolean isMainThread = Looper.getMainLooper().getThread() == Thread.currentThread();
        subProcedure.addProperty("isMainThread", (Object)isMainThread);
        subProcedure.addProperty("threadName", (Object)Thread.currentThread().getName());
        subProcedure.stage("taskStart", this.apmStartTime);
        subProcedure.stage("cpuStartTime", this.cpuStartTime);
        TBAPMAdapterSubTaskManager.transferPendingTasks();
        subProcedure.stage("taskEnd", TimeUtils.currentTimeMillis());
        subProcedure.stage("cpuEndTime", SystemClock.currentThreadTimeMillis());
        subProcedure.end();
    }

    private void initAPMLauncher(Application application, HashMap<String, Object> params) {
        ProcedureLauncher.init((Context)application, params);
        APMLauncher.init((Application)application, params);
        ProcedureManagerSetter.instance().setProxy(new IProcedureManager(){

            public void setCurrentActivityProcedure(IProcedure currentActivityProcedure) {
                ProcedureGlobal.PROCEDURE_MANAGER.setCurrentActivityProcedure(currentActivityProcedure);
            }

            public void setCurrentFragmentProcedure(IProcedure currentFragmentProcedure) {
                ProcedureGlobal.PROCEDURE_MANAGER.setCurrentFragmentProcedure(currentFragmentProcedure);
            }

            public void setCurrentLauncherProcedure(IProcedure launcherProcedure) {
                ProcedureGlobal.PROCEDURE_MANAGER.setLauncherProcedure(launcherProcedure);
            }
        });
    }

    private void initFulltrace(final Application application) {
        ThreadUtils.start((Runnable)new Runnable(){

            @Override
            public void run() {
                Header.utdid = UTDevice.getUtdid((Context)application);
            }
        });
    }
}

