/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.adapter;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.ali.alihadeviceevaluator.AliHAHardware;
import com.taobao.monitor.adapter.common.TBAPMConstants;
import com.taobao.monitor.common.ThreadUtils;
import com.taobao.monitor.impl.common.DynamicConstants;
import com.taobao.monitor.impl.common.Global;
import com.taobao.monitor.impl.logger.Logger;
import com.taobao.monitor.impl.util.TimeUtils;
import com.taobao.orange.OConfigListener;
import com.taobao.orange.OrangeConfig;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class TBAPMAdapterLauncherPart2
implements Serializable {
    private static final String TAG = "TBAPMAdapterLauncherPart2";
    private static final String ORANGE_NAMESPACE = "applicationmonitor";
    private static final String GLOBAL_SAMPLE = "global_sample";
    private static final String OKEY_DE_SWITCHER = "DE_switcher";
    private static final String OKEY_DE_CPUTRACKTICK = "DE_cpuTrackTick";
    private static final String NETWORK_SAMPLE = "network_sample";
    private static final String LAUNCHER_PROCESSOR_SAMPLE = "launcher_sample";
    private static final String PAGE_LOAD_SAMPLE = "page_load_sample";
    private static final String PAGE_LOAD_POP_SAMPLE = "page_load_pop_sample";
    private static final String FRAGMENT_PAGE_LOAD_SAMPLE = "fragment_page_load_sample";
    private static final String FRAGMENT_PAGE_LOAD_POP_SAMPLE = "fragment_page_load_pop_sample";
    private static final String IMAGE_PROCESSOR_SAMPLE = "image_processor_sample";
    private static final String NETWORK_PROCESSOR_SAMPLE = "network_processor_sample";
    private static final String WEEX_PROCESSOR_SAMPLE = "weex_processor_sample";
    private static final String IS_APM = "isApm";
    private static final float DEFAULT_SAMPLE = 1.0f;
    private static boolean init = false;
    private long apmStartTime = TimeUtils.currentTimeMillis();

    public void init(Application application, HashMap<String, Object> params) {
        if (!init) {
            init = true;
            Logger.i((String)TAG, (Object[])new Object[]{"init start"});
            if (TBAPMConstants.open) {
                this.initAPMFunction(application, params);
            }
            this.configOrange();
            Logger.i((String)TAG, (Object[])new Object[]{"init end"});
        }
        Logger.i((String)TAG, (Object[])new Object[]{"apmStartTime:" + (TimeUtils.currentTimeMillis() - this.apmStartTime)});
    }

    private void initAPMFunction(Application application, HashMap<String, Object> params) {
        this.initLogin((Context)application);
    }

    private void configOrange() {
        ThreadUtils.start((Runnable)new Runnable(){

            @Override
            public void run() {
                OrangeConfig.getInstance().getConfigs(TBAPMAdapterLauncherPart2.ORANGE_NAMESPACE);
                OrangeConfig.getInstance().registerListener(new String[]{TBAPMAdapterLauncherPart2.ORANGE_NAMESPACE}, (OConfigListener)new OrangeListener(), true);
            }
        });
    }

    private void initLogin(Context context) {
    }

    private static class OrangeListener
    implements OConfigListener {
        private OrangeListener() {
        }

        public void onConfigUpdate(String s, Map<String, String> map) {
            Map map2 = OrangeConfig.getInstance().getConfigs(TBAPMAdapterLauncherPart2.ORANGE_NAMESPACE);
            if (map2 != null && map2.size() > 0) {
                this.onUpdate(map2);
            }
        }

        private void onUpdate(Map<String, String> map) {
            boolean isApmOld;
            boolean deSwitchOld;
            Random random = new Random(System.currentTimeMillis());
            float computeRandomSample = random.nextFloat();
            boolean globalSwitcher = true;
            String globalSampleString = map.get(TBAPMAdapterLauncherPart2.GLOBAL_SAMPLE);
            float newGlobalSample = this.getSafeFloat(globalSampleString);
            globalSwitcher = computeRandomSample < newGlobalSample;
            String networkSampleString = map.get(TBAPMAdapterLauncherPart2.NETWORK_SAMPLE);
            float newNetworkSample = this.getSafeFloat(networkSampleString);
            TBAPMConstants.needUpdateData = computeRandomSample < newNetworkSample && globalSwitcher;
            String launcherSample = map.get(TBAPMAdapterLauncherPart2.LAUNCHER_PROCESSOR_SAMPLE);
            float newLauncherSample = this.getSafeFloat(launcherSample);
            DynamicConstants.needLauncher = computeRandomSample < newLauncherSample && globalSwitcher;
            String pageLoadSample = map.get(TBAPMAdapterLauncherPart2.PAGE_LOAD_SAMPLE);
            float newPageLoadSample = this.getSafeFloat(pageLoadSample);
            DynamicConstants.needPageLoad = computeRandomSample < newPageLoadSample && globalSwitcher;
            String pageLoadPopSample = map.get(TBAPMAdapterLauncherPart2.PAGE_LOAD_POP_SAMPLE);
            float newPageLoadPopSample = this.getSafeFloat(pageLoadPopSample);
            DynamicConstants.needPageLoadPop = computeRandomSample < newPageLoadPopSample && globalSwitcher;
            String fragmentLoadSample = map.get(TBAPMAdapterLauncherPart2.FRAGMENT_PAGE_LOAD_SAMPLE);
            float newFragmentLoadSample = this.getSafeFloat(fragmentLoadSample);
            DynamicConstants.needFragment = computeRandomSample < newFragmentLoadSample && globalSwitcher;
            String fragmentPopSample = map.get(TBAPMAdapterLauncherPart2.FRAGMENT_PAGE_LOAD_POP_SAMPLE);
            float newFragmentPopSample = this.getSafeFloat(fragmentPopSample);
            DynamicConstants.needFragmentPop = computeRandomSample < newFragmentPopSample && globalSwitcher;
            String networkProcessorSample = map.get(TBAPMAdapterLauncherPart2.NETWORK_PROCESSOR_SAMPLE);
            float newNetworkProcessorSample = this.getSafeFloat(networkProcessorSample);
            DynamicConstants.needNetwork = computeRandomSample < newNetworkProcessorSample && globalSwitcher;
            String imageProcessorSample = map.get(TBAPMAdapterLauncherPart2.IMAGE_PROCESSOR_SAMPLE);
            float newImageProcessorSample = this.getSafeFloat(imageProcessorSample);
            DynamicConstants.needImage = computeRandomSample < newImageProcessorSample && globalSwitcher;
            String weexProcessorSample = map.get(TBAPMAdapterLauncherPart2.WEEX_PROCESSOR_SAMPLE);
            float newWeexProcessorSample = this.getSafeFloat(weexProcessorSample);
            DynamicConstants.needWeex = computeRandomSample < newWeexProcessorSample && globalSwitcher;
            boolean needCommit = false;
            SharedPreferences sharedPreferences = Global.instance().context().getSharedPreferences("apm", 0);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            String deSwitch = map.get(TBAPMAdapterLauncherPart2.OKEY_DE_SWITCHER);
            boolean deSwitchNew = true;
            if (!TextUtils.isEmpty((CharSequence)deSwitch) && deSwitch.equalsIgnoreCase("close")) {
                deSwitchNew = false;
            }
            if (deSwitchNew != (deSwitchOld = sharedPreferences.getBoolean(TBAPMAdapterLauncherPart2.OKEY_DE_SWITCHER, true))) {
                editor.putBoolean(TBAPMAdapterLauncherPart2.OKEY_DE_SWITCHER, deSwitchNew);
                needCommit = true;
            }
            String isApmString = map.get(TBAPMAdapterLauncherPart2.IS_APM);
            boolean isApmNew = true;
            if (!TextUtils.isEmpty((CharSequence)isApmString) && isApmString.equalsIgnoreCase("close")) {
                isApmNew = false;
            }
            if (isApmNew != (isApmOld = sharedPreferences.getBoolean(TBAPMAdapterLauncherPart2.IS_APM, true))) {
                editor.putBoolean(TBAPMAdapterLauncherPart2.IS_APM, isApmNew);
                needCommit = true;
            }
            if (needCommit) {
                editor.commit();
            }
            String deCPUTrackTick = map.get(TBAPMAdapterLauncherPart2.OKEY_DE_CPUTRACKTICK);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("cpuTrackTick", deCPUTrackTick);
            AliHAHardware.getInstance().effectConfig(params);
        }

        private float getSafeFloat(String floatString) {
            try {
                return Float.valueOf(floatString).floatValue();
            }
            catch (Exception exception) {
                return 1.0f;
            }
        }
    }
}

