/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.adapter;

import android.os.Looper;
import android.os.SystemClock;
import com.taobao.monitor.ProcedureGlobal;
import com.taobao.monitor.impl.util.TimeUtils;
import com.taobao.monitor.procedure.IProcedure;
import com.taobao.monitor.procedure.ProcedureConfig;
import com.taobao.monitor.procedure.ProcedureFactoryProxy;
import com.taobao.monitor.procedure.ProcedureManagerProxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TBAPMAdapterSubTaskManager {
    private static Map<String, SubTask> mPendingTasks = new HashMap<String, SubTask>();
    private static Map<String, IProcedure> sProcedureHashMap = new HashMap<String, IProcedure>();
    private static boolean isPendingState = true;

    public static void onStartTask(final String name) {
        final long timeStamp = TimeUtils.currentTimeMillis();
        final long cpuStartTime = SystemClock.currentThreadTimeMillis();
        final String threadName = Thread.currentThread().getName();
        final boolean isMainThread = Thread.currentThread() == Looper.getMainLooper().getThread();
        TBAPMAdapterSubTaskManager.async(new Runnable(){

            @Override
            public void run() {
                if (!isPendingState) {
                    IProcedure iProcedure = ProcedureManagerProxy.PROXY.getLauncherProcedure();
                    ProcedureConfig config = new ProcedureConfig.Builder().setIndependent(false).setUpload(false).setParentNeedStats(false).setParent(iProcedure).build();
                    IProcedure subProcedure = ProcedureFactoryProxy.PROXY.createProcedure("/" + name, config);
                    sProcedureHashMap.put(name, subProcedure);
                    subProcedure.begin();
                    subProcedure.stage("taskStart", timeStamp);
                    subProcedure.stage("cpuStartTime", cpuStartTime);
                    subProcedure.addProperty("threadName", (Object)threadName);
                    subProcedure.addProperty("isMainThread", (Object)isMainThread);
                } else {
                    if (mPendingTasks.keySet().contains(name)) {
                        return;
                    }
                    SubTask subTask = new SubTask();
                    subTask.startTime = timeStamp;
                    subTask.cpuStartTime = cpuStartTime;
                    subTask.isMainThread = isMainThread;
                    subTask.threadName = threadName;
                    mPendingTasks.put(name, subTask);
                }
            }
        });
    }

    public static void onEndTask(final String name) {
        final long timeStamp = TimeUtils.currentTimeMillis();
        final long cpuEndTime = SystemClock.currentThreadTimeMillis();
        TBAPMAdapterSubTaskManager.async(new Runnable(){

            @Override
            public void run() {
                if (!isPendingState) {
                    IProcedure subProcedure = (IProcedure)sProcedureHashMap.get(name);
                    SubTask value = (SubTask)mPendingTasks.get(name);
                    if (subProcedure == null && value != null) {
                        IProcedure launcherProcedure = ProcedureManagerProxy.PROXY.getLauncherProcedure();
                        ProcedureConfig config = new ProcedureConfig.Builder().setIndependent(false).setUpload(false).setParentNeedStats(false).setParent(launcherProcedure).build();
                        subProcedure = ProcedureFactoryProxy.PROXY.createProcedure("/" + name, config);
                        subProcedure.begin();
                        subProcedure.stage("taskStart", value.startTime);
                        subProcedure.stage("cpuStartTime", value.cpuStartTime);
                        subProcedure.addProperty("isMainThread", (Object)value.isMainThread);
                        subProcedure.addProperty("threadName", (Object)value.threadName);
                        mPendingTasks.remove(name);
                    }
                    if (subProcedure != null) {
                        subProcedure.stage("taskEnd", timeStamp);
                        subProcedure.stage("cpuEndTime", cpuEndTime);
                        subProcedure.end();
                        sProcedureHashMap.remove(name);
                    }
                } else {
                    if (!mPendingTasks.keySet().contains(name)) {
                        return;
                    }
                    SubTask subTask = (SubTask)mPendingTasks.get(name);
                    subTask.endTime = timeStamp;
                    subTask.cpuEndTime = cpuEndTime;
                }
            }
        });
    }

    protected static void transferPendingTasks() {
        TBAPMAdapterSubTaskManager.async(new Runnable(){

            @Override
            public void run() {
                Iterator entries = mPendingTasks.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry entry = entries.next();
                    String key = (String)entry.getKey();
                    SubTask value = (SubTask)entry.getValue();
                    if (value.endTime == 0L) continue;
                    IProcedure launcherProcedure = ProcedureManagerProxy.PROXY.getLauncherProcedure();
                    ProcedureConfig config = new ProcedureConfig.Builder().setIndependent(false).setUpload(false).setParentNeedStats(false).setParent(launcherProcedure).build();
                    IProcedure subProcedure = ProcedureFactoryProxy.PROXY.createProcedure("/" + key, config);
                    subProcedure.begin();
                    subProcedure.stage("taskStart", value.startTime);
                    subProcedure.stage("cpuStartTime", value.cpuStartTime);
                    subProcedure.addProperty("isMainThread", (Object)value.isMainThread);
                    subProcedure.addProperty("threadName", (Object)value.threadName);
                    subProcedure.stage("taskEnd", value.endTime);
                    subProcedure.stage("cpuEndTime", value.cpuEndTime);
                    subProcedure.end();
                    entries.remove();
                }
                isPendingState = false;
            }
        });
    }

    private static void async(Runnable runnable) {
        ProcedureGlobal.instance().handler().post(runnable);
    }

    private static class SubTask {
        private long startTime;
        private long endTime;
        private long cpuStartTime;
        private long cpuEndTime;
        private boolean isMainThread;
        private String threadName;

        private SubTask() {
        }
    }
}

