/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.adapter.data.network;

import android.text.TextUtils;
import anet.channel.appmonitor.AppMonitor;
import anet.channel.appmonitor.IAppMonitor;
import anet.channel.statist.AlarmObject;
import anet.channel.statist.CountObject;
import anet.channel.statist.RequestStatistic;
import anet.channel.statist.StatObject;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taobao.monitor.adapter.logger.LoggerAdapter;
import com.taobao.monitor.impl.logger.IDataLogger;
import com.taobao.network.lifecycle.NetworkLifecycleManager;
import java.util.HashMap;

public class TBNetworkMonitor {
    private static IDataLogger dataLogger = new LoggerAdapter();

    public static void init() {
        AppMonitor.setApmMonitor((IAppMonitor)new IAppMonitor(){

            public void register() {
            }

            public void register(Class<?> aClass) {
            }

            public void commitStat(StatObject statObject) {
                if (statObject instanceof RequestStatistic) {
                    TBNetworkMonitor.transformPojo2Events((RequestStatistic)statObject);
                }
            }

            public void commitAlarm(AlarmObject alarmObject) {
            }

            public void commitCount(CountObject countObject) {
            }
        });
    }

    public static void transformPojo2Events(RequestStatistic requestStatistic) {
        if (null == requestStatistic) {
            return;
        }
        try {
            String jsonString = JSON.toJSONString((Object)requestStatistic);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("procedureName", (Object)"NetworkLib");
            jsonObject.put("stage", (Object)"procedureSuccess");
            jsonObject.put("content", (Object)jsonString);
            dataLogger.log("network", new Object[]{jsonObject.toJSONString()});
        }
        catch (Exception jsonString) {
            // empty catch block
        }
        String url = requestStatistic.url;
        String requestID = "" + (url + System.currentTimeMillis()).hashCode();
        if (TextUtils.isEmpty((CharSequence)requestID)) {
            return;
        }
        HashMap<String, Long> requestParams = new HashMap<String, Long>();
        requestParams.put("timestamp", requestStatistic.start - requestStatistic.retryCostTime);
        NetworkLifecycleManager.instance().onRequest(requestID, url, requestParams);
        HashMap<String, Long> lastRequestParams = new HashMap<String, Long>();
        lastRequestParams.put("timestamp", requestStatistic.start);
        NetworkLifecycleManager.instance().onValidRequest(requestID, url, lastRequestParams);
        HashMap<String, Long> dataRequestParams = new HashMap<String, Long>();
        dataRequestParams.put("timestamp", requestStatistic.reqStart);
        NetworkLifecycleManager.instance().onEvent(requestID, "data_request", dataRequestParams);
        HashMap<String, Long> firstDataResponseParams = new HashMap<String, Long>();
        firstDataResponseParams.put("timestamp", requestStatistic.rspStart);
        NetworkLifecycleManager.instance().onEvent(requestID, "first_package_response", firstDataResponseParams);
        HashMap<String, Number> finishParams = new HashMap<String, Number>();
        finishParams.put("timestamp", requestStatistic.rspEnd);
        finishParams.put("statusCode", requestStatistic.statusCode);
        finishParams.put("tnetErrorCode", requestStatistic.tnetErrorCode);
        NetworkLifecycleManager.instance().onFinished(requestID, finishParams);
    }
}

