/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.adapter.device;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.taobao.monitor.adapter.device.ApmDeviceInfoCallback;
import com.taobao.monitor.adapter.device.ApmHardWareInfo;
import com.taobao.monitor.adapter.device.ApmHardwareBrand;
import com.taobao.monitor.adapter.device.ApmHardwareCpu;
import com.taobao.monitor.adapter.device.ApmHardwareCpuCount;
import com.taobao.monitor.adapter.device.ApmHardwareGpu;
import com.taobao.monitor.adapter.device.ApmHardwareJavaMemory;
import com.taobao.monitor.adapter.device.ApmHardwareOpenGL;
import com.taobao.monitor.adapter.device.ApmHardwareOsVersion;
import com.taobao.monitor.adapter.device.ApmHardwareScreen;
import com.taobao.monitor.adapter.device.ApmHardwareStorage;
import com.taobao.monitor.adapter.device.ApmHardwareTotalMemory;
import com.taobao.monitor.adapter.device.ApmHardwareUseTime;
import com.taobao.monitor.impl.common.Global;

public class ApmEvaluateScore
implements ApmDeviceInfoCallback {
    private static final String DEVICE_SCORE = "DEVICE_SCORE";
    private static final String CPU_NAME = "CPU_NAME";
    private static final String CPU_BRAND = "CPU_BRAND";
    private static final String GPU_NAME = "GPU_NAME";
    private static final String GPU_BRAND = "GPU_BRAND";
    private ApmHardWareInfo info;
    private final ApmDeviceInfoCallback callback;

    public ApmEvaluateScore(ApmDeviceInfoCallback callback) {
        this.callback = callback;
    }

    public boolean evaluateDeviceScore() {
        Context context = Global.instance().context();
        SharedPreferences sharedPreferences = context.getSharedPreferences("apm", 0);
        String gpuName = sharedPreferences.getString(GPU_NAME, "");
        String gpuBrand = sharedPreferences.getString(GPU_BRAND, "");
        if (!TextUtils.isEmpty((CharSequence)gpuBrand) && !TextUtils.isEmpty((CharSequence)gpuName)) {
            this.callback.gpuInfo(gpuName, gpuBrand);
            String cpuName = sharedPreferences.getString(CPU_NAME, "");
            String cpuBrand = sharedPreferences.getString(CPU_BRAND, "");
            if (!TextUtils.isEmpty((CharSequence)cpuName) && !TextUtils.isEmpty((CharSequence)cpuBrand)) {
                this.callback.cpuInfo(cpuName, cpuBrand);
                int deviceScore = sharedPreferences.getInt(DEVICE_SCORE, -1);
                if (deviceScore != -1) {
                    this.callback.deviceScore(deviceScore);
                    return true;
                }
            }
        }
        int calDeviceScore = this.calDeviceScore();
        this.callback.deviceScore(calDeviceScore);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(DEVICE_SCORE, calDeviceScore);
        editor.apply();
        return false;
    }

    private int calDeviceScore() {
        this.info = new ApmHardWareInfo(this);
        ApmHardwareBrand hardwareBrand = new ApmHardwareBrand();
        int brandScore = hardwareBrand.getScore();
        ApmHardwareCpuCount hardwareCpuCount = new ApmHardwareCpuCount();
        int cpuCountScore = hardwareCpuCount.getScore();
        ApmHardwareCpu hardwareCpu = new ApmHardwareCpu(this.info);
        int cpuModelScore = hardwareCpu.getScore();
        ApmHardwareOsVersion hardwareOsVersion = new ApmHardwareOsVersion();
        int apiScore = hardwareOsVersion.getScore();
        ApmHardwareTotalMemory hardwareTotalMemory = new ApmHardwareTotalMemory();
        int memScore = hardwareTotalMemory.getScore();
        ApmHardwareJavaMemory hardwareJavaMemory = new ApmHardwareJavaMemory();
        int memLimitScore = hardwareJavaMemory.getScore();
        ApmHardwareScreen hardwareScreen = new ApmHardwareScreen();
        int screenScore = hardwareScreen.getScore();
        ApmHardwareStorage hardwareStorage = new ApmHardwareStorage();
        int storeScore = hardwareStorage.getScore();
        ApmHardwareOpenGL hardwareOpenGL = new ApmHardwareOpenGL();
        int openglScore = hardwareOpenGL.getScore();
        ApmHardwareUseTime hardwareUseTime = new ApmHardwareUseTime();
        int useTimeScore = hardwareUseTime.getScore();
        int cpuHzscore = hardwareCpu.getCpuHzScore(this.info);
        ApmHardwareGpu hardwareGpu = new ApmHardwareGpu(this.info);
        int gpuScore = hardwareGpu.getScore();
        if (gpuScore == 0) {
            gpuScore = (int)((float)cpuModelScore * 0.5f + (float)cpuCountScore * 0.5f + (float)cpuHzscore * 0.25f);
        }
        float scoref = (float)(brandScore + gpuScore) + (float)cpuCountScore * 0.5f + (float)cpuModelScore * 2.0f + (float)apiScore + (float)memScore * 1.5f + (float)memLimitScore * 0.5f + (float)screenScore * 0.5f + (float)storeScore * 0.5f + (float)openglScore * 0.5f + (float)useTimeScore;
        int score = (int)(scoref = (float)Math.round(scoref));
        if (score > 100) {
            score = 100;
        }
        return score;
    }

    public void getGpuInfo(Activity activity) {
        if (this.info != null && (TextUtils.isEmpty((CharSequence)this.info.mGpuName) || TextUtils.isEmpty((CharSequence)this.info.mGpuBrand))) {
            this.info.getGpuInfo(activity);
        }
    }

    @Override
    public void deviceScore(int deviceScore) {
        this.callback.deviceScore(deviceScore);
    }

    @Override
    public void cpuInfo(String cpuName, String cpuBrand) {
        this.callback.cpuInfo(cpuName, cpuBrand);
    }

    @Override
    public void gpuInfo(String gpuName, String gpuBrand) {
        this.callback.gpuInfo(gpuName, gpuBrand);
        int calDeviceScore = this.calDeviceScore();
        this.callback.deviceScore(calDeviceScore);
        Context context = Global.instance().context();
        SharedPreferences sharedPreferences = context.getSharedPreferences("apm", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(DEVICE_SCORE, calDeviceScore);
        editor.apply();
    }
}

