/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.adapter.device;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.support.annotation.Keep;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.taobao.monitor.adapter.device.ApmDeviceInfoCallback;
import com.taobao.monitor.impl.common.Global;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Method;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class ApmHardWareInfo {
    private static final String CPU_NAME = "CPU_NAME";
    private static final String CPU_BRAND = "CPU_BRAND";
    private static final String GPU_NAME = "GPU_NAME";
    private static final String GPU_BRAND = "GPU_BRAND";
    float mCpuMaxFreq;
    float mCpuMinFreq;
    long mGpuFreq;
    int mCpuCount = 0;
    float[] mCpuFreqArray;
    String mCpuName;
    String mCpuBrand;
    String mGpuName;
    String mGpuBrand;
    ViewGroup mViewGroup;
    OnlineGLSurfaceView mOnlineGLSurfaceView;
    private final ApmDeviceInfoCallback callback;
    private final SharedPreferences.Editor editor;

    ApmHardWareInfo(ApmDeviceInfoCallback callback) {
        this.callback = callback;
        this.editor = Global.instance().context().getSharedPreferences("apm", 0).edit();
        this.setCpuCore();
        this.setCpuInfo();
        this.setMaxCpuFreq();
    }

    @Keep
    public void getGpuInfo(Activity activity) {
        try {
            this.mViewGroup = (ViewGroup)activity.getWindow().getDecorView();
            if (this.mViewGroup != null) {
                this.mOnlineGLSurfaceView = new OnlineGLSurfaceView((Context)activity);
                this.mOnlineGLSurfaceView.setAlpha(0.0f);
                ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(1, 1);
                this.mViewGroup.addView((View)this.mOnlineGLSurfaceView, layoutParams);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private float setMaxCpuFreq() {
        if (this.mCpuMaxFreq > 0.0f && this.mCpuFreqArray != null) {
            return this.mCpuMaxFreq;
        }
        if (this.mCpuFreqArray == null) {
            this.mCpuFreqArray = new float[this.mCpuCount];
        }
        try {
            for (int i = 0; i < this.mCpuCount; ++i) {
                float freqMax;
                File file = new File("/sys/devices/system/cpu/cpu" + i + "/cpufreq/cpuinfo_max_freq");
                if (!file.exists()) continue;
                FileReader fr = new FileReader(file);
                BufferedReader br = new BufferedReader(fr);
                String text = br.readLine();
                fr.close();
                if (text == null) continue;
                long freq = Long.parseLong(text);
                this.mCpuFreqArray[i] = freqMax = (float)freq / 1000000.0f;
                if (this.mCpuMaxFreq < freqMax) {
                    this.mCpuMaxFreq = freqMax;
                }
                if (this.mCpuMinFreq == 0.0f) {
                    this.mCpuMinFreq = freqMax;
                    continue;
                }
                if (!(this.mCpuMinFreq > freqMax)) continue;
                this.mCpuMinFreq = freqMax;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mCpuMinFreq == 0.0f) {
            this.mCpuMinFreq = this.mCpuMaxFreq;
        }
        return this.mCpuMaxFreq;
    }

    private int setCpuCore() {
        this.mCpuCount = Runtime.getRuntime().availableProcessors();
        return this.mCpuCount;
    }

    void setCpuInfo() {
        String cpuinfo = null;
        String hardware = Build.HARDWARE.toUpperCase();
        if (!TextUtils.isEmpty((CharSequence)hardware) && (TextUtils.isEmpty((CharSequence)this.mCpuName) || TextUtils.isEmpty((CharSequence)this.mCpuBrand))) {
            if (hardware.contains("EXYNOS")) {
                cpuinfo = hardware.replace("samsung", "");
            } else {
                try {
                    Class<?> classBuild = Class.forName("android.os.Build");
                    Method method = classBuild.getDeclaredMethod("getString", String.class);
                    method.setAccessible(true);
                    cpuinfo = (String)method.invoke(Build.class, "ro.board.platform");
                    if (cpuinfo != null && cpuinfo.equals("mtk")) {
                        cpuinfo = hardware;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (hardware != null && hardware.length() >= 4 && (TextUtils.isEmpty((CharSequence)cpuinfo) || cpuinfo.equals("unknown") || cpuinfo.contains("samsungexynos") || cpuinfo.contains("mrvl"))) {
                    cpuinfo = hardware;
                }
            }
            if (cpuinfo != null) {
                cpuinfo = cpuinfo.toUpperCase();
            }
            if (cpuinfo == null) {
                return;
            }
            this.mCpuBrand = cpuinfo.contains("EXYNOS") || cpuinfo.contains("SMDK") || cpuinfo.contains("UNIVERSAL") ? "\u4e09\u661f" : (cpuinfo.contains("MSM") || cpuinfo.contains("APQ") || cpuinfo.contains("QSD") || cpuinfo.contains("SDM") ? "\u9ad8\u901a" : (cpuinfo.contains("REDHOOKBAY") || cpuinfo.contains("MOOREFIELD") || cpuinfo.contains("MERRIFIELD") ? "\u82f1\u7279\u5c14" : (cpuinfo.contains("MT") ? "\u8054\u53d1\u79d1" : (cpuinfo.contains("OMAP") ? "\u5fb7\u5dde\u4eea\u5668" : (cpuinfo.contains("PXA") ? "Marvell" : (cpuinfo.contains("HI") || cpuinfo.contains("K3") ? "\u534e\u4e3a\u6d77\u601d" : (cpuinfo.contains("SP") || cpuinfo.contains("SC") ? "\u5c55\u8baf" : (cpuinfo.contains("TEGRA") || cpuinfo.contains("NVIDIA") ? "NVIDIA" : (cpuinfo.startsWith("LC") ? "\u8054\u82af\u79d1\u6280" : hardware)))))))));
            this.mCpuName = cpuinfo;
        }
        this.callback.cpuInfo(this.mCpuName, this.mCpuBrand);
        this.editor.putString(CPU_NAME, this.mCpuName);
        this.editor.putString(CPU_BRAND, this.mCpuBrand);
        this.editor.apply();
    }

    long getGpuFreq() {
        long freq;
        block12: {
            freq = 0L;
            try {
                String textFreq = null;
                File file = new File("/sys/devices/platform/gpusysfs/gpu_max_clock");
                if (!file.exists()) {
                    file = new File("/sys/devices/platform/gpusysfs/max_freq");
                }
                if (file.exists()) {
                    FileReader fr = new FileReader(file);
                    BufferedReader br = new BufferedReader(fr);
                    textFreq = br.readLine();
                    if (textFreq != null && (freq = Long.parseLong(textFreq)) > 0L) {
                        freq = freq / 1000L / 1000L;
                    }
                    fr.close();
                    if (freq > 0L) {
                        return freq;
                    }
                }
                if (!(file = new File("/sys/class/devfreq/")).exists() || !file.isDirectory()) break block12;
                File[] files = file.listFiles();
                if (files == null) {
                    return 0L;
                }
                for (int i = 0; i < files.length; ++i) {
                    File filename = files[i];
                    if (!filename.getName().contains("kgsl")) continue;
                    File fileFreq = new File(files[i].getAbsolutePath() + "/max_freq");
                    if (!fileFreq.exists()) {
                        fileFreq = new File(files[i].getAbsolutePath() + "/max_gpuclk");
                    }
                    if (fileFreq.exists()) {
                        FileReader fr = new FileReader(fileFreq);
                        BufferedReader br = new BufferedReader(fr);
                        textFreq = br.readLine();
                        if (textFreq != null && (freq = Long.parseLong(textFreq)) > 0L) {
                            freq = freq / 1000L / 1000L;
                        }
                        fr.close();
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (freq == 0L) {
            freq = this.getKgslFreq("/sys/devices/");
        }
        return freq;
    }

    long getKgslFreq(String path) {
        long freq = 0L;
        try {
            File fileFreq;
            File file = new File(path);
            if (file.exists() && file.isDirectory()) {
                File[] files = file.listFiles();
                if (files == null) {
                    return 0L;
                }
                for (int i = 0; i < files.length; ++i) {
                    File filename = files[i];
                    if (filename == null || !filename.getName().contains("kgsl") || !filename.isDirectory() || (freq = this.getKgslFreq(filename.getAbsolutePath())) <= 0L) continue;
                    return freq;
                }
            }
            if (!(fileFreq = new File(path + "/max_freq")).exists()) {
                fileFreq = new File(path + "/max_gpuclk");
            }
            if (fileFreq.exists()) {
                FileReader fr = new FileReader(fileFreq);
                BufferedReader br = new BufferedReader(fr);
                String textFreq = br.readLine();
                if (textFreq != null && (freq = Long.parseLong(textFreq)) > 0L) {
                    freq = freq / 1000L / 1000L;
                }
                fr.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return freq;
    }

    class OnlineGLSurfaceView
    extends GLSurfaceView {
        OnlineRenderer mRenderer;

        public OnlineGLSurfaceView(Context context) {
            super(context);
            this.setEGLConfigChooser(8, 8, 8, 8, 0, 0);
            this.mRenderer = new OnlineRenderer();
            this.setRenderer(this.mRenderer);
        }
    }

    class OnlineRenderer
    implements GLSurfaceView.Renderer {
        OnlineRenderer() {
        }

        public void onSurfaceCreated(GL10 gl, EGLConfig config) {
            try {
                ApmHardWareInfo.this.mGpuName = gl.glGetString(7937);
                ApmHardWareInfo.this.mGpuBrand = gl.glGetString(7936);
                ApmHardWareInfo.this.mGpuFreq = ApmHardWareInfo.this.getGpuFreq();
                ApmHardWareInfo.this.callback.gpuInfo(ApmHardWareInfo.this.mGpuName, ApmHardWareInfo.this.mGpuBrand);
                ApmHardWareInfo.this.editor.putString(ApmHardWareInfo.GPU_NAME, ApmHardWareInfo.this.mGpuName);
                ApmHardWareInfo.this.editor.putString(ApmHardWareInfo.GPU_BRAND, ApmHardWareInfo.this.mGpuBrand);
                ApmHardWareInfo.this.editor.apply();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void onDrawFrame(GL10 arg0) {
        }

        public void onSurfaceChanged(GL10 arg0, int arg1, int arg2) {
        }
    }
}

