/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.adapter.device;

import android.os.Build;
import android.util.Log;
import com.taobao.monitor.adapter.device.ApmCalScore;
import com.taobao.monitor.adapter.device.ApmHardWareInfo;

public class ApmHardwareCpu
implements ApmCalScore {
    String mCpuInfo;
    int mCpuProcessCount = 4;
    private String mCpuScore10 = "SDM845,KIRIN970,MSM8998,EXYNOS8895";
    private String mCpuScore9 = "MSM8997,HI3660";
    private String mCpuScore8 = "MSM8996,MSM8996PRO,MSM8996 PRO,EXYNOS8890,MT6799";
    private String mCpuScore7 = "SDM660,SDM630,MSM8994,MSM8992,HI3650,EXYNOS7420,VBOX86";
    private String mCpuScore6 = "MSM8956,MSM8946,MT6797X,MT6797X,MT6797T,MT6797D";
    private String mCpuScore5 = "APQ8084,MSM8084,MSM8953,HI3630,EXYNOS5433,HI3635,EXYNOS5";
    private String mCpuScore4 = "MSM8X74,MSM8X74AA,MSM8X74AB,MSM8X74AC,MSM8674,MSM8274,MSM8074,EXYNOS5430,EXYNOS7870,EXYNOS7580,EXYNOS5433,MT679X,MT6797T,MT6797,EXYNOS5420,UNIVERSAL5420,RANCHU";
    private String mCpuScore3 = "MT675X,MT6795,MT6755,MT6752,MT6753,EXYNOS5800,EXYNOS5422,EXYNOS5410,MSM8952,MSM8940,PXA1936,HI6210SFT";
    private String mCpuScore2 = "EXYNOS5260,EXYNOS5250,MT6750,MT6735,MSM8939V2,MSM8937,MSM8929,APQ8064,MSM8917,EXYNOS52,K3V2+,REDHOOKBAY,PXA1908,SC9860,HI6620OEM";
    private String mCpuScore1 = "MT6595,MT6592,MT6582,MSM8936,MSM8909,MSM8909V2,MSM8916V2,MSM8208,MSM8960T,MSM8260A,MSM8660A,MSM8960,MSM8X12,MSM8X10,MSM8X30,LC1860";
    private String mCpuScore0 = "K3V2E,K3V2,MT6589,EXYNOS4210,EXYNOS4212,MSM8X25Q,MSM8X26,PXA1088,PXA1L88,MSM8260,MSM8660,MSM8625,MSM8225,MSM8655,APQ8055,MSM7230,MSM7630,GOLDFISH,MSM8255T,MSM8655T,MSM7627A,MSM7227A,MSM7627T,MSM7227T,MT6577T,MT6572M,MT6515M,MT6575,QSD8650,QSD8250,OMAP4470,SP8810,SC8810MT6516,MT6573,MT6513,S5PC100,S5L8900,HI3611,HI3620,OMAP4460,OMAP4440,OMAP4430,EXYNOS3475,EXYNOS3110";
    String[] mCpuScoreAry = new String[]{this.mCpuScore0, this.mCpuScore1, this.mCpuScore2, this.mCpuScore3, this.mCpuScore4, this.mCpuScore5, this.mCpuScore6, this.mCpuScore7, this.mCpuScore8, this.mCpuScore9, this.mCpuScore10};
    private final ApmHardWareInfo info;

    ApmHardwareCpu(ApmHardWareInfo info) {
        this.info = info;
    }

    private int findIndex(String cpuBrand) {
        if (this.mCpuInfo == null) {
            return -1;
        }
        for (int i = this.mCpuScoreAry.length - 1; i >= 0; --i) {
            String cpu = this.mCpuScoreAry[i];
            if (cpu == null || !cpu.contains(cpuBrand)) continue;
            Log.e((String)"OnlineMonitor", (String)("cpuModel=" + cpuBrand + ",score=" + i));
            return i;
        }
        return -1;
    }

    @Override
    public int getScore() {
        this.mCpuProcessCount = this.info.mCpuCount;
        this.mCpuInfo = this.info.mCpuName;
        int index = 0;
        if (this.mCpuInfo != null) {
            index = this.findIndex(this.mCpuInfo);
            if (index < 0) {
                char lastChar;
                if (this.mCpuInfo.startsWith("MSM") && this.mCpuInfo.length() > 5) {
                    String tempCpu = this.mCpuInfo.substring(0, 4) + "X" + this.mCpuInfo.substring(5);
                    index = this.findIndex(tempCpu);
                } else if (this.mCpuInfo.startsWith("MT") && (lastChar = this.mCpuInfo.charAt(this.mCpuInfo.length() - 1)) >= '0' && lastChar <= '9') {
                    String tempCpu = this.mCpuInfo.substring(0, this.mCpuInfo.length() - 1) + "X";
                    index = this.findIndex(tempCpu);
                }
            }
            if (index < 0) {
                String hardware = Build.HARDWARE.toUpperCase();
                int brandScore = 5;
                if (hardware.contains("MSM") || hardware.contains("EXYNOS8") || hardware.contains("KIRIN")) {
                    brandScore = this.mCpuProcessCount >= 10 ? 10 : (this.mCpuProcessCount >= 8 ? 9 : (this.mCpuProcessCount >= 4 ? 8 : (this.mCpuProcessCount >= 2 ? 5 : 2)));
                } else if (hardware.contains("SDM") || hardware.contains("EXYNOS7") || hardware.contains("HI")) {
                    brandScore = this.mCpuProcessCount >= 10 ? 9 : (this.mCpuProcessCount >= 8 ? 8 : (this.mCpuProcessCount >= 4 ? 7 : (this.mCpuProcessCount >= 2 ? 4 : 2)));
                } else if (hardware.contains("QCOM") || hardware.contains("QUALCOMM") || hardware.contains("APQ")) {
                    brandScore = this.mCpuProcessCount >= 10 ? 8 : (this.mCpuProcessCount >= 8 ? 7 : (this.mCpuProcessCount >= 4 ? 6 : (this.mCpuProcessCount >= 2 ? 4 : 2)));
                } else if (hardware.contains("MOOREFIELD")) {
                    brandScore = this.mCpuProcessCount >= 10 ? 7 : (this.mCpuProcessCount >= 8 ? 6 : (this.mCpuProcessCount >= 4 ? 5 : (this.mCpuProcessCount >= 2 ? 3 : 2)));
                } else if (hardware.contains("MERRIFIELD") || hardware.contains("CLOVERTRAIL") || hardware.contains("REDHOOKBAY") || hardware.contains("TEGRA") || hardware.contains("NVIDIA") || hardware.contains("K3")) {
                    brandScore = this.mCpuProcessCount >= 10 ? 7 : (this.mCpuProcessCount >= 8 ? 6 : (this.mCpuProcessCount >= 4 ? 5 : (this.mCpuProcessCount >= 2 ? 3 : 2)));
                } else if (hardware.contains("SMDK") || hardware.contains("MT")) {
                    brandScore = this.mCpuProcessCount >= 10 ? 7 : (this.mCpuProcessCount >= 8 ? 6 : (this.mCpuProcessCount >= 4 ? 5 : (this.mCpuProcessCount >= 2 ? 3 : 2)));
                } else if (hardware.contains("PXA")) {
                    brandScore = this.mCpuProcessCount >= 8 ? 5 : (this.mCpuProcessCount >= 4 ? 3 : (this.mCpuProcessCount >= 2 ? 2 : 1));
                } else if (hardware.contains("SP") || hardware.contains("SC") || hardware.contains("OMAP")) {
                    brandScore = this.mCpuProcessCount >= 8 ? 4 : (this.mCpuProcessCount >= 4 ? 2 : (this.mCpuProcessCount >= 2 ? 1 : 0));
                }
                brandScore = 2 * brandScore;
                int hzScore = this.getCpuHzScore(this.info);
                index = (brandScore + hzScore) / 3;
            }
        }
        return index;
    }

    public int getCpuHzScore(ApmHardWareInfo info) {
        if (info == null) {
            return 0;
        }
        int cpuHzScore = 1;
        if (info.mCpuCount >= 8) {
            if (info.mCpuMaxFreq >= 1.9f) {
                cpuHzScore = 10;
            } else if (info.mCpuMaxFreq >= 1.8f) {
                cpuHzScore = 9;
            } else if (info.mCpuMaxFreq >= 1.7f) {
                cpuHzScore = 8;
            } else if (info.mCpuMaxFreq >= 1.5f) {
                cpuHzScore = 7;
            } else if (info.mCpuMaxFreq >= 1.4f) {
                cpuHzScore = 6;
            } else if (info.mCpuMaxFreq >= 1.3f) {
                cpuHzScore = 5;
            } else if (info.mCpuMaxFreq >= 1.2f) {
                cpuHzScore = 4;
            } else if (info.mCpuMaxFreq >= 1.0f) {
                cpuHzScore = 3;
            }
        } else if (info.mCpuMaxFreq >= 2.4f) {
            cpuHzScore = 10;
        } else if (info.mCpuMaxFreq >= 2.2f) {
            cpuHzScore = 9;
        } else if (info.mCpuMaxFreq >= 2.0f) {
            cpuHzScore = 8;
        } else if (info.mCpuMaxFreq >= 1.8f) {
            cpuHzScore = 7;
        } else if (info.mCpuMaxFreq >= 1.5f) {
            cpuHzScore = 6;
        } else if (info.mCpuMaxFreq >= 1.3f) {
            cpuHzScore = 5;
        } else if (info.mCpuMaxFreq >= 1.2f) {
            cpuHzScore = 3;
        } else if (info.mCpuMaxFreq >= 1.0f) {
            cpuHzScore = 2;
        }
        float minFreq = info.mCpuMinFreq;
        int cpuHzScore2 = 1;
        if (info.mCpuCount >= 8) {
            if (minFreq >= 1.6f) {
                cpuHzScore2 = 10;
            } else if (minFreq >= 1.5f) {
                cpuHzScore2 = 9;
            } else if (minFreq >= 1.4f) {
                cpuHzScore2 = 8;
            } else if (minFreq >= 1.3f) {
                cpuHzScore2 = 6;
            } else if (minFreq >= 1.2f) {
                cpuHzScore2 = 5;
            } else if (minFreq >= 1.1f) {
                cpuHzScore2 = 3;
            } else if (minFreq >= 1.0f) {
                cpuHzScore2 = 2;
            }
        } else if (minFreq >= 2.0f) {
            cpuHzScore2 = 10;
        } else if (minFreq >= 1.8f) {
            cpuHzScore2 = 9;
        } else if (minFreq >= 1.6f) {
            cpuHzScore2 = 8;
        } else if (minFreq >= 1.5f) {
            cpuHzScore2 = 7;
        } else if (minFreq >= 1.4f) {
            cpuHzScore2 = 6;
        } else if (minFreq >= 1.3f) {
            cpuHzScore2 = 5;
        } else if (minFreq >= 1.2f) {
            cpuHzScore2 = 4;
        } else if (minFreq >= 1.1f) {
            cpuHzScore2 = 3;
        } else if (minFreq >= 1.0f) {
            cpuHzScore2 = 2;
        }
        cpuHzScore = (cpuHzScore + cpuHzScore2) / 2;
        return cpuHzScore;
    }
}

