/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.adapter.device;

import android.os.Build;
import com.taobao.monitor.adapter.device.ApmCalScore;
import com.taobao.monitor.adapter.device.ApmHardWareInfo;

public class ApmHardwareGpu
implements ApmCalScore {
    private String mGpuName;
    private String mGpuBrand;
    private float mCpuMaxFreq;
    private float mCpuMinFreq;

    ApmHardwareGpu(ApmHardWareInfo info) {
        this.mGpuName = info.mGpuName;
        this.mGpuBrand = info.mGpuBrand;
        this.mCpuMaxFreq = info.mCpuMaxFreq;
        this.mCpuMinFreq = info.mCpuMinFreq;
    }

    @Override
    public int getScore() {
        int score = 0;
        if (this.mGpuName != null) {
            if (this.mGpuName.contains("Adreno")) {
                this.mGpuBrand = "\u9ad8\u901a";
                if (this.mGpuName.contains("540") || this.mGpuName.contains("530") || this.mGpuName.contains("53") || this.mGpuName.startsWith("Adreno (TM) 5") || this.mGpuName.startsWith("Adreno (TM) 6")) {
                    score = this.mCpuMaxFreq > 2.0f ? 10 : (this.mCpuMinFreq > 1.5f ? 10 : 9);
                } else if (this.mGpuName.startsWith("Adreno 5") || this.mGpuName.startsWith("Adreno 6")) {
                    score = 10;
                } else if (this.mGpuName.contains("430")) {
                    score = 8;
                } else if (this.mGpuName.contains("420") || this.mGpuName.contains("418")) {
                    score = 7;
                } else if (this.mGpuName.contains("510") || this.mGpuName.contains("506") || this.mGpuName.contains("505")) {
                    score = 6;
                } else if (this.mGpuName.contains("330")) {
                    score = this.mCpuMaxFreq > 2.3f ? 6 : 5;
                } else if (this.mGpuName.contains("405")) {
                    score = 5;
                } else if (this.mGpuName.contains("320")) {
                    score = 5;
                } else if (this.mGpuName.contains("225")) {
                    score = 4;
                } else if (this.mGpuName.contains("305") || this.mGpuName.contains("306") || this.mGpuName.contains("308")) {
                    score = 4;
                } else if (this.mGpuName.contains("220")) {
                    score = 3;
                } else if (this.mGpuName.contains("205") || this.mGpuName.contains("203")) {
                    score = 2;
                } else if (this.mGpuName.contains("200")) {
                    score = 1;
                } else if (this.mGpuName.startsWith("Adreno 4")) {
                    score = 6;
                } else if (this.mGpuName.startsWith("Adreno 3")) {
                    score = 4;
                }
            } else if (this.mGpuName.contains("Mali")) {
                String hardware = Build.HARDWARE.toLowerCase();
                if (this.mGpuName.contains("G71") || this.mGpuName.contains("G72")) {
                    score = 10;
                } else if (this.mGpuName.contains("T880 MP") || this.mGpuName.contains("T880")) {
                    score = 9;
                } else if (this.mGpuName.contains("T860")) {
                    score = 8;
                } else if (this.mGpuName.contains("T830")) {
                    score = 7;
                } else if (this.mGpuName.contains("T820")) {
                    score = 7;
                } else if (this.mGpuName.contains("400 MP")) {
                    score = 6;
                } else if (this.mGpuName.contains("400")) {
                    score = 2;
                } else if (this.mGpuName.contains("450")) {
                    score = 2;
                } else if (this.mGpuName.contains("T624")) {
                    score = 5;
                } else if (this.mGpuName.contains("T678")) {
                    score = 5;
                } else if (this.mGpuName.contains("T628")) {
                    score = 6;
                } else if (this.mGpuName.contains("T604")) {
                    score = 3;
                } else if (this.mGpuName.contains("T760")) {
                    score = 6;
                } else if (this.mGpuName.contains("T720")) {
                    score = 6;
                }
            } else if (this.mGpuName.contains("PowerVR")) {
                score = this.mGpuName.contains("SGX 530") ? 1 : (this.mGpuName.contains("SGX 535") ? 2 : (this.mGpuName.contains("SGX 531") ? 2 : (this.mGpuName.contains("SGX 544") || this.mGpuName.contains("SGX 543") ? 3 : (this.mGpuName.contains("G6200") || this.mGpuName.contains("6200") ? 5 : (this.mGpuName.contains("G6400") || this.mGpuName.contains("G6430") || this.mGpuName.contains("G6") || this.mGpuName.contains("6") ? 5 : (this.mGpuName.contains("6450") || this.mGpuName.contains("7") ? 6 : 3))))));
            } else if (this.mGpuName.contains("NVIDIA")) {
                score = this.mCpuMaxFreq >= 1.8f ? 8 : (this.mCpuMaxFreq >= 2.2f ? 6 : (this.mCpuMaxFreq >= 2.0f ? 5 : (this.mCpuMaxFreq >= 1.8f ? 4 : 3)));
            } else if (this.mGpuName.contains("Android Emulator")) {
                score = 8;
            }
        }
        return score;
    }
}

