/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.adapter.device;

import android.content.Context;
import android.util.DisplayMetrics;
import com.taobao.monitor.adapter.device.ApmCalScore;
import com.taobao.monitor.impl.common.Global;

public class ApmHardwareScreen
implements ApmCalScore {
    private int mWidth;
    private int mHeight;
    private float mDesty;

    ApmHardwareScreen() {
        Context context = Global.instance().context();
        try {
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            if (displayMetrics != null) {
                this.mDesty = displayMetrics.density;
                this.mWidth = displayMetrics.widthPixels;
                this.mHeight = displayMetrics.heightPixels;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public int getScore() {
        if (this.mWidth == 0 || this.mHeight == 0) {
            return 5;
        }
        float destyScore = 0.0f;
        float areaScore = 0.0f;
        destyScore = this.mDesty <= 1.4f ? 1.0f : (this.mDesty <= 1.5f ? 2.0f : (this.mDesty <= 2.0f ? 4.0f : (this.mDesty <= 2.5f ? 6.0f : (this.mDesty <= 3.0f ? 8.0f : (this.mDesty <= 3.5f ? 9.0f : 10.0f)))));
        int area = this.mWidth * this.mHeight;
        areaScore = area >= 0x870000 ? 10.0f : (area >= 3686400 ? 9.0f : (area > 2073600 ? 8.0f : (area == 2073600 ? 7.0f : (area > 921600 ? 6.0f : (area >= 921600 ? 4.0f : (area >= 786432 ? 3.0f : (area >= 614400 ? 2.0f : 1.0f)))))));
        return Math.round((destyScore + areaScore) / 2.0f);
    }
}

