/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.adapter.device;

import android.os.Environment;
import android.os.StatFs;
import com.taobao.monitor.adapter.device.ApmCalScore;

public class ApmHardwareStorage
implements ApmCalScore {
    private int mInnerSize = 48;
    private int mInnerFree = 48;

    ApmHardwareStorage() {
        try {
            String path = Environment.getDataDirectory().getPath();
            StatFs stat = new StatFs(path);
            long blockSize = stat.getBlockSize();
            long totalBlocks = stat.getBlockCount();
            this.mInnerSize = (int)(blockSize * totalBlocks / 1024L / 1024L / 1024L);
            this.mInnerFree = (int)(blockSize * (long)stat.getAvailableBlocks() / 1024L / 1024L / 1024L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int getScore() {
        int storeScore = 8;
        int storeFreeScore = 8;
        if (this.mInnerSize <= 0) {
            this.mInnerSize = 48;
        }
        if (this.mInnerFree <= 0) {
            this.mInnerFree = 24;
        }
        if (this.mInnerSize >= 220) {
            storeScore = 10;
        } else if (this.mInnerSize >= 100) {
            storeScore = 9;
        } else if (this.mInnerSize >= 80) {
            storeScore = 8;
        } else if (this.mInnerSize >= 48) {
            storeScore = 6;
        } else if (this.mInnerSize >= 24) {
            storeScore = 5;
        } else if (this.mInnerSize >= 10) {
            storeScore = 2;
        } else if (this.mInnerSize >= 5) {
            storeScore = 1;
        }
        int freePer = this.mInnerFree * 100 / this.mInnerSize;
        storeFreeScore = freePer >= 80 ? 10 : (freePer >= 70 ? 9 : (freePer >= 60 ? 8 : (freePer >= 50 ? 7 : (freePer >= 40 ? 6 : (freePer >= 30 ? 5 : (freePer >= 20 ? 4 : (freePer >= 10 ? 3 : (freePer >= 5 ? 2 : (freePer >= 1 ? 1 : 0)))))))));
        int score = (storeScore + storeFreeScore) / 2;
        return score;
    }
}

