/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.adapter.device;

import android.app.ActivityManager;
import android.os.Build;
import com.taobao.monitor.adapter.device.ApmCalScore;
import com.taobao.monitor.impl.common.Global;
import java.io.BufferedReader;
import java.io.FileReader;

public class ApmHardwareTotalMemory
implements ApmCalScore {
    private long mDeviceTotalMemory = 0L;

    ApmHardwareTotalMemory() {
        this.initDeviceTotalMemory();
    }

    private void initDeviceTotalMemory() {
        ActivityManager activityManager = (ActivityManager)Global.instance().context().getSystemService("activity");
        if (activityManager != null) {
            if (Build.VERSION.SDK_INT >= 16) {
                try {
                    ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
                    this.mDeviceTotalMemory = memoryInfo.totalMem / 1024L / 1024L;
                }
                catch (Throwable e) {
                    this.mDeviceTotalMemory = this.getTotalMemFromFile() / 1024;
                }
            } else {
                this.mDeviceTotalMemory = this.getTotalMemFromFile() / 1024;
            }
            if (this.mDeviceTotalMemory < 256L) {
                this.mDeviceTotalMemory = 256L;
            } else if (this.mDeviceTotalMemory < 512L) {
                this.mDeviceTotalMemory = 512L;
            } else {
                for (int i = 1; i <= 20; ++i) {
                    int tempMem = 1024 * i;
                    if (this.mDeviceTotalMemory >= (long)tempMem) continue;
                    this.mDeviceTotalMemory = tempMem;
                    break;
                }
            }
        }
    }

    private int getTotalMemFromFile() {
        int totalMem = 0;
        try {
            FileReader fr = new FileReader("/proc/meminfo");
            BufferedReader br = new BufferedReader(fr);
            String text = br.readLine();
            br.close();
            if (text != null) {
                text = text.replace("MemTotal:", "");
                text = text.replace("kB", "");
                text = text.replace(" ", "");
                totalMem = Integer.parseInt(text);
            }
            totalMem /= 1024;
        }
        catch (Exception e) {
            totalMem = 1024;
        }
        return totalMem;
    }

    @Override
    public int getScore() {
        int memScore = 8;
        if (this.mDeviceTotalMemory >= 6144L) {
            memScore = 10;
        } else if (this.mDeviceTotalMemory >= 4096L) {
            memScore = 9;
        } else if (this.mDeviceTotalMemory >= 3072L) {
            memScore = 7;
        } else if (this.mDeviceTotalMemory >= 2048L) {
            memScore = 5;
        } else if (this.mDeviceTotalMemory >= 1024L) {
            memScore = 3;
        } else if (this.mDeviceTotalMemory >= 512L) {
            memScore = 1;
        }
        return memScore;
    }
}

