/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.adapter.network;

import com.alibaba.motu.tbrest.SendService;
import com.taobao.monitor.adapter.common.TBAPMConstants;
import com.taobao.monitor.adapter.network.ILiteDb;
import com.taobao.monitor.adapter.network.SenderLiteDb;
import com.taobao.monitor.common.ThreadUtils;
import com.taobao.monitor.impl.logger.Logger;
import com.taobao.monitor.network.INetworkSender;
import java.util.List;

public class TBRestSender
implements INetworkSender {
    private static final String TAG = "TBRestSender";
    private static final String SPLIT = "HA_APM_______HA_APM";
    private static final int TRY_COUNT = 2;
    private final Integer eventId = 61004;
    private final String arg1 = "AliHAMonitor";
    private final String host;
    private boolean hasDiskData = true;
    private ILiteDb senderDb = new SenderLiteDb();

    public TBRestSender() {
        this.host = null;
    }

    public void send(final String topic, final String content) {
        if (!TBAPMConstants.needUpdateData) {
            return;
        }
        ThreadUtils.start((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    int i = 0;
                    boolean result = false;
                    Logger.i((String)TBRestSender.TAG, (Object[])new Object[]{content});
                    while (i++ < 2) {
                        result = TBRestSender.this.sendApmContent(topic, content);
                        if (!result) continue;
                        Logger.i((String)TBRestSender.TAG, (Object[])new Object[]{"send success" + i});
                        break;
                    }
                    if (!result) {
                        TBRestSender.this.save2Disk(topic, content);
                        TBRestSender.this.hasDiskData = true;
                    }
                    if (result && TBRestSender.this.hasDiskData) {
                        TBRestSender.this.tryLastFailedSend();
                        TBRestSender.this.hasDiskData = false;
                    }
                }
                catch (Throwable e) {
                    Logger.throwException((Throwable)e);
                }
            }
        });
    }

    private boolean sendApmContent(String topic, String content) {
        return SendService.getInstance().sendRequest(this.host, System.currentTimeMillis(), null, this.eventId.intValue(), (Object)"AliHAMonitor", (Object)content, (Object)topic, null);
    }

    private void tryLastFailedSend() {
        List<String> strings = this.senderDb.select();
        if (strings != null) {
            for (String s : strings) {
                String[] subString;
                if (s == null || (subString = s.split(SPLIT)).length < 2) continue;
                this.sendApmContent(subString[0], subString[1]);
            }
        }
        this.senderDb.delete();
    }

    private void save2Disk(String topic, String content) {
        this.senderDb.insert(topic + SPLIT + content);
    }
}

