/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.feedback.xblink.webview;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Base64;
import android.webkit.CookieManager;
import android.webkit.WebBackForwardList;
import android.webkit.WebHistoryItem;
import android.webkit.WebView;
import com.alibaba.sdk.android.feedback.xblink.c.a;
import com.alibaba.sdk.android.feedback.xblink.c.j;
import com.alibaba.sdk.android.feedback.xblink.i.g;
import com.alibaba.sdk.android.feedback.xblink.i.h;
import com.alibaba.sdk.android.feedback.xblink.webview.XBHybridWebView;
import com.alibaba.sdk.android.feedback.xblink.webview.b;
import com.alibaba.sdk.android.feedback.xblink.webview.c;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class HybridPlusWebView
extends XBHybridWebView
implements Handler.Callback,
j {
    private static final String TAG = "HybridPlusWebView";
    public static final int UNSUPPORTED_MIMETYPE = -400;
    public static final int HTTPS_CERT_INVILD = -601;
    public static final int HTTPS_CERT_EXPIRED = -602;
    private final int HTML_FINSH = 200;
    public static final String HTML_CONTENT = "html_content";
    public static final String CHARSET = "charset";
    public static final String MIMETYPE = "mimetype";
    public static final String WEBVIEW_MIMETYPE = "webview_mimetype";
    public static final String HTTPSVERIFYERROR = "httpsverifyerror";
    public static final int LOAD_BEGIN = 1011;
    public static final int LOAD_FINSH = 1012;
    public static final int LOAD_ERROR = 1013;
    public static final int URL_HITTED = 1014;
    public static final int PAGE_FINSH = 1015;
    public static final int DOMREADY = 1016;
    private static String[] SUPPORTED_MIMETYPE = new String[]{"text/html", "text/plain", "application/xhtml+xml", "application/xml", "image/jpeg", "image/png", "image/webp", "image/gif"};
    private static String[] SUPPORTED_MIMETYPE_CONFIG = null;
    private int token;
    private boolean needDomReady;
    private a htmlDownloader;
    private String url;
    private boolean isReload;
    private boolean isLoading;
    private long beginTime = 0L;
    private Map requestHeaders = null;
    private c sslErrorListener;

    public void setSslErrorListener(c c2) {
        this.sslErrorListener = c2;
    }

    public HybridPlusWebView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.initInternal();
    }

    public HybridPlusWebView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initInternal();
    }

    public HybridPlusWebView(Context context) {
        super(context);
        this.initInternal();
    }

    @Override
    public String getCurrentUrl() {
        String string = super.getUrl();
        if (this.isLoading || string == null) {
            return this.url;
        }
        return super.getUrl();
    }

    public String getUrl() {
        return this.getCurrentUrl();
    }

    private void initInternal() {
        this.token = 0;
        this.needDomReady = true;
        super.addJsObject("WVPlusWebView", new b(this, null));
        if (SUPPORTED_MIMETYPE_CONFIG == null) {
            SharedPreferences sharedPreferences = this.context.getSharedPreferences(WEBVIEW_MIMETYPE, 0);
            String string = "";
            try {
                string = sharedPreferences.getString(WEBVIEW_MIMETYPE, "");
            }
            catch (ClassCastException classCastException) {
                g.b(TAG, "get mimeType ClassCastException:" + string);
            }
            if (g.a()) {
                g.a(TAG, "support mimetype:" + string);
            }
            if ((SUPPORTED_MIMETYPE_CONFIG = string.split(";")) != null && SUPPORTED_MIMETYPE_CONFIG.length > 0 && SUPPORTED_MIMETYPE_CONFIG[0].length() > 0) {
                SUPPORTED_MIMETYPE = SUPPORTED_MIMETYPE_CONFIG;
            } else {
                SUPPORTED_MIMETYPE_CONFIG = null;
            }
        }
    }

    public boolean back() {
        if (!this.isAlive) {
            return false;
        }
        if (this.canGoBack()) {
            this.goBack();
            return true;
        }
        return false;
    }

    @Override
    public void loadUrl(String string) {
        if (!this.isAlive) {
            return;
        }
        if (string.startsWith("http://m.taobao.com") || string.startsWith("https://m.taobao.com")) {
            string = h.a(string, "ttid", com.alibaba.sdk.android.feedback.xblink.b.b.a().b());
        }
        this.loadUrl(string, null, true);
    }

    public void reload(boolean bl) {
        if (!this.isAlive) {
            return;
        }
        String string = super.getUrl();
        if (this.isLoading || string == null) {
            this.loadUrl(this.url, this.requestHeaders, bl);
            if (g.a()) {
                g.a(TAG, "reload & loading: " + this.url);
            }
        } else {
            super.reload();
            if (g.a()) {
                g.a(TAG, "reload & post\uff1a " + string);
            }
        }
    }

    @Override
    public void reload() {
        this.reload(false);
    }

    public void goBack() {
        WebBackForwardList webBackForwardList;
        WebHistoryItem webHistoryItem;
        String string;
        if (!this.isAlive) {
            return;
        }
        ++this.token;
        if (this.htmlDownloader != null) {
            this.htmlDownloader.a();
            this.htmlDownloader.b();
            this.htmlDownloader.a(null);
        }
        if (this.isLoading && this.webViewClient != null) {
            this.webViewClient.onPageFinished((WebView)this, this.getUrl());
        } else if (this.canGoBack() && (string = (webHistoryItem = (webBackForwardList = this.copyBackForwardList()).getItemAtIndex(webBackForwardList.getCurrentIndex() - 1)).getUrl()) != null) {
            if (g.a()) {
                g.a(TAG, "goBack: " + string);
            }
            super.goBack();
        }
    }

    public void goBackOrForward(int n2) {
        if (!this.isAlive) {
            return;
        }
        if (n2 != 0) {
            ++this.token;
        }
        if (this.htmlDownloader != null) {
            this.htmlDownloader.a();
            this.htmlDownloader.b();
            this.htmlDownloader.a(null);
        }
        if (this.isLoading) {
            if (n2 < -1) {
                ++n2;
            } else if (n2 < 0) {
                if (this.webViewClient != null) {
                    this.webViewClient.onPageFinished((WebView)this, super.getUrl());
                } else {
                    return;
                }
            }
        }
        if (this.canGoBackOrForward(n2)) {
            WebBackForwardList webBackForwardList = this.copyBackForwardList();
            WebHistoryItem webHistoryItem = webBackForwardList.getItemAtIndex(webBackForwardList.getCurrentIndex() + n2);
            String string = webHistoryItem.getUrl();
            if (string != null && g.a()) {
                g.a(TAG, "goBackOrForward: " + string);
            }
            super.goBackOrForward(n2);
        }
    }

    public void stopLoading() {
        if (!this.isAlive) {
            return;
        }
        ++this.token;
        if (this.htmlDownloader != null) {
            this.htmlDownloader.a();
            this.htmlDownloader.b();
            this.htmlDownloader.a(null);
        }
        super.stopLoading();
    }

    private void loadUrl(String string, Map map, boolean bl) {
        if (!this.isAlive) {
            return;
        }
        boolean bl2 = this.isReload = string != null && string.equals(this.url);
        if (string != null && (string.toLowerCase().startsWith("data:") || string.toLowerCase().startsWith("javascript:") || string.toLowerCase().startsWith("file:"))) {
            super.loadUrl(string);
            return;
        }
        if (this.htmlDownloader != null) {
            this.htmlDownloader.a();
            this.htmlDownloader.b();
            this.htmlDownloader.a(null);
        }
        ++this.token;
        this.url = string;
        this.isLoading = true;
        this.requestHeaders = null;
        if (map != null) {
            this.requestHeaders = new HashMap(map);
        }
        this.htmlDownloader = new a(this.getSettings().getUserAgentString(), this, this.requestHeaders, string, this.token, bl);
        new Thread(this.htmlDownloader).start();
        if (this.webViewClient != null && this.isAlive) {
            this.webViewClient.onPageStarted((WebView)this, string, null);
        }
        this.beginTime = System.currentTimeMillis();
    }

    public void enableDomReady(boolean bl) {
        this.needDomReady = bl;
    }

    @Override
    public void destroy() {
        if (this.htmlDownloader != null) {
            this.htmlDownloader.a(null);
            this.htmlDownloader.b();
            this.htmlDownloader = null;
        }
        super.destroy();
    }

    private String addDomReady(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf("window.WindVane.call('WVPlusWebView','htmlFinsh',{});\n");
        if (n2 != -1) {
            return string;
        }
        n2 = string.indexOf("</body>");
        if (n2 == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.substring(0, n2));
        stringBuilder.append("<script type=\"text/javascript\" src=\"http://g.tbcdn.cn/mtb/lib-windvane/1.2.4/bridge.js\"></script>");
        stringBuilder.append("<script type=\"text/javascript\">document.addEventListener( \"DOMContentLoaded\", function() { window.WindVane.call('WVPlusWebView','htmlFinsh',{}); }, false ); </script>");
        stringBuilder.append(string.substring(n2));
        return stringBuilder.toString();
    }

    @Override
    public void callback(byte[] byArray, Map map, int n2) {
        if (n2 == this.token) {
            CookieManager cookieManager;
            Object object;
            Message message = Message.obtain();
            message.arg1 = n2;
            String string = "";
            if (map.containsKey(HTTPSVERIFYERROR)) {
                string = (String)map.get(HTTPSVERIFYERROR);
                if (string.equals("EXPIRED")) {
                    message.what = -602;
                    message.obj = map;
                    this.mHandler.sendMessage(message);
                    return;
                }
                if (string.equals("INVALID")) {
                    message.what = -601;
                    message.obj = map;
                    this.mHandler.sendMessage(message);
                    return;
                }
            }
            String string2 = (String)map.get("content-type");
            String string3 = "";
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                object = SUPPORTED_MIMETYPE;
                int n3 = ((String[])object).length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    String string4 = object[i2];
                    if (!string2.toLowerCase().contains(string4)) continue;
                    map.put(MIMETYPE, string4);
                    string3 = string4;
                    break;
                }
            }
            if (string2 != null && TextUtils.isEmpty((CharSequence)string3)) {
                if (g.a()) {
                    g.a(TAG, "unsupport minitype:" + string2);
                }
                message.what = -400;
                message.obj = map.get("url");
                this.mHandler.sendMessage(message);
                return;
            }
            if (byArray != null) {
                object = (String)map.get(CHARSET);
                if (string3.equalsIgnoreCase("text/html")) {
                    String string5 = null;
                    try {
                        string5 = new String(byArray, (String)object);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        g.b(TAG, unsupportedEncodingException + "");
                    }
                    if (this.needDomReady) {
                        string5 = this.addDomReady(string5);
                    }
                    map.put(HTML_CONTENT, string5);
                } else if (string3.startsWith("image")) {
                    String string6 = Base64.encodeToString((byte[])byArray, (int)0);
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("<img src=\"data:");
                    stringBuilder.append(string3);
                    stringBuilder.append(";base64,");
                    stringBuilder.append(string6);
                    stringBuilder.append("\"/>");
                    map.put(MIMETYPE, "text/html");
                    map.put(HTML_CONTENT, stringBuilder.toString());
                } else {
                    String string7 = null;
                    try {
                        string7 = new String(byArray, (String)object);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        g.b(TAG, unsupportedEncodingException + "");
                    }
                    map.put(HTML_CONTENT, string7);
                }
            }
            if ((object = (String)map.get("set-cookie")) != null && (cookieManager = CookieManager.getInstance()).acceptCookie()) {
                cookieManager.setCookie(this.url, (String)object);
            }
            message.what = 200;
            message.obj = map;
            this.mHandler.sendMessage(message);
        }
    }

    @Override
    public boolean handleMessage(Message message) {
        super.handleMessage(message);
        switch (message.what) {
            case 1016: {
                if (this.isAlive && this.webViewClient != null) {
                    this.webViewClient.onPageFinished((WebView)this, "DOMContentLoaded");
                }
                return true;
            }
            case -601: {
                if (this.sslErrorListener != null) {
                    this.sslErrorListener.a(-601);
                }
                return true;
            }
            case -602: {
                if (this.sslErrorListener != null) {
                    this.sslErrorListener.a(-602);
                }
                return true;
            }
            case -400: {
                this.isLoading = false;
                if (this.token == message.arg1 && this.isAlive && this.webViewClient != null) {
                    this.webViewClient.onReceivedError((WebView)this, -400, "unsupported mini type", (String)message.obj);
                }
                if (this.htmlDownloader == null) break;
                this.htmlDownloader.b();
                break;
            }
            case 200: {
                this.isLoading = false;
                if (this.token == message.arg1 && this.isAlive) {
                    Map map = (Map)message.obj;
                    String string = (String)map.get("url");
                    int n2 = 0;
                    if (map.containsKey("response-code")) {
                        n2 = Integer.parseInt((String)map.get("response-code"));
                    }
                    if (g.a()) {
                        g.c(TAG, "html_code:" + n2);
                    }
                    if (n2 >= 300 && n2 < 400 && map.containsKey("location")) {
                        this.loadUrl((String)map.get("location"));
                        return true;
                    }
                    if (n2 == 0) {
                        if (this.isAlive && this.webViewClient != null) {
                            this.webViewClient.onReceivedError((WebView)this, 400, "HTML\u4e0b\u8f7d\u5931\u8d25", string);
                        }
                    } else {
                        String string2 = (String)map.get(HTML_CONTENT);
                        if (string2 != null) {
                            super.loadDataWithBaseURL(string, string2, (String)map.get(MIMETYPE), (String)map.get(CHARSET), string);
                        } else if (this.isAlive && this.webViewClient != null) {
                            this.webViewClient.onReceivedError((WebView)this, 400, "HTML\u4e0b\u8f7d\u5931\u8d25", string);
                        }
                        g.c(TAG, "dom downloaded time:" + (System.currentTimeMillis() - this.beginTime));
                    }
                }
                if (this.htmlDownloader == null) break;
                this.htmlDownloader.b();
            }
        }
        return false;
    }

    static /* synthetic */ long access$100(HybridPlusWebView hybridPlusWebView) {
        return hybridPlusWebView.beginTime;
    }
}

