/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.feedback.xblink.webview;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.TextView;
import android.widget.Toast;
import com.alibaba.sdk.android.feedback.R;
import com.alibaba.sdk.android.feedback.xblink.activity.XBBaseHybridActivity;
import com.alibaba.sdk.android.feedback.xblink.b.b;
import com.alibaba.sdk.android.feedback.xblink.e.a;
import com.alibaba.sdk.android.feedback.xblink.f.d;
import com.alibaba.sdk.android.feedback.xblink.f.j;
import com.alibaba.sdk.android.feedback.xblink.i.g;
import com.alibaba.sdk.android.feedback.xblink.i.h;
import com.alibaba.sdk.android.feedback.xblink.webview.HybridWebChromeClient;
import com.alibaba.sdk.android.feedback.xblink.webview.HybridWebViewClient;
import com.alibaba.sdk.android.feedback.xblink.webview.l;
import com.alibaba.sdk.android.feedback.xblink.webview.n;
import com.alibaba.sdk.android.feedback.xblink.webview.o;
import com.alibaba.sdk.android.feedback.xblink.webview.p;
import com.alibaba.sdk.android.feedback.xblink.webview.q;
import com.alibaba.sdk.android.feedback.xblink.webview.r;
import com.alibaba.sdk.android.feedback.xblink.webview.s;
import com.alibaba.sdk.android.feedback.xblink.webview.u;
import com.alibaba.sdk.android.feedback.xblink.webview.v;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class XBHybridWebView
extends WebView
implements Handler.Callback {
    private static final String TAG = "HybridWebView";
    public static final int NOTIFY_PAGE_START = 400;
    public static final int NOTIFY_PAGE_FINISH = 401;
    public static final int NOTIFY_PAGE_ERROR = 402;
    public static final int NOTIFY_TIME_OUT = 403;
    public static final int NOTIFY_SAVE_IMAGE_SUCCESS = 404;
    public static final int NOTIFY_SAVE_IMAGE_FAIL = 405;
    public static final int NOTIFY_TOOL_BAR_SETTING = 406;
    public Context context;
    protected Handler mHandler = null;
    protected WebViewClient webViewClient;
    protected WebChromeClient webChromeClient;
    protected boolean isAlive;
    private v wvUIModel = null;
    protected boolean supportDownload = true;
    private boolean wvSupportNativeJs = true;
    private String currentUrl = "";
    private String appkey = "";
    protected j entryManager;
    private com.alibaba.sdk.android.feedback.xblink.f.b.b event;
    private WeakReference container;
    private long loadTime = System.currentTimeMillis();
    private long onErrorTime = 0L;
    private com.alibaba.sdk.android.feedback.xblink.view.a mPopupController;
    private String[] mPopupMenuTags = new String[]{"\u4fdd\u5b58\u5230\u76f8\u518c"};
    private String mImageUrl;
    private View.OnClickListener popupClickListener = new o(this);

    public XBHybridWebView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.context = context;
        this.init();
    }

    public XBHybridWebView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.context = context;
        this.init();
    }

    public XBHybridWebView(Context context) {
        super(context);
        this.context = context;
        this.init();
    }

    public void attachFragment(android.support.v4.app.Fragment fragment) {
        this.container = new WeakReference<android.support.v4.app.Fragment>(fragment);
    }

    public void attachFragment(Fragment fragment) {
        this.container = new WeakReference<Fragment>(fragment);
    }

    public void attachActivity(Activity activity) {
        this.container = new WeakReference<Activity>(activity);
    }

    public Object getContainer() {
        return this.container != null ? this.container.get() : null;
    }

    public void loadData(String string, String string2, String string3) {
        if (!this.isAlive) {
            return;
        }
        super.loadData(string, string2, string3);
        this.loadTime = System.currentTimeMillis();
    }

    public void reload() {
        super.reload();
        this.loadTime = System.currentTimeMillis();
    }

    public void loadDataWithBaseURL(String string, String string2, String string3, String string4, String string5) {
        if (!this.isAlive) {
            return;
        }
        if (g.a()) {
            g.a(TAG, "loadDataWithBaseURL: baseUrl=" + string);
        }
        super.loadDataWithBaseURL(string, string2, string3, string4, string5);
        this.loadTime = System.currentTimeMillis();
    }

    public void loadUrl(String string) {
        g.a(TAG, "FeedbackAPI url=" + string);
        if (!this.isAlive || string == null) {
            return;
        }
        if (g.a()) {
            g.a(TAG, "loadUrl: url=" + string);
        }
        super.loadUrl(this.addTTID(string));
        if (h.a(string)) {
            this.loadTime = System.currentTimeMillis();
        }
    }

    public void superLoadUrl(String string) {
        if (!this.isAlive) {
            return;
        }
        super.loadUrl(string);
        if (h.a(string)) {
            this.loadTime = System.currentTimeMillis();
        }
    }

    public void loadUrl(String string, Map map) {
        if (!this.isAlive || string == null) {
            return;
        }
        if (g.a()) {
            g.a(TAG, "loadUrl with headers: url=" + string);
        }
        super.loadUrl(this.addTTID(string), map);
        if (h.a(string)) {
            this.loadTime = System.currentTimeMillis();
        }
    }

    public void postUrl(String string, byte[] byArray) {
        if (!this.isAlive || string == null) {
            return;
        }
        if (g.a()) {
            g.a(TAG, "postUrl: url=" + string);
        }
        super.postUrl(string, byArray);
        if (h.a(string)) {
            this.loadTime = System.currentTimeMillis();
        }
    }

    @SuppressLint(value={"NewApi", "SetJavaScriptEnabled"})
    private void init() {
        String string;
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        this.webViewClient = new HybridWebViewClient(this.context);
        super.setWebViewClient(this.webViewClient);
        this.webChromeClient = new HybridWebChromeClient(this.context);
        super.setWebChromeClient(this.webChromeClient);
        this.setVerticalScrollBarEnabled(false);
        this.requestFocus();
        CookieManager.getInstance().setAcceptCookie(true);
        WebSettings webSettings = this.getSettings();
        try {
            webSettings.setTextZoom(100);
        }
        catch (Exception exception) {
            // empty catch block
        }
        webSettings.setAllowFileAccess(false);
        try {
            webSettings.setJavaScriptEnabled(true);
        }
        catch (Throwable throwable) {
            g.a(TAG, "Failed to enable javascript on device, " + throwable.getMessage(), throwable);
        }
        String string2 = b.a().c();
        String string3 = b.a().d();
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            webSettings.setUserAgentString(webSettings.getUserAgentString() + " AliApp(" + string2 + "/" + string3 + ")");
        }
        webSettings.setUserAgentString(webSettings.getUserAgentString() + " WindVane/4.5.1");
        webSettings.setCacheMode(-1);
        if (Build.VERSION.SDK_INT >= 5) {
            webSettings.setDatabaseEnabled(true);
            string = this.context.getFilesDir().getParentFile().getPath() + "/databases";
            webSettings.setDatabasePath(string);
            webSettings.setGeolocationEnabled(true);
            webSettings.setGeolocationDatabasePath(string);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(0);
        }
        if (Build.VERSION.SDK_INT >= 7) {
            webSettings.setDomStorageEnabled(true);
            webSettings.setAppCacheEnabled(true);
            if (this.context != null && this.context.getCacheDir() != null) {
                string = this.context.getCacheDir().getAbsolutePath();
                webSettings.setAppCachePath(string);
            }
        }
        if (Build.VERSION.SDK_INT < 18) {
            webSettings.setSavePassword(false);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            webSettings.setAllowUniversalAccessFromFileURLs(false);
            webSettings.setAllowFileAccessFromFileURLs(false);
        }
        d.a().b();
        this.entryManager = new j(this.context, this);
        this.event = new com.alibaba.sdk.android.feedback.xblink.f.b.b();
        this.event.a(this.context, this);
        this.addJsObject("WXAppEvent", this.event);
        if (Build.VERSION.SDK_INT > 15) {
            try {
                string = (ClipboardManager)this.context.getSystemService("clipboard");
                if (string != null) {
                    ClipData clipData = string.getPrimaryClip();
                    if (clipData == null) {
                        string.setPrimaryClip(ClipData.newPlainText((CharSequence)"\u521d\u59cb\u5316", (CharSequence)""));
                    } else if ("intent:#Intent;S.K_1171477665=;end".equals(clipData.getItemAt(0).coerceToText(this.context).toString())) {
                        string.setPrimaryClip(ClipData.newPlainText((CharSequence)"\u521d\u59cb\u5316", (CharSequence)""));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.wvUIModel = new v(this.context, (View)this);
        this.setOnLongClickListener(new n(this));
        this.setDownloadListener(new s(this));
        l.a();
        this.isAlive = true;
        this.removeJavascriptInterface("searchBoxJavaBridge_");
        this.removeJavascriptInterface("accessibility");
        this.removeJavascriptInterface("accessibilityTraversal");
    }

    public void setWebViewClient(WebViewClient webViewClient) {
        if (!(webViewClient instanceof HybridWebViewClient)) {
            throw new u("Your WebViewClient must be extended from HybridWebViewClient");
        }
        this.webViewClient = webViewClient;
        super.setWebViewClient(webViewClient);
    }

    public void setWebChromeClient(WebChromeClient webChromeClient) {
        if (!(webChromeClient instanceof HybridWebChromeClient)) {
            throw new u("Your WebChromeClient must be extended from HybridWebChromeClient");
        }
        this.webChromeClient = webChromeClient;
        super.setWebChromeClient(webChromeClient);
    }

    public void setUrlFilter(a a2) {
        if (this.webViewClient instanceof HybridWebViewClient) {
            ((HybridWebViewClient)this.webViewClient).setUrlFilter(a2);
        }
    }

    public a getUrlFilter() {
        if (this.webViewClient instanceof HybridWebViewClient) {
            return ((HybridWebViewClient)this.webViewClient).getUrlFilter();
        }
        return null;
    }

    public long getLoadTimestamp() {
        return this.loadTime;
    }

    public void setLoadTimestamp(long l2) {
        this.loadTime = l2;
    }

    public void destroy() {
        if (!this.isAlive) {
            return;
        }
        this.isAlive = false;
        super.setWebViewClient(null);
        super.setWebChromeClient(null);
        this.webViewClient = null;
        this.webChromeClient = null;
        this.entryManager.a();
        com.alibaba.sdk.android.feedback.xblink.a.b.a().b();
        this.mHandler.removeCallbacksAndMessages(null);
        this.removeAllViews();
        try {
            super.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public v getWvUIModel() {
        return this.wvUIModel;
    }

    public void enableTakeDownload(boolean bl) {
        if (this.webViewClient instanceof HybridWebViewClient) {
            ((HybridWebViewClient)this.webViewClient).enableTakeDownload(bl);
        }
    }

    public void onMessage(int n2, Object object) {
        if (this.mHandler != null) {
            Message message = Message.obtain();
            message.what = n2;
            message.obj = object;
            this.mHandler.sendMessage(message);
        }
    }

    private String addTTID(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        Uri uri = Uri.parse((String)string);
        String string3 = uri.getHost();
        String string4 = uri.getScheme();
        if (string3 != null && string3.endsWith("m.taobao.com") && ("http".equals(string4) || "https".equals(string4)) && (string2 = uri.getQueryParameter("ttid")) == null) {
            Uri.Builder builder = uri.buildUpon();
            builder.appendQueryParameter("ttid", b.a().b());
            return builder.toString();
        }
        return string;
    }

    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 400: {
                this.wvUIModel.b();
                return true;
            }
            case 401: {
                this.wvUIModel.c();
                if (this.onErrorTime != 0L && System.currentTimeMillis() - this.onErrorTime > 3000L) {
                    this.wvUIModel.e();
                }
                return true;
            }
            case 402: {
                this.wvUIModel.d();
                this.onErrorTime = System.currentTimeMillis();
                return true;
            }
            case 403: {
                this.wvUIModel.c();
                return true;
            }
            case 404: {
                Toast.makeText((Context)this.context, (CharSequence)"\u56fe\u7247\u4fdd\u5b58\u5230\u76f8\u518c\u6210\u529f", (int)1).show();
                return true;
            }
            case 405: {
                Toast.makeText((Context)this.context, (CharSequence)"\u56fe\u7247\u4fdd\u5b58\u5230\u76f8\u518c\u5931\u8d25", (int)1).show();
                return true;
            }
            case 406: {
                try {
                    JSONObject jSONObject = new JSONObject((String)message.obj);
                    if (jSONObject.has("pageTitle")) {
                        this.setPageTitle(jSONObject.getString("pageTitle"));
                    }
                    boolean bl = jSONObject.getBoolean("canGoBack");
                    String string = null;
                    if (bl) {
                        string = jSONObject.getString("backCallback");
                    }
                    this.updateReturnButtonBehaviour(bl, string);
                    boolean bl2 = jSONObject.getBoolean("haveRightNavButton");
                    String string2 = null;
                    String string3 = null;
                    if (bl2) {
                        string2 = jSONObject.getString("rightButtonContent");
                        string3 = jSONObject.getString("rightButtonCallback");
                    }
                    this.updateRightNavButton(bl2, string2, string3);
                    com.alibaba.sdk.android.feedback.util.l.b(this.context);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                return true;
            }
        }
        return false;
    }

    @TargetApi(value=11)
    public void onPause() {
        com.alibaba.sdk.android.feedback.xblink.a.b.a().b();
        if (this.entryManager != null) {
            this.entryManager.b();
        }
        if (Build.VERSION.SDK_INT >= 11) {
            super.onPause();
        }
    }

    @TargetApi(value=11)
    public void onResume() {
        if (this.entryManager != null) {
            this.entryManager.c();
        }
        if (Build.VERSION.SDK_INT >= 11) {
            super.onResume();
        }
    }

    public Handler getWVHandler() {
        return this.mHandler;
    }

    public void setSupportDownload(boolean bl) {
        this.supportDownload = bl;
    }

    public void addJavascriptInterface(Object object, String string) {
        if (!this.wvSupportNativeJs && Build.VERSION.SDK_INT < 17) {
            g.b(TAG, "addJavascriptInterface is disabled before API level 17 for security.");
        } else if (Build.VERSION.SDK_INT >= 17) {
            super.addJavascriptInterface(object, string);
        }
    }

    public void supportJavascriptInterface(boolean bl) {
        this.wvSupportNativeJs = bl;
    }

    public void addJsObject(String string, Object object) {
        if (this.entryManager != null) {
            this.entryManager.a(string, object);
        }
    }

    public Object getJsObject(String string) {
        if (this.entryManager == null) {
            return null;
        }
        return this.entryManager.a(string);
    }

    public void onActivityResult(int n2, int n3, Intent intent) {
        if (this.entryManager != null) {
            this.entryManager.a(n2, n3, intent);
        }
    }

    public void onRequestPermissionsResult(int n2, String[] stringArray, int[] nArray) {
        if (this.entryManager != null) {
            this.entryManager.a(n2, stringArray, nArray);
        }
    }

    public String getCurrentUrl() {
        return this.currentUrl;
    }

    public void setCurrentUrl(String string) {
        this.currentUrl = string;
    }

    public String getAppkey() {
        return this.appkey;
    }

    public void setAppkey(String string) {
        this.appkey = string;
    }

    public synchronized com.alibaba.sdk.android.feedback.xblink.f.b getWVCallBackContext() {
        if (this.event != null) {
            return this.event.d();
        }
        return null;
    }

    private void updateReturnButtonBehaviour(boolean bl, String string) {
        g.a(TAG, "feedback updateReturnButtonBehaviour");
        View view = ((Activity)this.context).findViewById(R.id.title_back);
        try {
            ((XBBaseHybridActivity)this.context).setJSControlledBackPress(bl, string);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (bl) {
            view.setOnClickListener((View.OnClickListener)new p(this, string));
        } else {
            view.setOnClickListener((View.OnClickListener)new q(this));
        }
    }

    private void updateRightNavButton(boolean bl, String string, String string2) {
        TextView textView = (TextView)((Activity)this.context).findViewById(R.id.title_button);
        if (bl) {
            com.alibaba.sdk.android.feedback.util.l.a(this.context, string);
            textView.setOnClickListener((View.OnClickListener)new r(this, string2));
        } else {
            com.alibaba.sdk.android.feedback.util.l.a(this.context);
        }
    }

    private void setPageTitle(String string) {
        g.a(TAG, "feedback setPageTitle");
        com.alibaba.sdk.android.feedback.util.l.b(this.context, string);
    }
}

