/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ha.adapter;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.alibaba.ha.adapter.AliHaConfig;
import com.alibaba.ha.adapter.Plugin;
import com.alibaba.ha.adapter.plugin.CrashReporterPlugin;
import com.alibaba.ha.adapter.plugin.NetworkMonitorPlugin;
import com.alibaba.ha.adapter.plugin.TLogPlugin;
import com.alibaba.ha.adapter.plugin.factory.PluginFactory;
import com.alibaba.ha.adapter.service.activity.AdapterActivityLifeCycle;
import com.alibaba.ha.adapter.service.apm.APMService;
import com.alibaba.ha.adapter.service.appstatus.AppStatusRegHelper;
import com.alibaba.ha.adapter.service.appstatus.Event1010Handler;
import com.alibaba.ha.adapter.service.bizerror.BizErrorService;
import com.alibaba.ha.adapter.service.crash.CrashService;
import com.alibaba.ha.adapter.service.tlog.TLogService;
import com.alibaba.ha.core.AliHaCore;
import com.alibaba.ha.protocol.AliHaParam;
import com.alibaba.ha.protocol.AliHaPlugin;
import com.alibaba.ha.protocol.crash.ErrorCallback;
import com.alibaba.motu.tbrest.SendService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AliHaAdapter {
    public static final String mUniversalHost = "adash-emas.cn-hangzhou.aliyuncs.com";
    public static final String mHATLogHost = "tlog-emas.aliyuncs.com";
    public static final String mHAOSSBucketName = "emasha-online";
    public static final String TAG = "AliHaAdapter";
    public List<Plugin> plugins;
    public Context context;

    public AliHaAdapter() {
        ArrayList<Plugin> arrayList;
        ArrayList<Plugin> arrayList2 = arrayList;
        arrayList = new ArrayList<Plugin>();
        this.plugins = arrayList2;
        this.context = null;
        this.openPublishEmasHa();
    }

    public static synchronized AliHaAdapter getInstance() {
        return InstanceCreater.instance;
    }

    private String getBizId() {
        String bizId = "";
        if (this.plugins.contains((Object)Plugin.crashreporter)) {
            bizId = "ha-crash";
        }
        if (this.plugins.contains((Object)Plugin.apm)) {
            if (bizId.length() != 0) {
                bizId = bizId + "_";
            }
            bizId = bizId + "ha-apm";
        }
        if (this.plugins.contains((Object)Plugin.tlog)) {
            if (bizId.length() != 0) {
                bizId = bizId + "_";
            }
            bizId = bizId + "ha-tlog";
        }
        return bizId;
    }

    private void initAppStatus(AliHaConfig config) {
        String bizId = this.getBizId();
        if (bizId != null && config != null) {
            AppStatusRegHelper.registeActivityLifecycleCallbacks(config.application);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("_aliyun_biz_id", bizId);
            Event1010Handler handler = Event1010Handler.getInstance();
            handler.init(config.application, map);
            AppStatusRegHelper.registerAppStatusCallbacks(handler);
        }
    }

    private AliHaParam buildParam(AliHaConfig config) {
        AliHaParam param = new AliHaParam();
        param.application = config.application;
        param.context = config.context;
        param.appKey = config.appKey;
        param.appSecret = config.appSecret;
        param.appId = config.isAliyunos != false ? param.appKey + "@aliyunos" : param.appKey + "@android";
        param.appVersion = config.appVersion;
        param.channel = config.channel;
        param.userNick = config.userNick;
        param.initAsync = config.initAsync;
        return param;
    }

    private Boolean isLegal(AliHaConfig config) {
        if (config == null) {
            Log.e((String)TAG, (String)"config is null ");
            return false;
        }
        if (config.application == null) {
            Log.e((String)TAG, (String)"application is null ");
            return false;
        }
        if (config.context == null) {
            Log.e((String)TAG, (String)"context is null ");
            return false;
        }
        if (config.appKey != null && config.appSecret != null && config.appVersion != null) {
            if (this.plugins.contains((Object)Plugin.tlog) && TextUtils.isEmpty((CharSequence)config.rsaPublicKey)) {
                Log.e((String)TAG, (String)"rsaPublicKey is empty ");
                return false;
            }
            this.context = config.context;
            return true;
        }
        Log.e((String)TAG, (String)("config is unlegal, ha plugin start failure  appKey is " + config.appKey + " appVersion is " + config.appVersion + " appSecret is " + config.appSecret));
        return false;
    }

    private void changeTLogHost() {
        TLogService.changeHost(mHATLogHost);
    }

    private void changeTLogBucketName() {
        TLogService.changeBucketName(mHAOSSBucketName);
    }

    public /* synthetic */ AliHaAdapter(1 x0) {
        this();
    }

    public void addPlugin(Plugin plugin) {
        if (plugin != null && !this.plugins.contains((Object)plugin)) {
            Log.w((String)TAG, (String)("plugin add to list success, plugin name is " + plugin.name()));
            this.plugins.add(plugin);
            if (Plugin.crashreporter.equals((Object)plugin)) {
                if (!this.plugins.contains((Object)Plugin.olympic)) {
                    this.plugins.add(Plugin.olympic);
                }
                if (!this.plugins.contains((Object)Plugin.watch)) {
                    this.plugins.add(Plugin.watch);
                }
            }
            if (Plugin.apm.equals((Object)plugin) && !this.plugins.contains((Object)Plugin.networkmonitor)) {
                this.plugins.add(Plugin.networkmonitor);
            }
        }
    }

    public void removePlugin(Plugin plugin) {
        if (plugin != null) {
            Log.w((String)TAG, (String)("plugin remove from list success, plugin name is " + plugin.name()));
            this.plugins.remove((Object)plugin);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean start(AliHaConfig config) {
        block16: {
            Plugin plugin;
            List<Plugin> list;
            boolean bl;
            Plugin plugin2;
            List<Plugin> list2;
            boolean bl2;
            Plugin plugin3;
            List<Plugin> list3;
            boolean bl3;
            Plugin plugin4;
            List<Plugin> list4;
            boolean bl4;
            Plugin plugin5;
            List<Plugin> list5;
            boolean bl5;
            AliHaParam param;
            block15: {
                if (!this.isLegal(config).booleanValue()) {
                    return false;
                }
                param = this.buildParam(config);
                try {
                    StringBuilder stringBuilder;
                    String string;
                    List<Plugin> list6 = this.plugins;
                    Plugin plugin6 = Plugin.crashreporter;
                    boolean bl6 = list6.contains((Object)plugin6);
                    if (bl6) {
                        CrashReporterPlugin crashReporterPlugin;
                        CrashReporterPlugin crashReporterPlugin2 = crashReporterPlugin;
                        crashReporterPlugin2();
                        CrashReporterPlugin crashReporterPlugin3 = crashReporterPlugin2;
                        AliHaCore aliHaCore = AliHaCore.getInstance();
                        aliHaCore.startWithPlugin(param, (AliHaPlugin)crashReporterPlugin3);
                        break block15;
                    }
                    SendService sendService = SendService.getInstance();
                    Context context = param.context;
                    String string6 = param.appId;
                    string6 = param.appKey;
                    string6 = param.appVersion;
                    string6 = param.channel;
                    string6 = param.userNick;
                    sendService.init(context, string2, string3, string4, string5, string6);
                    SendService sendService2 = SendService.getInstance();
                    sendService2.appSecret = string = param.appSecret;
                    StringBuilder stringBuilder2 = stringBuilder;
                    stringBuilder2();
                    StringBuilder stringBuilder3 = stringBuilder2.append("init send service success, appId is ");
                    String string7 = param.appId;
                    StringBuilder stringBuilder5 = stringBuilder3.append(string7);
                    stringBuilder5 = stringBuilder5.append(" appKey is ");
                    String string8 = param.appKey;
                    StringBuilder stringBuilder7 = stringBuilder5.append(string8);
                    stringBuilder7 = stringBuilder7.append(" appVersion is ");
                    String string9 = param.appVersion;
                    StringBuilder stringBuilder9 = stringBuilder7.append(string9);
                    stringBuilder9 = stringBuilder9.append(" channel is ");
                    String string10 = param.channel;
                    StringBuilder stringBuilder11 = stringBuilder9.append(string10);
                    stringBuilder11 = stringBuilder11.append(" userNick is ");
                    String string11 = param.userNick;
                    StringBuilder stringBuilder12 = stringBuilder11.append(string11);
                    String string12 = stringBuilder12.toString();
                    Log.i((String)TAG, (String)string12);
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    Log.e((String)TAG, (String)"start plugin error ", (Throwable)exception2);
                    return false;
                }
            }
            List<Plugin> list7 = this.plugins;
            Plugin plugin7 = Plugin.ut;
            boolean bl7 = list7.contains((Object)plugin7);
            if (bl7) {
                AliHaPlugin aliHaPlugin;
                Plugin plugin8 = Plugin.ut;
                AliHaPlugin aliHaPlugin2 = aliHaPlugin = PluginFactory.createPlugin(plugin8);
                AliHaCore aliHaCore = AliHaCore.getInstance();
                aliHaCore.registPlugin(aliHaPlugin2);
            }
            if (bl5 = (list5 = this.plugins).contains((Object)(plugin5 = Plugin.tlog))) {
                AliHaPlugin aliHaPlugin;
                Plugin plugin9 = Plugin.tlog;
                AliHaPlugin aliHaPlugin3 = aliHaPlugin = PluginFactory.createPlugin(plugin9);
                AliHaCore aliHaCore = AliHaCore.getInstance();
                aliHaCore.registPlugin(aliHaPlugin3);
                String string = config.rsaPublicKey;
                TLogService.changeRasPublishKey(string);
            }
            if (bl4 = (list4 = this.plugins).contains((Object)(plugin4 = Plugin.watch))) {
                AliHaPlugin aliHaPlugin;
                Plugin plugin10 = Plugin.watch;
                AliHaPlugin aliHaPlugin4 = aliHaPlugin = PluginFactory.createPlugin(plugin10);
                AliHaCore aliHaCore = AliHaCore.getInstance();
                aliHaCore.registPlugin(aliHaPlugin4);
            }
            if (bl3 = (list3 = this.plugins).contains((Object)(plugin3 = Plugin.apm))) {
                AliHaPlugin aliHaPlugin;
                Plugin plugin11 = Plugin.apm;
                AliHaPlugin aliHaPlugin5 = aliHaPlugin = PluginFactory.createPlugin(plugin11);
                AliHaCore aliHaCore = AliHaCore.getInstance();
                aliHaCore.registPlugin(aliHaPlugin5);
            }
            if (bl2 = (list2 = this.plugins).contains((Object)(plugin2 = Plugin.networkmonitor))) {
                Plugin plugin12 = Plugin.networkmonitor;
                AliHaPlugin aliHaPlugin6 = PluginFactory.createPlugin(plugin12);
                aliHaPlugin6 = aliHaPlugin6;
                boolean bl8 = aliHaPlugin6 instanceof NetworkMonitorPlugin;
                if (bl8) {
                    NetworkMonitorPlugin networkMonitorPlugin = (NetworkMonitorPlugin)aliHaPlugin6;
                    String string = config.rsaPublicKey;
                    networkMonitorPlugin.setRsaPublishKey(string);
                }
                AliHaCore aliHaCore = AliHaCore.getInstance();
                aliHaCore.registPlugin(aliHaPlugin6);
            }
            if (bl = (list = this.plugins).contains((Object)(plugin = Plugin.olympic))) {
                AliHaPlugin aliHaPlugin;
                Plugin plugin13 = Plugin.olympic;
                AliHaPlugin aliHaPlugin7 = aliHaPlugin = PluginFactory.createPlugin(plugin13);
                AliHaCore aliHaCore = AliHaCore.getInstance();
                aliHaCore.registPlugin(aliHaPlugin7);
            }
            AliHaCore aliHaCore = AliHaCore.getInstance();
            aliHaCore.start(param);
            int n = Build.VERSION.SDK_INT;
            if (n >= 14) {
                AdapterActivityLifeCycle adapterActivityLifeCycle;
                Application application = param.application;
                AdapterActivityLifeCycle adapterActivityLifeCycle2 = adapterActivityLifeCycle;
                adapterActivityLifeCycle2();
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)adapterActivityLifeCycle2);
                break block16;
            }
            String string13 = TAG;
            string13 = "build version %s not suppert, registerActivityLifecycleCallbacks failed";
            Object[] objectArray = new Object[1];
            int n2 = Build.VERSION.SDK_INT;
            Integer n3 = n2;
            objectArray[0] = n3;
            String string14 = String.format(string13, objectArray);
            Log.w((String)string, (String)string14);
        }
        this.initAppStatus(config);
        return true;
    }

    public void openDebug(Boolean isOpen) {
        TLogService.OpenDebug(isOpen);
        APMService.openDebug(isOpen);
        NetworkMonitorPlugin.Service.openDebug(isOpen);
    }

    public void updateVersion(String newVersion) {
        CrashService.updateApppVersion(newVersion);
    }

    public void updateUserNick(String userNick) {
        CrashService.updateUserNick(userNick);
        NetworkMonitorPlugin.Service.updateUserNick(userNick);
        TLogPlugin.Service.updateUserNick(userNick);
    }

    public void updateChannel(String channel) {
        CrashService.updateChannel(channel);
    }

    public void changeHost(String hostName) {
        if (hostName != null) {
            CrashService.changeHost(hostName);
            SendService.getInstance().changeHost(hostName);
            NetworkMonitorPlugin.Service.changeHost(hostName);
        }
    }

    public void openHttp(Boolean openHttp) {
        if (openHttp != null) {
            SendService.getInstance().openHttp = openHttp;
            NetworkMonitorPlugin.Service.openHttp(openHttp);
            TLogService.openHttp(openHttp);
        }
    }

    public void openPublishEmasHa() {
        this.changeHost(mUniversalHost);
        this.changeTLogHost();
        this.changeTLogBucketName();
    }

    public void changeAppSecretKey(String appSecret) {
        if (appSecret != null) {
            SendService.getInstance().appSecret = appSecret;
        }
    }

    public void addCustomInfo(String key, String value) {
        CrashService.addCustomInfo(key, value);
        BizErrorService.addCustomInfo(key, value);
    }

    public void setErrorCallback(ErrorCallback callback) {
        CrashService.setErrorCallback(callback);
        BizErrorService.setErrorCallback(callback);
    }

    public void reportCustomError(Throwable throwable) {
        BizErrorService.sendBizError(this.context, throwable);
    }

    public void reportCrashError(Throwable throwable) {
        BizErrorService.sendCrashError(this.context, throwable);
    }

    public static class InstanceCreater {
        public static AliHaAdapter instance = new AliHaAdapter(null);
    }
}

