/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ha.adapter.plugin;

import android.content.Context;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.alibaba.ha.adapter.Plugin;
import com.alibaba.ha.bizerrorreporter.BizErrorReporter;
import com.alibaba.ha.bizerrorreporter.module.AggregationType;
import com.alibaba.ha.bizerrorreporter.module.BizErrorModule;
import com.alibaba.ha.protocol.AliHaParam;
import com.alibaba.ha.protocol.AliHaPlugin;
import com.taobao.monitor.olympic.OlympicPerformanceCompat;
import com.taobao.monitor.olympic.OlympicThreadCompat;
import com.taobao.monitor.olympic.OlympicVmCompat;
import com.taobao.monitor.olympic.ViolationError;
import com.taobao.monitor.olympic.common.ActivityManagerProxy;
import com.taobao.monitor.olympic.common.Global;
import com.taobao.monitor.olympic.logger.Logger;
import com.taobao.monitor.olympic.plugins.strictmode.ViolationSubject;
import java.util.concurrent.atomic.AtomicBoolean;

public class OlympicPlugin
implements AliHaPlugin {
    public AtomicBoolean enabling;

    public OlympicPlugin() {
        AtomicBoolean atomicBoolean;
        AtomicBoolean atomicBoolean2 = atomicBoolean;
        atomicBoolean = new AtomicBoolean(false);
        this.enabling = atomicBoolean2;
    }

    private void initOlympic(Context context, boolean async) {
        Global.instance().setContext(context);
        ActivityManagerProxy.instance((boolean)async);
        ViolationSubject.instance().setObserver(new ViolationSubject.Observer(){

            private BizErrorModule violation2BizError(ViolationError error) {
                BizErrorModule bizError = new BizErrorModule();
                bizError.businessType = error.getType();
                bizError.errorType = this.getErrorType(error.getType());
                Throwable throwable = error.getThrowable();
                String stackTrace = error.getStackTrace();
                bizError.aggregationType = throwable == null && TextUtils.isEmpty((CharSequence)stackTrace) ? AggregationType.CONTENT : AggregationType.STACK;
                bizError.exceptionId = bizError.businessType + SystemClock.uptimeMillis();
                bizError.exceptionCode = this.createKey(error);
                if (throwable == null) {
                    bizError.exceptionDetail = this.createDetail(error);
                }
                bizError.throwable = throwable;
                bizError.thread = null;
                bizError.exceptionVersion = "1.0.0";
                bizError.exceptionArg1 = "arg1";
                bizError.exceptionArg2 = "arg2";
                bizError.exceptionArg3 = "arg3";
                return bizError;
            }

            private String createKey(ViolationError error) {
                int index;
                CharSequence message = error.getExceptionMessage();
                if (message != null && (index = message.indexOf("UID")) != -1) {
                    StringBuilder stringBuilder;
                    StringBuilder stringBuilder2 = stringBuilder;
                    StringBuilder stringBuilder3 = stringBuilder2;
                    stringBuilder2();
                    int n = index - 1;
                    CharSequence charSequence = message.substring(0, n);
                    charSequence = stringBuilder3.append((String)charSequence);
                    CharSequence charSequence2 = charSequence = ((StringBuilder)charSequence).append(" UID XXXXX ");
                    charSequence = message.substring(index + 9);
                    charSequence = ((StringBuilder)charSequence2).append((String)charSequence);
                    try {
                        charSequence = ((StringBuilder)charSequence).toString();
                        message = charSequence;
                    }
                    catch (Exception exception) {
                        Exception var5 = exception;
                        Logger.throwException((Throwable)var5);
                    }
                }
                return message;
            }

            private String createDetail(ViolationError error) {
                String stackTrace = error.getStackTrace();
                String string = TextUtils.isEmpty((CharSequence)stackTrace) ? error.getMessage() : stackTrace;
                return string;
            }

            /*
             * Enabled aggressive block sorting
             */
            private int getErrorType(String type) {
                int errorType = 0;
                int n = -1;
                switch (type.hashCode()) {
                    case 2090486008: {
                        if (!type.equals("HA_MAIN_THREAD_BLOCK")) break;
                        n = 1;
                        break;
                    }
                    case 1911901300: {
                        if (!type.equals("HA_BIG_BITMAP")) break;
                        n = 3;
                        break;
                    }
                    case 1288228987: {
                        if (!type.equals("HA_MAIN_THREAD_IO")) break;
                        n = 2;
                        break;
                    }
                    case 149628974: {
                        if (!type.equals("HA_RESOURCE_LEAK")) break;
                        n = 4;
                        break;
                    }
                    case -169271245: {
                        if (!type.equals("HA_MEM_LEAK")) break;
                        n = 0;
                        break;
                    }
                    case -318327604: {
                        if (!type.equals("HA_SECURITY_GUARD")) break;
                        n = 5;
                    }
                }
                switch (n) {
                    default: {
                        return errorType;
                    }
                    case 5: {
                        return 11;
                    }
                    case 4: {
                        return 9;
                    }
                    case 3: {
                        return 7;
                    }
                    case 2: {
                        return 6;
                    }
                    case 1: {
                        return 5;
                    }
                    case 0: 
                }
                return 4;
            }

            public void onViolation(ViolationError violationError) {
                Context context = Global.instance().context();
                BizErrorModule bizError = this.violation2BizError(violationError);
                BizErrorReporter.getInstance().send(context, bizError);
            }
        });
        OlympicThreadCompat.Policy.Builder threadBuilder = new OlympicThreadCompat.Policy.Builder();
        OlympicThreadCompat.Policy.Builder builder = threadBuilder.detectCustomSlowCalls();
        builder = builder.detectNetwork();
        builder = builder.detectResourceMismatches();
        builder.detectUnbufferedIo();
        OlympicThreadCompat.setPolicy((OlympicThreadCompat.Policy)threadBuilder.build());
        OlympicVmCompat.Policy.Builder vmBuilder = new OlympicVmCompat.Policy.Builder();
        OlympicVmCompat.Policy.Builder builder2 = vmBuilder.detectNonSdkApiUsage();
        builder2 = builder2.detectContentUriWithoutPermission();
        builder2 = builder2.detectLeakedClosableObjects();
        builder2 = builder2.detectLeakedRegistrationObjects();
        builder2.detectLeakedSqlLiteObjects();
        OlympicVmCompat.setPolicy((OlympicVmCompat.Policy)vmBuilder.build());
        OlympicPerformanceCompat.Policy.Builder performanceBuilder = new OlympicPerformanceCompat.Policy.Builder();
        OlympicPerformanceCompat.Policy.Builder builder3 = performanceBuilder.detectActivityLeaked();
        builder3 = builder3.detectBadSharedPreferencesAction();
        builder3 = builder3.detectMainThreadBlocked();
        builder3 = builder3.detectMultiBindService();
        builder3 = builder3.detectMultiRegisterReceiver();
        builder3.detectOverBitmap();
        OlympicPerformanceCompat.setPerformancePolicy((OlympicPerformanceCompat.Policy)performanceBuilder.build());
    }

    public String getName() {
        return Plugin.olympic.name();
    }

    /*
     * WARNING - void declaration
     */
    public void start(AliHaParam aliHaParam) {
        block6: {
            Context context = aliHaParam.context;
            if (context == null) {
                Log.i((String)"AliHaAdapter", (String)"init olympic failed. context is null.");
                return;
            }
            AtomicBoolean atomicBoolean = this.enabling;
            boolean bl = atomicBoolean.compareAndSet(false, true);
            if (!bl) break block6;
            bl = aliHaParam.initAsync;
            try {
                this.initOlympic(context, bl);
            }
            catch (Exception exception) {
                void e;
                e = e;
                Log.i((String)"AliHaAdapter", (String)("init olympic exception. " + e.getMessage()));
            }
        }
    }
}

