/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ha.adapter.service.appstatus;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.alibaba.ha.adapter.service.appstatus.AppStatusCallbacks;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

@TargetApi(value=14)
public class AppStatusMonitor
implements Application.ActivityLifecycleCallbacks {
    public static String TAG = "AliHaAdapter.AppStatusMonitor";
    public static AppStatusMonitor s_instance = null;
    public int mActivitiesActive = 0;
    public boolean mIsInForeground = false;
    public TimerTask mApplicationStatusTimerTask;
    public Object mApplicationStatusLockObj;
    public Timer mApplicationStatusCheckTimer;
    public List<AppStatusCallbacks> mAppStatusCallbacksList;
    public Object mAppStatusCallbacksLockObj;

    public AppStatusMonitor() {
        Object object;
        LinkedList linkedList;
        Object object2;
        Object object3 = object2;
        object2 = new Object();
        this.mApplicationStatusLockObj = object3;
        this.mApplicationStatusCheckTimer = null;
        object3 = linkedList;
        linkedList = new LinkedList();
        this.mAppStatusCallbacksList = object3;
        object3 = object;
        object = new Object();
        this.mAppStatusCallbacksLockObj = object3;
    }

    public static synchronized AppStatusMonitor getInstance() {
        if (s_instance == null) {
            s_instance = new AppStatusMonitor();
        }
        return s_instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _clearApplicationStatusCheckExistingTimer() {
        Object object = this.mApplicationStatusLockObj;
        synchronized (object) {
            Timer timer = this.mApplicationStatusCheckTimer;
            if (timer != null) {
                timer = this.mApplicationStatusCheckTimer;
                timer.cancel();
                this.mApplicationStatusCheckTimer = null;
            }
            return;
        }
    }

    public static /* synthetic */ boolean access$102(AppStatusMonitor x0, boolean x1) {
        x0.mIsInForeground = x1;
        return x1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerAppStatusCallbacks(AppStatusCallbacks aCallbacks) {
        if (aCallbacks == null) return;
        Object object = this.mAppStatusCallbacksLockObj;
        synchronized (object) {
            List<AppStatusCallbacks> list = this.mAppStatusCallbacksList;
            list.add(aCallbacks);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterAppStatusCallbacks(AppStatusCallbacks aCallbacks) {
        if (aCallbacks == null) return;
        Object object = this.mAppStatusCallbacksLockObj;
        synchronized (object) {
            List<AppStatusCallbacks> list = this.mAppStatusCallbacksList;
            list.remove(aCallbacks);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        Object object = this.mAppStatusCallbacksLockObj;
        synchronized (object) {
            Object object2 = this.mAppStatusCallbacksList;
            object2 = object2.iterator();
            while (true) {
                boolean bl;
                if (!(bl = object2.hasNext())) {
                    return;
                }
                Object object3 = object2.next();
                Object lCallback = object3 = (AppStatusCallbacks)object3;
                lCallback.onActivityCreated(activity, savedInstanceState);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onActivityDestroyed(Activity activity) {
        Object object = this.mAppStatusCallbacksLockObj;
        synchronized (object) {
            Object object2 = this.mAppStatusCallbacksList;
            object2 = object2.iterator();
            while (true) {
                boolean bl;
                if (!(bl = object2.hasNext())) {
                    return;
                }
                Object object3 = object2.next();
                Object lCallback = object3 = (AppStatusCallbacks)object3;
                lCallback.onActivityDestroyed(activity);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onActivityPaused(Activity activity) {
        Object object = this.mAppStatusCallbacksLockObj;
        synchronized (object) {
            Object object2 = this.mAppStatusCallbacksList;
            object2 = object2.iterator();
            while (true) {
                boolean bl;
                if (!(bl = object2.hasNext())) {
                    return;
                }
                Object object3 = object2.next();
                Object lCallback = object3 = (AppStatusCallbacks)object3;
                lCallback.onActivityPaused(activity);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onActivityResumed(Activity activity) {
        Object object = this.mAppStatusCallbacksLockObj;
        synchronized (object) {
            Object object2 = this.mAppStatusCallbacksList;
            object2 = object2.iterator();
            while (true) {
                boolean bl;
                if (!(bl = object2.hasNext())) {
                    return;
                }
                Object object3 = object2.next();
                Object lCallback = object3 = (AppStatusCallbacks)object3;
                lCallback.onActivityResumed(activity);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        Object object = this.mAppStatusCallbacksLockObj;
        synchronized (object) {
            Object object2 = this.mAppStatusCallbacksList;
            object2 = object2.iterator();
            while (true) {
                boolean bl;
                if (!(bl = object2.hasNext())) {
                    return;
                }
                Object object3 = object2.next();
                Object lCallback = object3 = (AppStatusCallbacks)object3;
                lCallback.onActivitySaveInstanceState(activity, outState);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onActivityStarted(Activity activity) {
        this._clearApplicationStatusCheckExistingTimer();
        ++this.mActivitiesActive;
        if (!this.mIsInForeground) {
            Object object = this.mAppStatusCallbacksLockObj;
            synchronized (object) {
                boolean bl;
                Object object2 = this.mAppStatusCallbacksList;
                object2 = object2.iterator();
                while (bl = object2.hasNext()) {
                    Object object3 = object2.next();
                    Object lCallback = object3 = (AppStatusCallbacks)object3;
                    lCallback.onSwitchForeground();
                }
            }
        }
        this.mIsInForeground = true;
    }

    public void onActivityStopped(Activity activity) {
        if (--this.mActivitiesActive == 0) {
            Timer timer;
            NotInForegroundTimerTask notInForegroundTimerTask;
            this._clearApplicationStatusCheckExistingTimer();
            Object object = notInForegroundTimerTask;
            notInForegroundTimerTask = new NotInForegroundTimerTask(null);
            this.mApplicationStatusTimerTask = object;
            this.mApplicationStatusCheckTimer = object = timer;
            new Timer().schedule(this.mApplicationStatusTimerTask, 1000L);
        }
    }

    public class NotInForegroundTimerTask
    extends TimerTask {
        public NotInForegroundTimerTask() {
        }

        public /* synthetic */ NotInForegroundTimerTask(1 x1) {
            this();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            AppStatusMonitor.access$102(AppStatusMonitor.this, false);
            Object object = AppStatusMonitor.this.mAppStatusCallbacksLockObj;
            synchronized (object) {
                Iterator iterator = AppStatusMonitor.this;
                iterator = ((AppStatusMonitor)((Object)iterator)).mAppStatusCallbacksList;
                iterator = iterator.iterator();
                while (true) {
                    void lCallback;
                    boolean bl;
                    if (!(bl = iterator.hasNext())) {
                        return;
                    }
                    Object object2 = iterator.next();
                    object2 = (AppStatusCallbacks)object2;
                    lCallback.onSwitchBackground();
                }
            }
        }
    }
}

