/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.Process;
import android.os.SystemClock;
import android.text.TextUtils;
import com.ali.alihadeviceevaluator.AliHAHardware;
import com.taobao.application.common.data.DeviceHelper;
import com.taobao.application.common.data.c;
import com.taobao.monitor.impl.common.DynamicConstants;
import com.taobao.monitor.impl.common.Global;
import com.taobao.monitor.impl.data.GlobalStats;
import com.taobao.monitor.impl.processor.fragmentload.a;
import com.taobao.monitor.impl.trace.b;
import com.taobao.monitor.impl.trace.c;
import com.taobao.monitor.impl.trace.d;
import com.taobao.monitor.impl.trace.e;
import com.taobao.monitor.impl.trace.f;
import com.taobao.monitor.impl.trace.g;
import com.taobao.monitor.impl.trace.i;
import com.taobao.monitor.impl.trace.l;
import com.taobao.monitor.impl.trace.m;
import com.taobao.monitor.impl.trace.n;
import com.taobao.monitor.impl.trace.o;
import com.taobao.monitor.impl.util.TimeUtils;
import com.taobao.monitor.performance.APMAdapterFactoryProxy;
import com.taobao.monitor.performance.IApmAdapterFactory;
import com.taobao.network.lifecycle.IMtopLifecycle;
import com.taobao.network.lifecycle.INetworkLifecycle;
import com.taobao.network.lifecycle.MtopLifecycleManager;
import com.taobao.network.lifecycle.NetworkLifecycleManager;
import com.taobao.phenix.lifecycle.IPhenixLifeCycle;
import com.taobao.phenix.lifecycle.PhenixLifeCycleManager;
import java.util.Map;

public class APMLauncher {
    private static final String TAG = "APMLauncher";
    private static boolean init = false;
    private static final com.taobao.application.common.data.c launchHelper = new com.taobao.application.common.data.c();

    private APMLauncher() {
    }

    public static void init(Application application, Map<String, Object> map) {
        if (!init) {
            init = true;
            APMLauncher.initParams(application, map);
            APMLauncher.initHotCold();
            APMLauncher.initDispatcher();
            APMLauncher.firstAsyncMessage();
            APMLauncher.initLifecycle(application);
            APMLauncher.initApmImpl();
        }
    }

    private static void initParams(Application application, Map<String, Object> map) {
        GlobalStats.launchStartTime = TimeUtils.currentTimeMillis();
        launchHelper.a("COLD");
        launchHelper.e(SystemClock.uptimeMillis());
        launchHelper.d(System.currentTimeMillis());
        if (map != null) {
            GlobalStats.appVersion = com.taobao.monitor.impl.util.e.a(map.get("appVersion"), "unknown");
        }
        Global.instance().setContext((Context)application);
        Context context = Global.instance().context();
        SharedPreferences sharedPreferences = context.getSharedPreferences("apm", 0);
        String string = sharedPreferences.getString("appVersion", "");
        SharedPreferences.Editor editor = sharedPreferences.edit();
        boolean bl = false;
        if (TextUtils.isEmpty((CharSequence)string)) {
            GlobalStats.isFirstInstall = true;
            GlobalStats.isFirstLaunch = true;
            GlobalStats.installType = "NEW";
            editor.putString("appVersion", GlobalStats.appVersion);
            bl = true;
        } else {
            GlobalStats.isFirstInstall = false;
            GlobalStats.isFirstLaunch = !string.equals(GlobalStats.appVersion);
            GlobalStats.installType = "UPDATE";
            if (GlobalStats.isFirstLaunch) {
                editor.putString("appVersion", GlobalStats.appVersion);
                bl = true;
            }
        }
        GlobalStats.lastTopActivity = sharedPreferences.getString("LAST_TOP_ACTIVITY", "");
        if (!TextUtils.isEmpty((CharSequence)GlobalStats.lastTopActivity)) {
            editor.putString("LAST_TOP_ACTIVITY", "");
            bl = true;
        }
        if (bl) {
            editor.apply();
        }
        GlobalStats.lastProcessStartTime = c.a.a();
        launchHelper.b(GlobalStats.isFirstLaunch);
        launchHelper.a(GlobalStats.isFirstInstall);
        launchHelper.a(GlobalStats.lastProcessStartTime);
        DeviceHelper deviceHelper = new DeviceHelper();
        deviceHelper.setMobileModel(Build.MODEL);
    }

    private static void initHotCold() {
        Global.instance().handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                Looper.getMainLooper();
                Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

                    public boolean queueIdle() {
                        if (GlobalStats.createdPageCount == 0) {
                            com.taobao.monitor.impl.processor.launcher.b.d = "HOT";
                            com.taobao.monitor.impl.processor.launcher.b.v = true;
                            launchHelper.a("HOT");
                        }
                        return false;
                    }
                });
            }
        }, 3000L);
    }

    private static void initLifecycle(Application application) {
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new com.taobao.monitor.impl.data.a.b());
    }

    private static void initWeex() {
        if (DynamicConstants.needWeex) {
            APMAdapterFactoryProxy.instance().setFactory((IApmAdapterFactory)new com.taobao.monitor.impl.processor.a.a());
        }
    }

    private static void initHookActivityManager() {
        if (Build.VERSION.SDK_INT <= 28) {
            APMLauncher.runInMain(new Runnable(){

                @Override
                public void run() {
                    com.taobao.monitor.impl.common.b.start();
                }
            });
        }
    }

    private static void runInMain(Runnable runnable) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(runnable);
        }
    }

    private static void initProcessStartTime() {
        if (Build.VERSION.SDK_INT >= 24) {
            GlobalStats.processStartTime = TimeUtils.currentTimeMillis() + Process.getStartUptimeMillis() - SystemClock.uptimeMillis();
            launchHelper.b(System.currentTimeMillis() - (SystemClock.uptimeMillis() - GlobalStats.processStartTime));
        } else {
            long l2 = com.taobao.monitor.impl.util.d.b();
            launchHelper.b(l2);
            GlobalStats.processStartTime = l2 != -1L ? TimeUtils.currentTimeMillis() - (System.currentTimeMillis() - l2) : TimeUtils.currentTimeMillis() - Process.getElapsedCpuTime();
        }
        launchHelper.c(GlobalStats.processStartTime);
    }

    private static void initOppoCPUResource() {
        String string;
        GlobalStats.oppoCPUResource = string = System.getProperty("oppoCPUResource", "false");
    }

    private static void firstAsyncMessage() {
        Global.instance().handler().post(new Runnable(){

            @Override
            public void run() {
                APMLauncher.initOppoCPUResource();
                APMLauncher.initExecutor();
                APMLauncher.initWeex();
                APMLauncher.initProcessStartTime();
                DeviceHelper deviceHelper = new DeviceHelper();
                deviceHelper.setDeviceLevel(AliHAHardware.getInstance().getOutlineInfo().deviceLevel);
                deviceHelper.setCpuScore(AliHAHardware.getInstance().getCpuInfo().deviceLevel);
                deviceHelper.setMemScore(AliHAHardware.getInstance().getMemoryInfo().deviceLevel);
            }
        });
    }

    private static void initDispatcher() {
        g.a("APPLICATION_LOW_MEMORY_DISPATCHER", new f());
        g.a("APPLICATION_GC_DISPATCHER", new e());
        d d2 = new d();
        g.a("APPLICATION_BACKGROUND_CHANGED_DISPATCHER", d2);
        g.a("ACTIVITY_FPS_DISPATCHER", new i());
        c c2 = new c();
        c2.addListener(new com.taobao.monitor.impl.processor.pageload.e());
        c2.addListener(new com.taobao.monitor.impl.processor.launcher.a());
        g.a("ACTIVITY_LIFECYCLE_DISPATCHER", c2);
        g.a("ACTIVITY_EVENT_DISPATCHER", new b());
        g.a("ACTIVITY_USABLE_VISIBLE_DISPATCHER", new o());
        l l2 = new l();
        l2.addListener(new a());
        g.a("FRAGMENT_LIFECYCLE_DISPATCHER", l2);
        g.a("FRAGMENT_USABLE_VISIBLE_DISPATCHER", new o());
        g.a("IMAGE_STAGE_DISPATCHER", new m());
        PhenixLifeCycleManager.instance().addLifeCycle((IPhenixLifeCycle)new com.taobao.monitor.impl.data.d.a());
        g.a("NETWORK_STAGE_DISPATCHER", new n());
        NetworkLifecycleManager.instance().setLifecycle((INetworkLifecycle)new com.taobao.monitor.impl.data.e.a());
        MtopLifecycleManager.instance().setLifecycle((IMtopLifecycle)new com.taobao.monitor.impl.data.e.a());
    }

    private static void initExecutor() {
        com.taobao.monitor.impl.data.c.a a2 = new com.taobao.monitor.impl.data.c.a();
        a2.execute();
    }

    private static void initApmImpl() {
        com.taobao.application.common.a.a();
    }
}

