/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.impl.logger;

import android.util.Log;

public class Logger {
    private static final String TAG = "APMLogger";
    private static boolean isDebug = false;

    private Logger() {
    }

    public static boolean isDebug() {
        return isDebug;
    }

    public static void setDebug(boolean bl) {
        isDebug = bl;
    }

    public static void i(String string, Object ... objectArray) {
        if (isDebug) {
            String string2 = Logger.format2String(objectArray);
            Log.i((String)TAG, (String)(string + ":" + string2));
        }
    }

    public static void d(String string, Object ... objectArray) {
        if (isDebug) {
            String string2 = Logger.format2String(objectArray);
            Log.d((String)TAG, (String)(string + ":" + string2));
        }
    }

    public static void e(String string, Object ... objectArray) {
        String string2 = Logger.format2String(objectArray);
        Log.e((String)TAG, (String)(string + ":" + string2));
    }

    public static void w(String string, Object ... objectArray) {
        if (isDebug) {
            String string2 = Logger.format2String(objectArray);
            Log.w((String)TAG, (String)(string + ":" + string2));
        }
    }

    public static void throwException(Throwable throwable) {
        if (isDebug) {
            throw new RuntimeException(throwable);
        }
    }

    private static String format2String(Object ... objectArray) {
        if (objectArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object : objectArray) {
                if (object == null) continue;
                stringBuilder.append("->").append(object.toString());
            }
            return stringBuilder.toString();
        }
        return "";
    }
}

