/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ha.bizerrorreporter;

import android.content.Context;
import android.util.Log;
import com.alibaba.ha.bizerrorreporter.BizErrorSampling;
import com.alibaba.ha.bizerrorreporter.module.BizErrorModule;
import com.alibaba.ha.bizerrorreporter.send.BizErrorThreadPool;
import com.alibaba.ha.bizerrorreporter.send.Sender;
import com.alibaba.ha.protocol.crash.ErrorCallback;
import com.alibaba.motu.tbrest.SendService;
import com.alibaba.motu.tbrest.utils.AppUtils;
import com.alibaba.motu.tbrest.utils.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BizErrorReporter {
    private BizErrorThreadPool threadPool = new BizErrorThreadPool();
    public Long reporterStartTime = System.currentTimeMillis();
    public String processName = null;
    public BizErrorSampling sampling = null;
    private ErrorCallback mErrorCallback;
    private ConcurrentHashMap<String, String> mCustomInfo = new ConcurrentHashMap();

    private BizErrorReporter() {
    }

    public static synchronized BizErrorReporter getInstance() {
        return a.a;
    }

    public void send(Context context, BizErrorModule bizErrorModule) {
        try {
            if (SendService.getInstance().context == null || SendService.getInstance().appKey == null) {
                Log.e((String)"MotuCrashAdapter", (String)"you need init rest send service");
                return;
            }
            if (bizErrorModule != null) {
                Sender sender = new Sender(context, bizErrorModule);
                this.threadPool.submit(sender);
            }
        }
        catch (Exception exception) {
            Log.e((String)"MotuCrashAdapter", (String)"adapter err", (Throwable)exception);
        }
    }

    public String getProcessName(Context context) {
        if (this.processName != null) {
            return this.processName;
        }
        String string = AppUtils.getMyProcessNameByCmdline();
        if (StringUtils.isBlank((CharSequence)string)) {
            string = AppUtils.getMyProcessNameByAppProcessInfo((Context)context);
        }
        this.processName = string;
        return string;
    }

    public void openSampling(BizErrorSampling bizErrorSampling) {
        this.sampling = bizErrorSampling;
    }

    public void addCustomInfo(String string, String string2) {
        this.mCustomInfo.put(string, string2);
    }

    Map<String, String> getCustomInfo() {
        return this.mCustomInfo;
    }

    public void setErrorCallback(ErrorCallback errorCallback) {
        this.mErrorCallback = errorCallback;
    }

    ErrorCallback getErrorCallback() {
        return this.mErrorCallback;
    }

    private static class a {
        private static BizErrorReporter a = new BizErrorReporter();
    }
}

