/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ha.bizerrorreporter.send;

import android.content.Context;
import android.util.Log;
import com.alibaba.ha.bizerrorreporter.BizErrorReporter;
import com.alibaba.ha.bizerrorreporter.BizErrorSampling;
import com.alibaba.ha.bizerrorreporter.a;
import com.alibaba.ha.bizerrorreporter.module.BizErrorModule;
import com.alibaba.ha.bizerrorreporter.module.SendModule;
import com.alibaba.motu.tbrest.SendService;

public class Sender
implements Runnable {
    Context mContext;
    BizErrorModule bizErrorModule;

    public Sender(Context context, BizErrorModule bizErrorModule) {
        this.mContext = context;
        this.bizErrorModule = bizErrorModule;
    }

    @Override
    public void run() {
        try {
            String string = this.bizErrorModule.businessType;
            if (string == null) {
                Log.i((String)"MotuCrashAdapter", (String)"business type cannot null");
                return;
            }
            if (BizErrorReporter.getInstance().sampling != null && !this.canSend().booleanValue()) {
                return;
            }
            a a2 = new a();
            SendModule sendModule = a2.a(this.mContext, this.bizErrorModule);
            if (sendModule != null) {
                Integer n = sendModule.eventId;
                String string2 = sendModule.sendFlag;
                String string3 = sendModule.sendContent;
                String string4 = sendModule.businessType;
                String string5 = sendModule.aggregationType;
                Log.d((String)"MotuCrashAdapter", (String)("start send error log. appkey: " + SendService.getInstance().appKey + ", error type: " + this.bizErrorModule.businessType));
                boolean bl = SendService.getInstance().sendRequest(null, System.currentTimeMillis(), string4, n.intValue(), (Object)string2, (Object)string3, (Object)string5, null);
                Log.d((String)"MotuCrashAdapter", (String)("send error log " + (bl ? "success" : "failed") + ". appkey: " + SendService.getInstance().appKey + ", error type: " + this.bizErrorModule.businessType));
            }
        }
        catch (Exception exception) {
            Log.e((String)"MotuCrashAdapter", (String)"send business err happen ", (Throwable)exception);
        }
    }

    private Boolean canSend() {
        BizErrorSampling bizErrorSampling = BizErrorReporter.getInstance().sampling;
        int n = this.getRandomNumber(0, 10000);
        if (bizErrorSampling == BizErrorSampling.OneTenth) {
            if (n >= 0 && n < 1000) {
                return true;
            }
        } else if (bizErrorSampling == BizErrorSampling.OnePercent) {
            if (n >= 0 && n < 100) {
                return true;
            }
        } else if (bizErrorSampling == BizErrorSampling.OneThousandth) {
            if (n >= 0 && n < 10) {
                return true;
            }
        } else if (bizErrorSampling == BizErrorSampling.OneTenThousandth) {
            if (n >= 0 && n < 1) {
                return true;
            }
        } else {
            if (bizErrorSampling == BizErrorSampling.Zero) {
                return false;
            }
            if (bizErrorSampling == BizErrorSampling.All) {
                return true;
            }
        }
        return false;
    }

    private int getRandomNumber(int n, int n2) {
        try {
            return n + (int)(Math.random() * (double)(n2 - n + 1));
        }
        catch (Exception exception) {
            Log.e((String)"MotuCrashAdapter", (String)"get random number err", (Throwable)exception);
            return 0;
        }
    }
}

