/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.taobao.monitor.olympic.OlympicPerformanceCompat;
import com.taobao.monitor.olympic.OlympicThreadCompat;
import com.taobao.monitor.olympic.OlympicVmCompat;
import com.taobao.monitor.olympic.common.Global;
import com.taobao.monitor.olympic.common.Switcher;
import com.taobao.monitor.olympic.logger.Logger;
import com.taobao.monitor.olympic.plugins.block.MessageLooperPluginImpl;
import com.taobao.monitor.olympic.plugins.critical.TransactionTooLargePlugin;
import com.taobao.monitor.olympic.plugins.strictmode.ViolationSubject;
import com.taobao.monitor.olympic.sender.TBSender;
import com.taobao.monitor.olympic.utils.DebugUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class OlympicLauncher
implements Runnable {
    private static final String TAG = "OlympicLauncher";
    private final Application mApplication;
    private final Map<String, Object> mParams;

    public OlympicLauncher(Application application, Map<String, Object> params) {
        if (application == null || params == null) {
            throw new IllegalArgumentException("application or params must not null!");
        }
        this.mApplication = application;
        this.mParams = params;
    }

    @Override
    public void run() {
        Global.instance().setContext((Context)this.mApplication);
        if (Build.VERSION.SDK_INT >= 23) {
            this.initSwitcher();
            Log.e((String)TAG, (String)"Init Start");
            if (Build.VERSION.SDK_INT >= 26 && Build.VERSION.SDK_INT <= 28) {
                TransactionTooLargePlugin plugin = new TransactionTooLargePlugin();
                plugin.execute();
            }
            if (this.condition()) {
                Global.instance().initAppLifecycle();
                this.initParams();
                this.initOlympicCore();
                this.initSender();
                this.initMessageLooper();
                Log.e((String)TAG, (String)"Init Success");
            }
        }
    }

    private void initMessageLooper() {
        File tokenFile = new File("/data/local/tmp/.olympic_message_looper_hook");
        if (tokenFile.exists()) {
            new MessageLooperPluginImpl().execute();
        }
    }

    private void initSwitcher() {
        SharedPreferences sp = this.mApplication.getSharedPreferences("olympic", 0);
        try {
            Map data = sp.getAll();
            Switcher.update(data);
        }
        catch (Exception e) {
            Logger.throwException(e);
        }
    }

    private boolean condition() {
        Random random = new Random();
        float sample = this.getSample();
        Logger.e(TAG, Float.valueOf(sample));
        return random.nextFloat() < Switcher.value("OlympicSample", sample);
    }

    private float getSample() {
        if (this.valueOf("isDebuggable", false).booleanValue() && DebugUtils.isDebugPackage()) {
            return 1.0f;
        }
        String appVersion = this.valueOf("appVersion", "1.0.0.0");
        String[] splits = appVersion.split("\\.");
        if (splits.length > 3) {
            if (splits[3].length() > 3) {
                return 1.0f;
            }
            return Switcher.value("GrayScaleExperiment", 0.005f);
        }
        return Switcher.value("Release", 0.0f);
    }

    private void initParams() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isDebuggable = this.valueOf("isDebuggable", false);
        map.put("isDebuggable", String.valueOf(isDebuggable));
        Switcher.update(map);
        Logger.setDebug(DebugUtils.isDebuggable());
    }

    private void initOlympicCore() {
        if (Switcher.value("Performance", true)) {
            OlympicPerformanceCompat.Policy.Builder performanceBuilder = new OlympicPerformanceCompat.Policy.Builder();
            OlympicPerformanceCompat.setPerformancePolicy(performanceBuilder.detectAll().build());
        }
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            OlympicThreadCompat.Policy.Builder threadBuilder = new OlympicThreadCompat.Policy.Builder();
            OlympicThreadCompat.setPolicy(threadBuilder.detectAll().build());
        } else {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    OlympicThreadCompat.Policy.Builder threadBuilder = new OlympicThreadCompat.Policy.Builder();
                    OlympicThreadCompat.setPolicy(threadBuilder.detectAll().build());
                }
            });
        }
        OlympicVmCompat.Policy.Builder vmBuilder = new OlympicVmCompat.Policy.Builder();
        vmBuilder.detectNonSdkApiUsage().detectContentUriWithoutPermission().detectLeakedClosableObjects().detectLeakedRegistrationObjects().detectLeakedSqlLiteObjects();
        OlympicVmCompat.setPolicy(vmBuilder.build());
    }

    private void initSender() {
        ViolationSubject.instance().setExecutor(Global.instance().executor());
        ViolationSubject.instance().setObserver(new TBSender());
    }

    private <T> T valueOf(String name, T def) {
        Object o = this.mParams.get(name);
        if (o != null) {
            try {
                return (T)o;
            }
            catch (Exception e) {
                Logger.throwException(e);
            }
        }
        return def;
    }
}

