/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.taobao.monitor.olympic.common.Global;
import com.taobao.monitor.olympic.common.Switcher;
import com.taobao.monitor.olympic.logger.Logger;
import com.taobao.orange.OConfigListener;
import com.taobao.orange.OrangeConfig;
import java.util.Map;

public class OlympicOrangeLauncher {
    private static final String TAG = "OlympicOrangeLauncher";
    private static final String ORANGE_NAMESPACE = "Olympic";

    public void init() {
        if (Build.VERSION.SDK_INT >= 23) {
            OrangeConfig.getInstance().getConfigs(ORANGE_NAMESPACE);
            OrangeConfig.getInstance().registerListener(new String[]{ORANGE_NAMESPACE}, (OConfigListener)new OrangeListener(), true);
        }
    }

    private static class OrangeListener
    implements OConfigListener {
        private OrangeListener() {
        }

        public void onConfigUpdate(String s, Map<String, String> map) {
            Map map2 = OrangeConfig.getInstance().getConfigs(OlympicOrangeLauncher.ORANGE_NAMESPACE);
            if (map2 != null && map2.size() > 0) {
                this.onUpdate(map2);
            }
        }

        private void onUpdate(Map<String, String> map) {
            try {
                Switcher.update(map);
            }
            catch (ClassCastException e) {
                Logger.throwException(e);
            }
            Context context = Global.instance().context();
            SharedPreferences sp = context.getSharedPreferences("olympic", 0);
            SharedPreferences.Editor editor = sp.edit();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                try {
                    editor.putString(entry.getKey(), (String)entry.getValue());
                }
                catch (Exception e) {
                    Logger.throwException(e);
                }
            }
            editor.apply();
        }
    }
}

