/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic;

import android.support.annotation.NonNull;
import android.util.Log;
import com.taobao.monitor.olympic.OlympicPerformanceMode;
import java.util.Locale;

public class OlympicPerformanceCompat {
    private static final String TAG = "OlympicPerfCompat";
    private static final String FEATURE_NOT_SUPPORTED_MSG = "%s:%s is not supported";

    public static void setPerformancePolicy(@NonNull Policy policy) {
        OlympicPerformanceMode.setPerformancePolicy(policy.mPolicy);
    }

    private static void logUnsupportedFeature(@NonNull String category, @NonNull String feature) {
        Log.d((String)TAG, (String)String.format(Locale.US, FEATURE_NOT_SUPPORTED_MSG, category, feature));
    }

    public static class Policy {
        private final OlympicPerformanceMode.PerformancePolicy mPolicy;

        public Policy(OlympicPerformanceMode.PerformancePolicy policy) {
            this.mPolicy = policy;
        }

        public static final class Builder {
            OlympicPerformanceMode.PerformancePolicy.Builder mBuilder;

            public Builder() {
                this.mBuilder = new OlympicPerformanceMode.PerformancePolicy.Builder();
            }

            public Builder(OlympicPerformanceMode.PerformancePolicy policy) {
                this.mBuilder = new OlympicPerformanceMode.PerformancePolicy.Builder(policy);
            }

            public Builder detectOverBitmap() {
                this.mBuilder.detectOverBitmap();
                return this;
            }

            public Builder permitOverBitmap() {
                this.mBuilder.permitOverBitmap();
                return this;
            }

            public Builder detectHoldBitmap() {
                this.mBuilder.detectHoldBitmap();
                return this;
            }

            public Builder permitHoldBitmap() {
                this.mBuilder.permitHoldBitmap();
                return this;
            }

            public Builder detectBadSharedPreferencesHost() {
                this.mBuilder.detectBadSharedPreferencesHost();
                return this;
            }

            public Builder permitBadSharedPreferencesHost() {
                this.mBuilder.permitBadSharedPreferencesHost();
                return this;
            }

            public Builder detectBadSharedPreferencesAction() {
                this.mBuilder.detectBadSharedPreferencesAction();
                return this;
            }

            public Builder permitBadSharedPreferencesAction() {
                this.mBuilder.permitBadSharedPreferencesAction();
                return this;
            }

            public Builder detectActivityLeaked() {
                this.mBuilder.detectActivityLeaked();
                return this;
            }

            public Builder permitActivityLeaked() {
                this.mBuilder.permitActivityLeaked();
                return this;
            }

            public Builder detectMultiRegisterReceiver() {
                this.mBuilder.detectMultiRegisterReceiver();
                return this;
            }

            public Builder permitMultiRegisterReceiver() {
                this.mBuilder.permitMultiRegisterReceiver();
                return this;
            }

            public Builder detectMultiBindService() {
                this.mBuilder.detectMultiBindService();
                return this;
            }

            public Builder permitMultiBindService() {
                this.mBuilder.permitMultiBindService();
                return this;
            }

            public Builder detectMainThreadBlocked() {
                this.mBuilder.detectMainThreadBlocked();
                return this;
            }

            public Builder permitMainThreadBlocked() {
                this.mBuilder.permitMainThreadBlocked();
                return this;
            }

            public Builder detectAll() {
                this.mBuilder.detectAll();
                return this;
            }

            public Builder permitAll() {
                this.mBuilder.permitAll();
                return this;
            }

            public Builder penaltyDeath() {
                this.mBuilder.penaltyDeath();
                return this;
            }

            public Builder penaltyFlashScreen() {
                this.mBuilder.penaltyFlashScreen();
                return this;
            }

            public Builder penaltyLog() {
                this.mBuilder.penaltyLog();
                return this;
            }

            public Policy build() {
                return new Policy(this.mBuilder.build());
            }
        }
    }
}

