/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic;

import android.util.Log;
import com.taobao.monitor.olympic.ViolationError;
import com.taobao.monitor.olympic.plugins.bitmap.BitmapHolderPluginImpl;
import com.taobao.monitor.olympic.plugins.bitmap.OverBitmapPluginImpl;
import com.taobao.monitor.olympic.plugins.block.MainBlockedPluginImpl;
import com.taobao.monitor.olympic.plugins.memleak.ActivityLeakedPluginImpl;
import com.taobao.monitor.olympic.plugins.memleak.MultiReceiverPluginImpl;
import com.taobao.monitor.olympic.plugins.memleak.MultiServicePluginImpl;
import com.taobao.monitor.olympic.plugins.preferences.SharedPreferencesPluginImpl;
import com.taobao.monitor.olympic.plugins.strictmode.ViolationSubject;
import com.taobao.monitor.olympic.utils.ObjectInvoker;

public class OlympicPerformanceMode {
    private static final String TAG = "OlympicPerformanceMode";
    private static final int DETECT_OVER_BITMAP = 1;
    private static final int DETECT_HOLD_BITMAP = 2;
    private static final int DETECT_ACTIVITY_LEAKED = 4;
    private static final int DETECT_MULTI_REGISTER_RECEIVER = 8;
    private static final int DETECT_MULTI_BIND_SERVICE = 16;
    private static final int DETECT_MAIN_THREAD_BLOCKED = 32;
    private static final int DETECT_BAD_SP_HOST = 64;
    private static final int DETECT_BAD_SP_ACTION = 128;
    private static final int ALL_PERFORMANCE_DETECT_BITS = 255;
    private static final int PENALTY_LOG = 65536;
    private static final int PENALTY_DIALOG = 131072;
    private static final int PENALTY_DEATH = 262144;
    private static final int PENALTY_FLASH = 0x100000;
    private static PerformancePolicy sPerformancePolicy = PerformancePolicy.access$000();

    public static boolean detectOverBitmapEnabled() {
        return (sPerformancePolicy.mask & 1) != 0;
    }

    public static void onOverBitmap(ViolationError error) {
        OlympicPerformanceMode.startHandlingViolationError(error);
    }

    public static boolean detectHoldBitmapEnabled() {
        return (sPerformancePolicy.mask & 2) != 0;
    }

    public static void onHoldBitmap(ViolationError error) {
        OlympicPerformanceMode.startHandlingViolationError(error);
    }

    public static boolean detectBadSharedPreferencesHostEnabled() {
        return (sPerformancePolicy.mask & 0x40) != 0;
    }

    public static boolean detectBadSharedPreferencesActionEnabled() {
        return (sPerformancePolicy.mask & 0x80) != 0;
    }

    public static void onBadSharedPreferencesHost(ViolationError error) {
        OlympicPerformanceMode.startHandlingViolationError(error);
    }

    public static void onBadSharedPreferencesAction(ViolationError error) {
        OlympicPerformanceMode.startHandlingViolationError(error);
    }

    public static boolean detectActivityLeakedEnabled() {
        return (sPerformancePolicy.mask & 4) != 0;
    }

    public static void onActivityLeaked(ViolationError error) {
        OlympicPerformanceMode.startHandlingViolationError(error);
    }

    public static boolean detectMultiRegisterReceiverEnabled() {
        return (sPerformancePolicy.mask & 8) != 0;
    }

    public static void onMultiRegisterReceiver(ViolationError error) {
        OlympicPerformanceMode.startHandlingViolationError(error);
    }

    public static boolean detectMultiBindServiceEnabled() {
        return (sPerformancePolicy.mask & 0x10) != 0;
    }

    public static void onMultiBindService(ViolationError error) {
        OlympicPerformanceMode.startHandlingViolationError(error);
    }

    public static boolean detectMainThreadBlockedEnabled() {
        return (sPerformancePolicy.mask & 0x20) != 0;
    }

    public static void onMainThreadBlocked(ViolationError error) {
        OlympicPerformanceMode.startHandlingViolationError(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPerformancePolicy(PerformancePolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Policy must not null");
        }
        sPerformancePolicy = policy;
        Class<OlympicPerformanceMode> clazz = OlympicPerformanceMode.class;
        synchronized (OlympicPerformanceMode.class) {
            if (OlympicPerformanceMode.enabled(1)) {
                new OverBitmapPluginImpl().execute();
            }
            if (OlympicPerformanceMode.enabled(2)) {
                new BitmapHolderPluginImpl().execute();
            }
            if (OlympicPerformanceMode.enabled(64)) {
                new SharedPreferencesPluginImpl().execute();
            }
            if (OlympicPerformanceMode.enabled(4)) {
                new ActivityLeakedPluginImpl().execute();
            }
            if (OlympicPerformanceMode.enabled(8)) {
                new MultiReceiverPluginImpl().execute();
            }
            if (OlympicPerformanceMode.enabled(16)) {
                new MultiServicePluginImpl().execute();
            }
            if (OlympicPerformanceMode.enabled(32)) {
                new MainBlockedPluginImpl().execute();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static PerformancePolicy getPerformancePolicy() {
        return sPerformancePolicy;
    }

    private static void startHandlingViolationError(ViolationError error) {
        ViolationSubject.instance().notifyViolation(error);
        if (OlympicPerformanceMode.enabled(65536)) {
            OlympicPerformanceMode.penalty2Log(error);
        }
        if (OlympicPerformanceMode.enabled(0x100000)) {
            OlympicPerformanceMode.penalty2Flash();
        }
        if (OlympicPerformanceMode.enabled(262144)) {
            OlympicPerformanceMode.penalty2Death(error);
        }
    }

    private static void penalty2Log(ViolationError error) {
        Log.d((String)TAG, (String)error.toString());
    }

    private static void penalty2Death(ViolationError error) {
        Throwable throwable = error.getThrowable();
        if (throwable == null) {
            throw new RuntimeException(error.getMessage());
        }
        throw new RuntimeException(throwable);
    }

    private static void penalty2Flash() {
        try {
            if (WindowManagerHolder.sWindowManagerInvoker != null) {
                WindowManagerHolder.sWindowManagerInvoker.invoke("showStrictModeViolation", true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean enabled(int token) {
        return (sPerformancePolicy.mask & token) != 0;
    }

    private static class WindowManagerHolder {
        private static final ObjectInvoker sWindowManagerInvoker;

        private WindowManagerHolder() {
        }

        static {
            ObjectInvoker temp = null;
            try {
                Class<?> serviceManagerClass = Class.forName("android.os.ServiceManager");
                ObjectInvoker serviceManagerInvoker = ObjectInvoker.wrap(serviceManagerClass);
                temp = serviceManagerInvoker.invoke("getSystemService", "window");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                sWindowManagerInvoker = temp;
            }
        }
    }

    public static class PerformancePolicy {
        private static final PerformancePolicy LAX = new PerformancePolicy(0);
        private final int mask;

        private PerformancePolicy(int mask) {
            this.mask = mask;
        }

        static /* synthetic */ PerformancePolicy access$000() {
            return LAX;
        }

        public static class Builder {
            private int mMask = 0;

            public Builder() {
            }

            public Builder(PerformancePolicy policy) {
                this.mMask = policy.mask;
            }

            public Builder detectOverBitmap() {
                this.enable(1);
                return this;
            }

            public Builder permitOverBitmap() {
                this.disable(1);
                return this;
            }

            public Builder detectHoldBitmap() {
                this.enable(2);
                return this;
            }

            public Builder permitHoldBitmap() {
                this.disable(2);
                return this;
            }

            public Builder detectBadSharedPreferencesHost() {
                this.enable(64);
                return this;
            }

            public Builder permitBadSharedPreferencesHost() {
                this.disable(64);
                return this;
            }

            public Builder detectBadSharedPreferencesAction() {
                this.enable(128);
                return this;
            }

            public Builder permitBadSharedPreferencesAction() {
                this.disable(128);
                return this;
            }

            public Builder detectActivityLeaked() {
                this.enable(4);
                return this;
            }

            public Builder permitActivityLeaked() {
                this.disable(4);
                return this;
            }

            public Builder detectMultiRegisterReceiver() {
                this.enable(8);
                return this;
            }

            public Builder permitMultiRegisterReceiver() {
                this.disable(8);
                return this;
            }

            public Builder detectMultiBindService() {
                this.enable(16);
                return this;
            }

            public Builder permitMultiBindService() {
                this.disable(16);
                return this;
            }

            public Builder detectMainThreadBlocked() {
                this.enable(32);
                return this;
            }

            public Builder permitMainThreadBlocked() {
                this.disable(32);
                return this;
            }

            public Builder detectAll() {
                this.enable(255);
                return this;
            }

            public Builder permitAll() {
                this.disable(255);
                return this;
            }

            public Builder penaltyDeath() {
                return this.enable(262144);
            }

            public Builder penaltyFlashScreen() {
                return this.enable(0x100000);
            }

            public Builder penaltyLog() {
                return this.enable(65536);
            }

            private Builder enable(int bit) {
                this.mMask |= bit;
                return this;
            }

            private Builder disable(int bit) {
                this.mMask &= ~bit;
                return this;
            }

            public PerformancePolicy build() {
                return new PerformancePolicy(this.mMask);
            }
        }
    }
}

