/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.monitor.olympic;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.StrictMode;
import android.os.strictmode.Violation;
import android.support.annotation.NonNull;
import android.util.Log;
import com.taobao.monitor.olympic.common.Global;
import com.taobao.monitor.olympic.logger.Logger;
import com.taobao.monitor.olympic.plugins.strictmode.ViolationSubject;
import com.taobao.monitor.olympic.plugins.strictmode.tranfer.ViolationTransfer28;
import java.util.Locale;

public final class OlympicThreadCompat {
    private static final String TAG = "OlympicThreadCompat";
    private static final String FEATURE_NOT_SUPPORTED_MSG = "%s:%s is not supported";

    private OlympicThreadCompat() {
    }

    public static void setPolicy(@NonNull Policy policy) {
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)policy.mThreadPolicy);
    }

    private static void logUnsupportedFeature(@NonNull String category, @NonNull String feature) {
        Log.d((String)TAG, (String)String.format(Locale.US, FEATURE_NOT_SUPPORTED_MSG, category, feature));
    }

    public static final class Policy {
        private final StrictMode.ThreadPolicy mThreadPolicy;

        private Policy(StrictMode.ThreadPolicy threadPolicy) {
            this.mThreadPolicy = threadPolicy;
        }

        @TargetApi(value=26)
        private static class V26BuilderImpl
        extends V23BuilderImpl {
            V26BuilderImpl() {
            }

            V26BuilderImpl(@NonNull StrictMode.ThreadPolicy policy) {
                super(policy);
            }

            @Override
            public void detectUnbufferedIo() {
                this.builder.detectUnbufferedIo();
            }

            @Override
            public void permitUnbufferedIo() {
                this.builder.permitUnbufferedIo();
            }
        }

        @TargetApi(value=23)
        private static class V23BuilderImpl
        extends BaseBuilderImpl {
            V23BuilderImpl() {
            }

            V23BuilderImpl(@NonNull StrictMode.ThreadPolicy policy) {
                super(policy);
            }

            @Override
            public void detectResourceMismatches() {
                this.builder.detectResourceMismatches();
            }

            @Override
            public void permitResourceMismatches() {
                this.builder.permitResourceMismatches();
            }
        }

        private static class BaseBuilderImpl
        implements BuilderImpl {
            @NonNull
            final StrictMode.ThreadPolicy.Builder builder;

            BaseBuilderImpl() {
                this.builder = new StrictMode.ThreadPolicy.Builder();
            }

            BaseBuilderImpl(@NonNull StrictMode.ThreadPolicy policy) {
                this.builder = new StrictMode.ThreadPolicy.Builder(policy);
            }

            @Override
            public void detectCustomSlowCalls() {
                this.builder.detectCustomSlowCalls();
            }

            @Override
            public void penaltyDeathOnNetwork() {
                this.builder.penaltyDeathOnNetwork();
            }

            @Override
            public void penaltyFlashScreen() {
                this.builder.penaltyFlashScreen();
            }

            @Override
            public void permitCustomSlowCalls() {
                this.builder.permitCustomSlowCalls();
            }

            @Override
            public Policy build() {
                if (Build.VERSION.SDK_INT >= 28) {
                    try {
                        StrictMode.OnThreadViolationListener listener = new StrictMode.OnThreadViolationListener(){
                            ViolationTransfer28 mTransfer = new ViolationTransfer28();

                            public void onThreadViolation(Violation violation) {
                                ViolationSubject.instance().notifyViolation(this.mTransfer.transfer((Throwable)violation));
                            }
                        };
                        this.builder.penaltyListener(Global.instance().executor(), listener);
                    }
                    catch (Throwable t) {
                        Logger.throwException(t);
                    }
                } else {
                    this.builder.penaltyDropBox();
                }
                return new Policy(this.builder.build());
            }

            @Override
            public void detectAll() {
                this.builder.detectAll();
            }

            @Override
            public void detectDiskReads() {
                this.builder.detectDiskReads();
            }

            @Override
            public void detectDiskWrites() {
                this.builder.detectDiskWrites();
            }

            @Override
            public void detectNetwork() {
                this.builder.detectNetwork();
            }

            @Override
            public void penaltyDeath() {
                this.builder.penaltyDeath();
            }

            @Override
            public void penaltyDialog() {
                this.builder.penaltyDialog();
            }

            @Override
            public void penaltyDropBox() {
                this.builder.penaltyDropBox();
            }

            @Override
            public void penaltyLog() {
                this.builder.penaltyLog();
            }

            @Override
            public void permitAll() {
                this.builder.permitAll();
            }

            @Override
            public void permitDiskReads() {
                this.builder.permitDiskReads();
            }

            @Override
            public void permitDiskWrites() {
                this.builder.permitDiskWrites();
            }

            @Override
            public void permitNetwork() {
                this.builder.permitNetwork();
            }

            @Override
            public void detectResourceMismatches() {
                OlympicThreadCompat.logUnsupportedFeature("ThreadPolicy", "Resource mismatches");
            }

            @Override
            public void permitResourceMismatches() {
                OlympicThreadCompat.logUnsupportedFeature("ThreadPolicy", "Resource mismatches");
            }

            @Override
            public void detectUnbufferedIo() {
                OlympicThreadCompat.logUnsupportedFeature("ThreadPolicy", "Unbuffered IO");
            }

            @Override
            public void permitUnbufferedIo() {
                OlympicThreadCompat.logUnsupportedFeature("ThreadPolicy", "Unbuffered IO");
            }
        }

        private static interface BuilderImpl {
            public static final String CATEGORY = "ThreadPolicy";

            public Policy build();

            public void detectAll();

            public void detectCustomSlowCalls();

            public void detectDiskReads();

            public void detectDiskWrites();

            public void detectNetwork();

            public void penaltyDeath();

            public void penaltyDeathOnNetwork();

            public void penaltyDialog();

            public void penaltyDropBox();

            public void penaltyFlashScreen();

            public void penaltyLog();

            public void permitAll();

            public void permitCustomSlowCalls();

            public void permitDiskReads();

            public void permitDiskWrites();

            public void permitNetwork();

            public void detectResourceMismatches();

            public void permitResourceMismatches();

            public void detectUnbufferedIo();

            public void permitUnbufferedIo();
        }

        public static final class Builder {
            @NonNull
            private final BuilderImpl mBuilder;

            public Builder() {
                this.mBuilder = Build.VERSION.SDK_INT >= 26 ? new V26BuilderImpl() : (Build.VERSION.SDK_INT >= 23 ? new V23BuilderImpl() : new BaseBuilderImpl());
            }

            public Builder(@NonNull StrictMode.ThreadPolicy policy) {
                this.mBuilder = Build.VERSION.SDK_INT >= 26 ? new V26BuilderImpl(policy) : (Build.VERSION.SDK_INT >= 23 ? new V23BuilderImpl(policy) : new BaseBuilderImpl(policy));
            }

            public Policy build() {
                return this.mBuilder.build();
            }

            public Builder detectAll() {
                this.mBuilder.detectAll();
                return this;
            }

            public Builder detectCustomSlowCalls() {
                this.mBuilder.detectCustomSlowCalls();
                return this;
            }

            public Builder detectDiskReads() {
                this.mBuilder.detectDiskReads();
                return this;
            }

            public Builder detectDiskWrites() {
                this.mBuilder.detectDiskWrites();
                return this;
            }

            public Builder detectNetwork() {
                this.mBuilder.detectNetwork();
                return this;
            }

            public Builder detectResourceMismatches() {
                this.mBuilder.detectResourceMismatches();
                return this;
            }

            public Builder penaltyDeath() {
                this.mBuilder.penaltyDeath();
                return this;
            }

            public Builder penaltyDeathOnNetwork() {
                this.mBuilder.penaltyDeathOnNetwork();
                return this;
            }

            public Builder penaltyDialog() {
                this.mBuilder.penaltyDialog();
                return this;
            }

            public Builder penaltyDropBox() {
                this.mBuilder.penaltyDropBox();
                return this;
            }

            public Builder penaltyFlashScreen() {
                this.mBuilder.penaltyFlashScreen();
                return this;
            }

            public Builder penaltyLog() {
                this.mBuilder.penaltyLog();
                return this;
            }

            public Builder permitAll() {
                this.mBuilder.permitAll();
                return this;
            }

            public Builder permitCustomSlowCalls() {
                this.mBuilder.permitCustomSlowCalls();
                return this;
            }

            public Builder permitDiskReads() {
                this.mBuilder.permitDiskReads();
                return this;
            }

            public Builder permitDiskWrites() {
                this.mBuilder.permitDiskWrites();
                return this;
            }

            public Builder permitNetwork() {
                this.mBuilder.permitNetwork();
                return this;
            }

            public Builder permitResourceMismatches() {
                this.mBuilder.permitResourceMismatches();
                return this;
            }

            public Builder detectUnbufferedIo() {
                this.mBuilder.detectUnbufferedIo();
                return this;
            }

            public Builder permitUnbufferedIo() {
                this.mBuilder.permitUnbufferedIo();
                return this;
            }
        }
    }
}

